<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/login', 'Login::index');
$routes->get('/register', 'Register::index');
$routes->get('/get-kab-kota/(:any)', 'Front::get_kab_kota/$1');
$routes->get('/get-satuan-organisasi/(:any)', 'Front::get_satuan_organisasi/$1');
$routes->post('/register/proses', 'Register::proses');
$routes->get('/login', 'Login::index');
$routes->get('/login/proses', 'Login::proses');
$routes->post('/logout', 'Login::logout');
$routes->post('/GetDataPegawai', 'Register::GetDataPegawai');
$routes->get('forget-password', 'Login::forget_password');
$routes->get('_index_reset_password', 'Login::index_reset_password');
$routes->post('reset-password', 'Login::reset_password');
$routes->post('proses-reset-password', 'Login::proses_reset_password');
$routes->get('remove-sess-all-data', 'Home::remove_all_session');

$routes->get('/berita', 'Berita::index_berita');
$routes->get('/berita/(:any)', 'Berita::detail_berita/$1');

$routes->get('/informasi_publik', 'InformasiPublik::index_informasi_publik');
$routes->get('/informasi_publik/(:any)', 'InformasiPublik::detail_informasi_publik/$1');

$routes->get('/petunjuk_teknis', 'PetunjukTeknis::index_petunjuk_teknis');
$routes->get('/petunjuk_teknis/(:any)', 'PetunjukTeknis::detail_petunjuk_teknis/$1');

$routes->get('/integrasi_layanan', 'IntegrasiLayanan::index_integrasi_layanan');
$routes->get('/integrasi_layanan/(:any)', 'IntegrasiLayanan::detail_integrasi_layanan/$1');

$routes->get('/get-inovasi', 'SidikJariApiController::proses_inovasi');


$routes->group('admin', ['filter' => 'usersAuth'], function($routes) {
    $routes->get('dashboard', 'Dashboard::index');
    $routes->get('dashboard/get_data_urusa_utama', 'Dashboard::get_data_urusa_utama');
    $routes->get('profile_pendaftar', 'ProfilePendaftar::index');
    $routes->get('profile_pendaftar/detail/(:any)', 'ProfilePendaftar::detail/$1');
    $routes->get('profile_pendaftar/tambah_tim/(:any)', 'ProfilePendaftar::tambah_tim/$1');
    $routes->get('profile_pendaftar/edit_tim/(:any)', 'ProfilePendaftar::edit_tim/$1');
    $routes->get('profile_pendaftar/delete_tim/(:any)', 'ProfilePendaftar::delete_tim/$1');
    $routes->get('profile_pendaftar/detail_tim/(:any)', 'ProfilePendaftar::detail_tim/$1');
    $routes->post('profile_pendaftar/get_data', 'ProfilePendaftar::get_data');
    $routes->post('profile_pendaftar/simpan_tim', 'ProfilePendaftar::simpan_tim');
    $routes->post('profile_pendaftar/update_tim', 'ProfilePendaftar::update_tim');
    $routes->post('profile_pendaftar/update_profile', 'ProfilePendaftar::update_profile');
    $routes->post('profile_pendaftar/update_password', 'ProfilePendaftar::update_password');
    $routes->get('proposal_inovasi', 'ProposalInovasi::index');
    $routes->post('proposal_inovasi/get_data', 'ProposalInovasi::get_data');
    $routes->post('proposal_inovasi/get_data_tim/(:any)', 'ProposalInovasi::get_data_tim/$1');
    $routes->post('proposal_inovasi/get_data_tim2/(:any)', 'ProposalInovasi::get_data_tim2/$1');
    $routes->post('proposal_inovasi/simpan', 'ProposalInovasi::simpan');
    $routes->post('proposal_inovasi/update', 'ProposalInovasi::update');
    $routes->get('proposal_inovasi/tambah', 'ProposalInovasi::tambah');
    $routes->get('proposal_inovasi/edit/(:any)', 'ProposalInovasi::edit/$1');
    $routes->get('proposal_inovasi/detail/(:any)', 'ProposalInovasi::detail/$1');
    $routes->get('proposal_inovasi/hapus/(:any)', 'ProposalInovasi::hapus/$1');
    $routes->get('proposal_inovasi/indikator/(:any)', 'ProposalInovasi::indikator/$1');
    $routes->post('proposal_inovasi/kirim', 'ProposalInovasi::kirim');
    $routes->post('proposal_inovasi/kirim_ta', 'ProposalInovasi::kirim_ta');
    $routes->post('proposal_inovasi/kirim_tr', 'ProposalInovasi::kirim_tr');
    $routes->post('proposal_inovasi/kirim_tj', 'ProposalInovasi::kirim_tj');
    $routes->post('proposal_inovasi/indikator/simpan_parameter', 'ProposalInovasi::simpan_parameter');
    $routes->get('proposal_inovasi/get_parameter/(:any)', 'ProposalInovasi::parameter_by_indikator/$1');
    $routes->get('proposal_inovasi/data_pendukung', 'ProposalInovasi::data_pendukung');
    $routes->get('proposal_inovasi/data_pendukung/tambah', 'ProposalInovasi::tambah_data_pendukung');
    $routes->get('proposal_inovasi/data_pendukung/edit', 'ProposalInovasi::edit_data_pendukung');
    $routes->get('proposal_inovasi/data_pendukung/hapus', 'ProposalInovasi::hapus_data_pendukung');
    $routes->get('proposal_inovasi/download/(:any)', 'ProposalInovasi::download/$1');
    $routes->get('proposal_inovasi/pemberian_nilai/(:any)', 'ProposalInovasi::pemberian_nilai/$1');
    $routes->post('proposal_inovasi/data_pendukung/simpan', 'ProposalInovasi::simpan_data_pendukung');
    $routes->post('proposal_inovasi/data_pendukung/update', 'ProposalInovasi::update_data_pendukung');
    $routes->post('proposal_inovasi/simpan_penilaian', 'ProposalInovasi::simpan_penilaian');
    $routes->get('laporan', 'Laporan::index');
    $routes->post('laporan/(:any)', 'Laporan::get_data/$1');
    $routes->get('laporan/export/(:any)', 'Laporan::export/$1');
    $routes->get('proposal_inovasi/TA', 'ProposalInovasi::indexTA');
    $routes->get('proposal_inovasi/TR', 'ProposalInovasi::indexTR');
    $routes->get('proposal_inovasi/TR2', 'ProposalInovasi::indexTR2');
    $routes->get('proposal_inovasi/TJ', 'ProposalInovasi::indexTJ');
    $routes->get('proposal_inovasi/get_urusan_utama_detail/(:any)', 'ProposalInovasi::get_urusan_utama_detail/$1');
    $routes->get('proposal_inovasi/review_inovasi_daerah', 'ProposalInovasi::review_inovasi_daerah');    
    $routes->get('proposal_inovasi/hasil_review', 'ProposalInovasi::hasil_review');    
    $routes->get('proposal_inovasi/inovasi_ditolak', 'ProposalInovasi::inovasi_ditolak');    
    $routes->get('proposal_inovasi/presentasi', 'ProposalInovasi::presentasi');    
    $routes->get('proposal_inovasi/validasi_lapangan', 'ProposalInovasi::validasi_lapangan');  
    $routes->get('proposal_inovasi/export', 'ProposalInovasi::export');  
    $routes->post('proposal_inovasi/update_bintang', 'ProposalInovasi::update_bintang');
    $routes->get('proposal_inovasi/inovasi_berbintang', 'ProposalInovasi::inovasi_berbintang');
    $routes->get('proposal_inovasi/download_zip/(:any)', 'ProposalInovasi::download_zip/$1');

    //Indikator
    $routes->get('indikator', 'Indikator::index');
    $routes->post('indikator/get_data', 'Indikator::get_data');
    $routes->post('indikator/simpan', 'Indikator::simpan');
    $routes->get('indikator/edit/(:any)', 'Indikator::edit/$1');
    $routes->get('indikator/hapus/(:any)', 'Indikator::hapus/$1');

    //Provinsi
    $routes->get('provinsi', 'Provinsi::index');
    $routes->post('provinsi/get_data', 'Provinsi::get_data');
    $routes->post('provinsi/simpan', 'Provinsi::simpan');
    $routes->get('provinsi/edit/(:any)', 'Provinsi::edit/$1');
    $routes->get('provinsi/hapus/(:any)', 'Provinsi::hapus/$1');

    //Akun
    $routes->get('akun', 'User::index');
    $routes->post('akun/get_data', 'User::get_data');
    $routes->post('akun/simpan', 'User::simpan');
    $routes->get('akun/edit/(:any)', 'User::edit/$1');
    $routes->get('akun/hapus/(:any)', 'User::hapus/$1');

    //Parameter
    $routes->get('parameter', 'Parameter::index');
    $routes->post('parameter/get_data', 'Parameter::get_data');
    $routes->post('parameter/simpan', 'Parameter::simpan');
    $routes->get('parameter/edit/(:any)', 'Parameter::edit/$1');
    $routes->get('parameter/hapus/(:any)', 'Parameter::hapus/$1');

    //Kabupaten
    $routes->get('kabupaten', 'Kabupaten::index');
    $routes->post('kabupaten/get_data', 'Kabupaten::get_data');
    $routes->post('kabupaten/simpan', 'Kabupaten::simpan');
    $routes->get('kabupaten/edit/(:any)', 'Kabupaten::edit/$1');
    $routes->get('kabupaten/hapus/(:any)', 'Kabupaten::hapus/$1');

    //Carousel
    $routes->get('carousel', 'Carousel::index');
    $routes->post('carousel/get_data', 'Carousel::get_data');
    $routes->post('carousel/simpan', 'Carousel::simpan');
    $routes->get('carousel/edit/(:any)', 'Carousel::edit/$1');
    $routes->get('carousel/hapus/(:any)', 'Carousel::hapus/$1');

    //Konten Home
    $routes->get('konten_home', 'Home::index_konten');
    $routes->post('konten_home/get_data', 'Home::get_data');
    $routes->post('konten_home/simpan', 'Home::simpan');
    $routes->get('konten_home/edit/(:any)', 'Home::edit/$1');
    $routes->get('konten_home/hapus/(:any)', 'Home::hapus/$1');
    
    //Bentuk Inovasi Daerah
    $routes->get('bentuk_inovasi_daerah', 'BentukInovasiDaerah::index');
    $routes->post('bentuk_inovasi_daerah/get_data', 'BentukInovasiDaerah::get_data');
    $routes->post('bentuk_inovasi_daerah/simpan', 'BentukInovasiDaerah::simpan');
    $routes->get('bentuk_inovasi_daerah/edit/(:any)', 'BentukInovasiDaerah::edit/$1');
    $routes->get('bentuk_inovasi_daerah/hapus/(:any)', 'BentukInovasiDaerah::hapus/$1');

    //Urusan Utama
    $routes->get('urusan_utama', 'UrusanUtama::index');
    $routes->post('urusan_utama/get_data', 'UrusanUtama::get_data');
    $routes->post('urusan_utama/simpan', 'UrusanUtama::simpan');
    $routes->get('urusan_utama/edit/(:any)', 'UrusanUtama::edit/$1');
    $routes->get('urusan_utama/hapus/(:any)', 'UrusanUtama::hapus/$1');

    //Urusan Utama Detail
    $routes->get('urusan_utama_detail', 'UrusanUtamaDetail::index');
    $routes->post('urusan_utama_detail/get_data', 'UrusanUtamaDetail::get_data');
    $routes->post('urusan_utama_detail/simpan', 'UrusanUtamaDetail::simpan');
    $routes->get('urusan_utama_detail/edit/(:any)', 'UrusanUtamaDetail::edit/$1');
    $routes->get('urusan_utama_detail/hapus/(:any)', 'UrusanUtamaDetail::hapus/$1');

    //Aspek Penilaian
    $routes->get('aspek_penilaian', 'AspekPenilaian::index');
    $routes->post('aspek_penilaian/get_data', 'AspekPenilaian::get_data');
    $routes->post('aspek_penilaian/simpan', 'AspekPenilaian::simpan');
    $routes->get('aspek_penilaian/edit/(:any)', 'AspekPenilaian::edit/$1');
    $routes->get('aspek_penilaian/hapus/(:any)', 'AspekPenilaian::hapus/$1');

    //Report
    $routes->get('report/lomba_inovasi', 'Report::index_lomba_inovasi');
    $routes->get('report/ranking_inovasi', 'Report::index_ranking_inovasi');
    $routes->get('report/export/(:any)', 'Report::export/$1');
    $routes->get('report/detail/(:any)', 'Report::detail/$1');
    $routes->post('report/get_data', 'Report::get_data');
    $routes->post('report/get_data_lomba', 'Report::get_data_lomba');

    //Berita
    $routes->get('berita', 'Berita::index');
    $routes->get('berita/tambah', 'Berita::tambah');
    $routes->post('berita/simpan', 'Berita::simpan');
    $routes->post('berita/update', 'Berita::update');
    $routes->get('berita/edit/(:any)', 'Berita::edit/$1');
    $routes->get('berita/hapus/(:any)', 'Berita::hapus/$1');

    //InformasiPublik
    $routes->get('informasi_publik', 'InformasiPublik::index');
    $routes->get('informasi_publik/tambah', 'InformasiPublik::tambah');
    $routes->post('informasi_publik/simpan', 'InformasiPublik::simpan');
    $routes->post('informasi_publik/update', 'InformasiPublik::update');
    $routes->get('informasi_publik/edit/(:any)', 'InformasiPublik::edit/$1');
    $routes->get('informasi_publik/hapus/(:any)', 'InformasiPublik::hapus/$1');

    //PetunjukTeknis
    $routes->get('petunjuk_teknis', 'PetunjukTeknis::index');
    $routes->get('petunjuk_teknis/tambah', 'PetunjukTeknis::tambah');
    $routes->post('petunjuk_teknis/simpan', 'PetunjukTeknis::simpan');
    $routes->post('petunjuk_teknis/update', 'PetunjukTeknis::update');
    $routes->get('petunjuk_teknis/edit/(:any)', 'PetunjukTeknis::edit/$1');
    $routes->get('petunjuk_teknis/hapus/(:any)', 'PetunjukTeknis::hapus/$1');

    //IntegrasiLayanan
    $routes->get('integrasi_layanan', 'IntegrasiLayanan::index');
    $routes->get('integrasi_layanan/tambah', 'IntegrasiLayanan::tambah');
    $routes->post('integrasi_layanan/simpan', 'IntegrasiLayanan::simpan');
    $routes->post('integrasi_layanan/update', 'IntegrasiLayanan::update');
    $routes->get('integrasi_layanan/edit/(:any)', 'IntegrasiLayanan::edit/$1');
    $routes->get('integrasi_layanan/hapus/(:any)', 'IntegrasiLayanan::hapus/$1');

    //monev
    $routes->get('monev_inovasi', 'MonevInovasi::index');
    $routes->get('monev_inovasi/export', 'MonevInovasi::export');

    //Data Riset
    $routes->get('data_riset', 'DataRiset::index');
    $routes->get('data_riset/tambah', 'DataRiset::tambah');

    $routes->post('proposal_inovasi/get_data_inovasi_iga', 'ProposalInovasi::get_data_inovasi_iga');
    $routes->get('proposal_inovasi/indikator_iga/(:any)', 'ProposalInovasi::indikator_iga/$1');
    $routes->post('proposal_inovasi/indikator/simpan_parameter_iga', 'ProposalInovasi::simpan_parameter_iga');

    //Jenis Kegiatan
    $routes->get('jenis_kegiatan', 'JenisKegiatan::index');
    $routes->post('jenis_kegiatan/get_data', 'JenisKegiatan::get_data');
    $routes->post('jenis_kegiatan/simpan', 'JenisKegiatan::simpan');
    $routes->get('jenis_kegiatan/edit/(:any)', 'JenisKegiatan::edit/$1');
    $routes->get('jenis_kegiatan/hapus/(:any)', 'JenisKegiatan::hapus/$1');

    //Kegiatan
    $routes->get('kegiatan', 'Kegiatan::index');
    $routes->post('kegiatan/get_data', 'Kegiatan::get_data');
    $routes->get('kegiatan/tambah', 'Kegiatan::tambah');
    $routes->post('kegiatan/simpan', 'Kegiatan::simpan');
    $routes->post('kegiatan/update_bintang', 'Kegiatan::update_bintang');
    $routes->get('kegiatan/edit/(:any)', 'Kegiatan::edit/$1');
    $routes->post('kegiatan/update', 'Kegiatan::update');
    $routes->get('kegiatan/hapus/(:any)', 'Kegiatan::hapus/$1');
    $routes->get('kegiatan/detail/(:any)', 'Kegiatan::detail/$1');
    $routes->post('kegiatan/kirim', 'Kegiatan::kirim');
    $routes->get('kegiatan/koordinator', 'Kegiatan::index_koordinator');
    $routes->get('kegiatan/anggota', 'Kegiatan::index_anggota');
    $routes->get('kegiatan/kepala_bidang', 'Kegiatan::index_kepala_bidang');
    $routes->get('kegiatan/dashboard_eksekutif', 'Kegiatan::index_dashboard_eksekutif');
    $routes->post('kegiatan/get_data_koordinator', 'Kegiatan::get_data_koordinator');
    $routes->post('kegiatan/get_data_anggota', 'Kegiatan::get_data_anggota');
    $routes->post('kegiatan/get_data_kepala_bidang', 'Kegiatan::get_data_kepala_bidang');
    $routes->post('kegiatan/get_data_dashboard_eksekutif', 'Kegiatan::get_data_dashboard_eksekutif');

    $routes->get('get_anggota_by_koordinator/(:any)', 'Kegiatan::get_anggota_by_koordinator/$1');
});

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
