<?php

namespace App\Controllers;

use App\Models\CarouselModel;
use CodeIgniter\HTTP\RequestInterface;
use Config\Services;

class Carousel extends BaseController
{
    public function index()
    {
        return view('carousel/index');
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new CarouselModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = '<img src="'.base_url('uploads/carousel/'.$list->file).'" width="150" height="75" >';
                        $row[] = $list->keterangan;
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $keterangan = $this->request->getVar('keterangan');

        $model = new CarouselModel();

        if($id != 0)
        {
            $dataFoto = $this->request->getFile('file');

            if($dataFoto->isValid())
            {
                $fileName = $dataFoto->getRandomName();
                $dataFoto->move('uploads/carousel/', $fileName);

                //Update
                $model->update($id, [
                    'file' => $fileName,
                    'keterangan' => $keterangan,
                ]);
            }
            else
            {
                //Update
                $model->update($id, [
                    'keterangan' => $keterangan,
                ]);
            }
            
        }
        else
        {
            $dataFoto = $this->request->getFile('file');
            $fileName = $dataFoto->getRandomName();
            $dataFoto->move('uploads/carousel/', $fileName);

            //Create
            $model->insert([
                'file' => $fileName,
                'keterangan' => $keterangan,
            ]);
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new CarouselModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new CarouselModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
