<?php

namespace App\Controllers;
use App\Models\ProposalInovasiModel;
use App\Models\IndikatorModel;
use App\Models\ParameterModel;
use App\Models\ProsesSirkulasiModel;
use App\Models\ProposalIndikatorDataPendukungModel;
use App\Models\ProposalIndikatorModel;
use App\Models\AspekPenilaianIndikatorModel;
use App\Models\AspekPenilaianModel;
use App\Models\PenilaianModel;
use App\Models\PenilaianSummaryModel;
use App\Helpers\InovakesHelper;
use Config\Services;
use App\Models\UserModel;
use App\Models\BentukInovasiDaerahModel;
use App\Models\UrusanUtamaModel;
use App\Models\UrusanUtamaDetailModel;
use App\Models\ProposalUrusanUtamaDetailModel;
use App\Models\ProposalUrusanUtamaModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use ZipArchive;

use App\Controllers\BaseController;

class DataRiset extends BaseController
{
    public function index()
    {
        $model = new ProposalInovasiModel();
        $tahun = $model->select('YEAR(`waktu_penerapan`) as tahun')->groupBy('YEAR(`waktu_penerapan`)')->findAll();
        
        $data['tahun'] = $tahun;
        return view('data_riset/index', $data);      
    }

    public function tambah()
    {
        $bentuk_inovasi = new BentukInovasiDaerahModel();
        $urusan_utama = new UrusanUtamaModel();

        $data['bentuk_inovasi_daerah'] = $bentuk_inovasi->findAll();
        $data['urusan_utama'] = $urusan_utama->findAll();
        return view('data_riset/tambah', $data);
    }
}
