<?php

namespace App\Controllers;

use App\Models\IndikatorModel;
use Config\Services;

class Indikator extends BaseController
{
    public function index()
    {
        return view('indikator/index');
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new IndikatorModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $list->nama;
                        $row[] = $list->bobot;
                        $row[] = $list->jenis;
                        $row[] = $list->jenis_file;
                        $row[] = $list->keterangan;
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $nama = $this->request->getVar('nama');
        $bobot = $this->request->getVar('bobot');
        $keterangan = $this->request->getVar('keterangan');
        $jenis = $this->request->getVar('jenis');
        $jenis_file = $this->request->getVar('jenis_file');
        $keterangan_data_pendukung = $this->request->getVar('keterangan_data_pendukung');
        $indeks_inovasi_required  = $this->request->getVar('indeks_inovasi_required');
        $lomba_inovasi_required = $this->request->getVar('lomba_inovasi_required');
        $proper_required = $this->request->getVar('proper_required');
        $model = new IndikatorModel();

        if($id != 0)
        {
            //Update
            $model->update($id, [
                'nama' => $nama,
                'bobot' => $bobot,
                'keterangan' => $keterangan,
                'jenis' => $jenis,
                'jenis_file' => $jenis_file,
                'keterangan_data_pendukung' => $keterangan_data_pendukung,                
                'lomba_inovasi_required' => $lomba_inovasi_required,
                'proper_required' => $proper_required,
                'indeks_inovasi_required' => $indeks_inovasi_required,
            ]);
        }
        else
        {
            //Create
            $model->insert([
                'nama' => $nama,
                'bobot' => $bobot,
                'keterangan' => $keterangan,
                'jenis' => $jenis,
                'jenis_file' => $jenis_file,
                'keterangan_data_pendukung' => $keterangan_data_pendukung,
                'lomba_inovasi_required' => $lomba_inovasi_required,
                'proper_required' => $proper_required,
                'indeks_inovasi_required' => $indeks_inovasi_required,
            ]);
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new IndikatorModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new IndikatorModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
