<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\IntegrasiLayananModel;

class IntegrasiLayanan extends BaseController
{
    public function index()
    {
        $model_integrasi_layanan = new IntegrasiLayananModel;
        $integrasi_layanan = $model_integrasi_layanan->findAll();

        $data['integrasi_layanan'] = $integrasi_layanan;
        return view('integrasi_layanan/index', $data);
    }

    public function tambah()
    {
        return view('integrasi_layanan/tambah');
    }

    public function simpan()
    {
        $fileName_gambar = null;
        $data_file_gambar = $this->request->getFile('gambar');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = "gambar_integrasi_layanan_".$data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/gambar_integrasi_layanan/', $fileName_gambar);
            } 
        }

        $users = new IntegrasiLayananModel();
        $users->insert([
            'judul' => $this->request->getVar('judul'),
            'konten' => $this->request->getVar('konten'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'gambar' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);
              

        session()->setFlashdata('success', "Data berhasil disimpan");

        return redirect()->to(base_url('admin/integrasi_layanan'));
    }

    public function edit($id)
    {
        $data = new IntegrasiLayananModel();
        $integrasi_layanan = $data->where('id', $id)->first();
        $param['integrasi_layanan'] = $integrasi_layanan;
        return view('integrasi_layanan/edit', $param);
    }

    public function update()
    {
        $id = $this->request->getVar('id');
        $fileName_gambar = $this->request->getVar('nama_file_gambar');    

        $data_file_gambar = $this->request->getFile('gambar');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = $data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/gambar_integrasi_layanan/', $fileName_gambar);
            }
        } 

        $users = new IntegrasiLayananModel();
        $users->update($id, [
            'judul' => $this->request->getVar('judul'),
            'konten' => $this->request->getVar('konten'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'gambar' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);

        session()->setFlashdata('success', "Data berhasil diupdate");

        return redirect()->to(base_url('admin/integrasi_layanan'));
    }

    public function hapus($id)
    {
        $user = new IntegrasiLayananModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function index_integrasi_layanan()
    {
        $model_integrasi_layanan = new IntegrasiLayananModel;
        $integrasi_layanan = $model_integrasi_layanan
                    ->select('integrasi_layanan.*, u.name as nama_user')
                    ->join('user as u','integrasi_layanan.created_by = u.id')
                    ->where('integrasi_layanan.is_aktif', 1);

        $data['integrasi_layanan'] = $integrasi_layanan->paginate(30);
        $data['pager'] = $integrasi_layanan->pager;
        return view('front/index_integrasi_layanan', $data);
    }

    public function detail_integrasi_layanan($id)
    {
        $model_integrasi_layanan = new IntegrasiLayananModel;
        $integrasi_layanan = $model_integrasi_layanan
                    ->select('integrasi_layanan.*, u.name as nama_user')
                    ->join('user as u','integrasi_layanan.created_by = u.id')
                    ->where('integrasi_layanan.id', $id);

        $data['integrasi_layanan'] = $integrasi_layanan->first();
        return view('front/detail_integrasi_layanan', $data);
    }
}
