<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\JenisKegiatanModel;
use Config\Services;

class JenisKegiatan extends BaseController
{
    public function index()
    {
        return view('jenis_kegiatan/index');
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new JenisKegiatanModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $list->nama;
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $name = $this->request->getVar('nama');

        $model = new JenisKegiatanModel();

        if($id != 0)
        {
            //Update
            $model->update($id, [
                'nama' => $name,
            ]);
        }
        else
        {
            //Create
            $model->insert([
                'nama' => $name,
            ]);
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new JenisKegiatanModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new JenisKegiatanModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
