<?php

namespace App\Controllers;

use App\Models\ProvinsiModel;
use App\Models\KabupatenModel;
use Config\Services;

class Kabupaten extends BaseController
{
    public function index()
    {
        $model = new ProvinsiModel();

        $param['provinsi'] = $model->findAll();
        return view('kabupaten/index', $param);
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new KabupatenModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $list->nama_provinsi;
                        $row[] = $list->nama_kabupaten;
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $province_id = $this->request->getVar('province_id');
        $name = $this->request->getVar('name');

        $model = new KabupatenModel();

        if($id != 0)
        {
            //Update
            $model->update($id, [
                'name' => $name,
                'province_id' => $province_id,
            ]);
        }
        else
        {
            //Create
            $model->insert([
                'name' => $name,
                'province_id' => $province_id,
            ]);
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new KabupatenModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new KabupatenModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
