<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\KegiatanModel;
use App\Models\UserModel;
use Config\Services;

class Kegiatan extends BaseController
{
    public function index()
    {
        return view('kegiatan/index');      
    }

    public function index_koordinator()
    {
        return view('kegiatan/index_koordinator');      
    }

    public function index_anggota()
    {
        return view('kegiatan/index_anggota');      
    }

    public function index_kepala_bidang()
    {
        return view('kegiatan/index_kepala_bidang');      
    }

    public function index_dashboard_eksekutif()
    {
        return view('kegiatan/index_dashboard_eksekutif');      
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new KegiatanModel($request);
        // if(in_array(session()->get('id_hak_akses'), [7,8,9,10])) //Pegawai
        // {
        //     $data = new ProposalInovasiModel($request, session()->get('user_id'), 0, 0, $_GET['sumber'], $_GET['status']);
        // }
        // else
        // {
        //     $data = new ProposalInovasiModel($request, 0, 0, 0, $_GET['sumber'], $_GET['status']);
        // }
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
            $datas = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                    
                $no++;
                $row = [];

                if($list->status == "SELESAI")
                {
                    $row[] = $no.' <i class="fas fa-check-circle text-success" title="Selesai"></i>';
                }
                else
                {
                    $row[] = $no;
                }

                $aksi = '<a href="'.base_url('admin/kegiatan/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                <a href="'.base_url('admin/kegiatan/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    $aksi .= '<a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                }

                if($list->status == "DRAFT")
                {
                    $aksi .= '<a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.',1)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-location-arrow"></i></a>';
                }

                $row[] = $aksi;                
                // $row[] = '<a href="#" class="btn btn-primary btn-sm">Lampiran</a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    if($list->bintang == 1)
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(0,'.$list->id.')" style="text-decoration:none;"><i class="fas fa-star text-warning"></i></a>';
                    }
                    else
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(1,'.$list->id.')" style="text-decoration:none;"><i class="far fa-star"></i></a>';
                    }
                }
                else
                {
                    $row[] = '<label>-</label>';
                }
                
                $row[] = $list->nama;
                $row[] = $list->jenis_tugas;
                $row[] = $list->sifat;
                $row[] = date('d M Y', strtotime($list->tanggal_mulai));
                $row[] = date('d M Y', strtotime($list->tanggal_selesai));
                $row[] = $list->status;                
                $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function get_data_koordinator()
    {
        $request = Services::request();
        $data = new KegiatanModel($request, "KOORDINATOR");
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
            $datas = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                    
                $no++;
                $row = [];

                if($list->status == "SELESAI")
                {
                    $row[] = $no.' <i class="fas fa-check-circle text-success" title="Selesai"></i>';
                }
                else
                {
                    $row[] = $no;
                }

                $aksi = '<a href="'.base_url('admin/kegiatan/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                <a href="'.base_url('admin/kegiatan/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                <a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.',1)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-location-arrow"></i></a>
                                <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-undo"></i></a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    $aksi .= '<a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                }

                $row[] = $aksi;                
                // $row[] = '<a href="#" class="btn btn-primary btn-sm">Lampiran</a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    if($list->bintang == 1)
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(0,'.$list->id.')" style="text-decoration:none;"><i class="fas fa-star text-warning"></i></a>';
                    }
                    else
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(1,'.$list->id.')" style="text-decoration:none;"><i class="far fa-star"></i></a>';
                    }
                }
                else
                {
                    $row[] = '<label>-</label>';
                }
                
                $row[] = $list->nama;
                $row[] = $list->jenis_tugas;
                $row[] = $list->sifat;
                $row[] = date('d M Y', strtotime($list->tanggal_mulai));
                $row[] = date('d M Y', strtotime($list->tanggal_selesai));            
                $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function get_data_anggota()
    {
        $request = Services::request();
        $data = new KegiatanModel($request, "ANGGOTA");
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
            $datas = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                    
                $no++;
                $row = [];

                if($list->status == "SELESAI")
                {
                    $row[] = $no.' <i class="fas fa-check-circle text-success" title="Selesai"></i>';
                }
                else
                {
                    $row[] = $no;
                }

                $aksi = '<a href="'.base_url('admin/kegiatan/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                <a href="'.base_url('admin/kegiatan/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                <a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.',1)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-location-arrow"></i></a>
                                <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-undo"></i></a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    $aksi .= '<a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                }

                $row[] = $aksi;                
                // $row[] = '<a href="#" class="btn btn-primary btn-sm">Lampiran</a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    if($list->bintang == 1)
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(0,'.$list->id.')" style="text-decoration:none;"><i class="fas fa-star text-warning"></i></a>';
                    }
                    else
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(1,'.$list->id.')" style="text-decoration:none;"><i class="far fa-star"></i></a>';
                    }
                }
                else
                {
                    $row[] = '<label>-</label>';
                }
                
                $row[] = $list->nama;
                $row[] = $list->jenis_tugas;
                $row[] = $list->sifat;
                $row[] = date('d M Y', strtotime($list->tanggal_mulai));
                $row[] = date('d M Y', strtotime($list->tanggal_selesai));            
                $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function get_data_kepala_bidang()
    {
        $request = Services::request();
        $data = new KegiatanModel($request, "KEPALA BIDANG");
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
            $datas = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                    
                $no++;
                $row = [];

                if($list->status == "SELESAI")
                {
                    $row[] = $no.' <i class="fas fa-check-circle text-success" title="Selesai"></i>';
                }
                else
                {
                    $row[] = $no;
                }

                $aksi = '<a href="'.base_url('admin/kegiatan/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                <a href="'.base_url('admin/kegiatan/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                <a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.',1)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-location-arrow"></i></a>
                                <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)" style="display: '.($list->bintang == 1 ? "none" : "").'"><i class="fas fa-undo"></i></a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    $aksi .= '<a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                }

                $row[] = $aksi;                
                // $row[] = '<a href="#" class="btn btn-primary btn-sm">Lampiran</a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    if($list->bintang == 1)
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(0,'.$list->id.')" style="text-decoration:none;"><i class="fas fa-star text-warning"></i></a>';
                    }
                    else
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(1,'.$list->id.')" style="text-decoration:none;"><i class="far fa-star"></i></a>';
                    }
                }
                else
                {
                    $row[] = '<label>-</label>';
                }
                
                $row[] = $list->nama;
                $row[] = $list->jenis_tugas;
                $row[] = $list->sifat;
                $row[] = date('d M Y', strtotime($list->tanggal_mulai));
                $row[] = date('d M Y', strtotime($list->tanggal_selesai));             
                $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function get_data_dashboard_eksekutif()
    {
        $request = Services::request();
        $data = new KegiatanModel($request, null, true);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
            $datas = [];
            $no = $request->getPost("start");
            foreach ($lists as $list) {
                    
                $no++;
                $row = [];

                if($list->status == "SELESAI")
                {
                    $row[] = $no.' <i class="fas fa-check-circle text-success" title="Selesai"></i>';
                }
                else
                {
                    $row[] = $no;
                }

                $aksi = '<a href="'.base_url('admin/kegiatan/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                <a href="'.base_url('admin/kegiatan/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    $aksi .= '<a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                }

                $row[] = $aksi;                
                // $row[] = '<a href="#" class="btn btn-primary btn-sm">Lampiran</a>';

                if(session()->get('id_hak_akses') == 1)
                {
                    if($list->bintang == 1)
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(0,'.$list->id.')" style="text-decoration:none;"><i class="fas fa-star text-warning"></i></a>';
                    }
                    else
                    {
                        $row[] = '<a href="javascript:;" onclick="update_bintang_kegiatan(1,'.$list->id.')" style="text-decoration:none;"><i class="far fa-star"></i></a>';
                    }
                }
                else
                {
                    $row[] = '<label>-</label>';
                }
                
                $row[] = $list->nama;
                $row[] = $list->jenis_tugas;
                $row[] = $list->sifat;
                $row[] = date('d M Y', strtotime($list->tanggal_mulai));
                $row[] = date('d M Y', strtotime($list->tanggal_selesai));            
                $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function tambah()
    {
        $modelUser = new UserModel();

        $data['koordinator'] = $modelUser->where('id_hak_akses', 12)->findAll();

        return view('kegiatan/tambah', $data);
    }

    public function simpan()
    {
        $fileName_file_nota_pelayanan = null;
        $data_file_nota_pelayanan = $this->request->getFile('file_nota_pelayanan');

        if($data_file_nota_pelayanan != null)
        {
            if($data_file_nota_pelayanan->isValid())
            {
                $fileName_file_nota_pelayanan = "file_nota_pelayanan_".$data_file_nota_pelayanan->getRandomName();
                $data_file_nota_pelayanan->move('uploads/file_nota_pelayanan/', $fileName_file_nota_pelayanan);
            } 
        }

        $fileName_file_rekapitulasi = null;
        $data_file_rekapitulasi = $this->request->getFile('file_rekapitulasi');

        if($data_file_rekapitulasi != null)
        {
            if($data_file_rekapitulasi->isValid())
            {
                $fileName_file_rekapitulasi = "file_rekapitulasi_".$data_file_rekapitulasi->getRandomName();
                $data_file_rekapitulasi->move('uploads/file_rekapitulasi/', $fileName_file_rekapitulasi);
            } 
        }

        $fileName_file_kwitansi = null;
        $data_file_kwitansi = $this->request->getFile('file_kwitansi');

        if($data_file_kwitansi != null)
        {
            if($data_file_kwitansi->isValid())
            {
                $fileName_file_kwitansi = "file_kwitansi_".$data_file_kwitansi->getRandomName();
                $data_file_kwitansi->move('uploads/file_kwitansi/', $fileName_file_kwitansi);
            } 
        }

        $users = new KegiatanModel();
        $users->insert([
            'jenis_tugas' => $this->request->getVar('jenis_tugas'),
            'nama' => $this->request->getVar('nama'),
            'sifat' => $this->request->getVar('sifat'),
            'arahan_kegiatan' => $this->request->getVar('arahan_kegiatan'),
            'id_koordinator' => $this->request->getVar('id_koordinator'),
            'id_anggota' => $this->request->getVar('id_anggota') != null ? implode(",", $this->request->getVar('id_anggota')) : "",
            'tanggal_mulai' => $this->request->getVar('tanggal_mulai'),
            'tanggal_selesai' => $this->request->getVar('tanggal_selesai'),
            'arahan_kepada_ketua' => $this->request->getVar('arahan_kepada_ketua'),
            'arahan_kepada_anggota' => $this->request->getVar('arahan_kepada_anggota'),
            'file_nota_pelayanan' => $fileName_file_nota_pelayanan,
            'file_rekapitulasi' => $fileName_file_rekapitulasi,
            'file_kwitansi' => $fileName_file_kwitansi,
            'id_user' => session()->get('user_id'),
            'status' => 'DRAFT'
        ]);      

        session()->setFlashdata('success', "Data berhasil disimpan");

        return redirect()->to(base_url('admin/kegiatan'));
    }

    public function edit($id)
    {
        $data = new KegiatanModel();
        $modelUser = new UserModel();   
        $modelUserAnggota = new UserModel();        
        $kegiatan = $data->where('id', $id)->first();

        $param['kegiatan'] = $kegiatan;
        $param['koordinator'] = $modelUser->where('id_hak_akses', 12)->findAll();
        $param['anggota'] = $modelUserAnggota->select(['id','name'])->where('id_koordinator', $kegiatan->id_koordinator)->findAll();
        $param['selected_anggota'] = explode(",", $kegiatan->id_anggota);

        return view('kegiatan/edit', $param);
    }

    public function update()
    {
        $id = $this->request->getVar('id');

        $fileName_file_nota_pelayanan = $this->request->getVar('fileName_file_nota_pelayanan');
        $data_file_nota_pelayanan = $this->request->getFile('file_nota_pelayanan');

        if($data_file_nota_pelayanan != null)
        {
            if($data_file_nota_pelayanan->isValid())
            {
                $fileName_file_nota_pelayanan = "file_nota_pelayanan_".$data_file_nota_pelayanan->getRandomName();
                $data_file_nota_pelayanan->move('uploads/file_nota_pelayanan/', $fileName_file_nota_pelayanan);
            } 
        }

        $fileName_file_rekapitulasi = $this->request->getVar('fileName_file_rekapitulasi');
        $data_file_rekapitulasi = $this->request->getFile('file_rekapitulasi');

        if($data_file_rekapitulasi != null)
        {
            if($data_file_rekapitulasi->isValid())
            {
                $fileName_file_rekapitulasi = "file_rekapitulasi_".$data_file_rekapitulasi->getRandomName();
                $data_file_rekapitulasi->move('uploads/file_rekapitulasi/', $fileName_file_rekapitulasi);
            } 
        }

        $fileName_file_kwitansi = $this->request->getVar('fileName_file_kwitansi');
        $data_file_kwitansi = $this->request->getFile('file_kwitansi');

        if($data_file_kwitansi != null)
        {
            if($data_file_kwitansi->isValid())
            {
                $fileName_file_kwitansi = "file_kwitansi_".$data_file_kwitansi->getRandomName();
                $data_file_kwitansi->move('uploads/file_kwitansi/', $fileName_file_kwitansi);
            } 
        }

        $users = new KegiatanModel();
        $users->update($id, [
            'jenis_tugas' => $this->request->getVar('jenis_tugas'),
            'nama' => $this->request->getVar('nama'),
            'sifat' => $this->request->getVar('sifat'),
            'arahan_kegiatan' => $this->request->getVar('arahan_kegiatan'),
            'id_koordinator' => $this->request->getVar('id_koordinator'),
            'id_anggota' => implode(",", $this->request->getVar('id_anggota')),
            'tanggal_mulai' => $this->request->getVar('tanggal_mulai'),
            'tanggal_selesai' => $this->request->getVar('tanggal_selesai'),
            'arahan_kepada_ketua' => $this->request->getVar('arahan_kepada_ketua'),
            'arahan_kepada_anggota' => $this->request->getVar('arahan_kepada_anggota'),
            'file_nota_pelayanan' => $fileName_file_nota_pelayanan,
            'file_rekapitulasi' => $fileName_file_rekapitulasi,
            'file_kwitansi' => $fileName_file_kwitansi
        ]);

        session()->setFlashdata('success', "Data berhasil diupdate");

        return redirect()->to(base_url('admin/kegiatan'));
    }

    public function detail($id)
    {
        $modelUser = new UserModel();   
        $modelUserAnggota = new UserModel(); 
        $data = new KegiatanModel();
        $kegiatan = $data->where('id', $id)->first();

        $anggota = $modelUserAnggota->select('name')->whereIn('id', explode(",", $kegiatan->id_anggota))->findAll();

        $arr_anggota = [];

        foreach ($anggota as $val) {
            $arr_anggota[] = $val->name;
        }

        $param['kegiatan'] = $kegiatan;
        $param['koordinator'] = $modelUser->where('id', $kegiatan->id_koordinator)->first();
        $param['anggota'] = implode(",", $arr_anggota);

        return view('kegiatan/detail', $param);
    }

    public function hapus($id)
    {
        $user = new KegiatanModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function get_anggota_by_koordinator($id_koordinator)
    {
        $modelUser = new UserModel();
        $data = $modelUser->select(['id','name'])->where('id_koordinator', $id_koordinator)->findAll();

        return $this->response->setJSON($data);
    }

    public function update_bintang()
    {
        $id = $this->request->getVar('id');
        $bintang = $this->request->getVar('bintang');        

        $users = new KegiatanModel();
        $users->update($id, [
            'bintang' => $bintang
        ]);

        echo json_encode("success");
    }

    public function kirim()
    {
        $id = $this->request->getVar('id');
        $status = $this->request->getVar('status');

        $data = new KegiatanModel();
        $data_status = $data->where('id', $id)->first();

        $next_status = $data_status->status;
        if($status == 1)
        {
            $pesan = "dikirim";
            if($data_status->status == "DRAFT")
            {
                $next_status = "KOORDINATOR";
            }
            else if($data_status->status == "KOORDINATOR")
            {
                $next_status = "ANGGOTA";
            }
            else if($data_status->status == "ANGGOTA")
            {
                $next_status = "KEPALA BIDANG";
            }
            else if($data_status->status == "KEPALA BIDANG")
            {
                $next_status = "SELESAI";
            }
        }
        else if($status == 2) //Dikembalikan
        {
            $pesan = "dikembalikan";

            if($data_status->status == "KOORDINATOR")
            {
                $next_status = "DRAFT";
            }
            else if($data_status->status == "KEPALA BIDANG")
            {
                $next_status = "ANGGOTA";
            }
            else if($data_status->status == "ANGGOTA")
            {
                $next_status = "KOORDINATOR";
            }
        }      
        
        $data->update($id, [
            'status' => $next_status
        ]);

        $result['IsSuccess'] = TRUE;
        $result['Message'] = "Proposal berhasil ".$pesan;

        echo json_encode($result);
    }
}
