<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\IndikatorModel;
use App\Models\ParameterModel;
use App\Models\ProposalIndikatorModel;
use App\Models\ProposalInovasiModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use ZipArchive;

class MonevInovasi extends BaseController
{
    public function index()
    {
        $model = new ProposalInovasiModel();
        $data = $model->select('u.name as nama_user')
                ->select('proposal_inovasi.judul, proposal_inovasi.skor, proposal_inovasi.skor_verifikasi')                                                     
                ->join('user as u','proposal_inovasi.user_id = u.id')
                ->where('u.id_hak_akses', 8)
                ->findAll();
                
        $result = [];
        
        foreach ($data as $key => $value) {
            $nama_user = $value->nama_user;
            $judul = ["judul" => $value->judul, "nilai_bobot" => $value->skor, "nilai_verif" => $value->skor_verifikasi];

            if (!isset($result[$nama_user])) {
                $result[$nama_user] = [
                    "nama_user" => $nama_user,
                    "inovasi" => [],
                    "arr_bobot" => [],
                    "arr_verif" => [],
                ];
            }
            
            $result[$nama_user]["inovasi"][] = $judul;
            $result[$nama_user]["arr_bobot"][] = $value->skor;
            $result[$nama_user]["arr_verif"][] = $value->skor_verifikasi;
        }
        $result = array_values($result);

        $param['data'] = $result;
        // return json_encode($result);
        return view('monev/index', $param);
    }

    public function export()
    {
        $spreadsheet = new Spreadsheet();

        $model = new ProposalInovasiModel();
        $indikator_model = new IndikatorModel();
        $proposal_indikator_model = new ProposalIndikatorModel();
        $parameter_model = new ParameterModel();

        $data = $model->select('u.name as nama_user')
        ->select('proposal_inovasi.id, proposal_inovasi.tahapan, proposal_inovasi.waktu_penerapan, proposal_inovasi.judul, proposal_inovasi.skor, proposal_inovasi.skor_verifikasi')                                                     
        ->join('user as u','proposal_inovasi.user_id = u.id')
        ->where('u.id_hak_akses', 8)
        ->findAll();

        $result = [];
        
        foreach ($data as $key => $value) {
            $nama_user = $value->nama_user;
            $judul = ["id" => $value->id, "judul" => $value->judul, "tahapan" => $value->tahapan, "waktu_penerapan" => $value->waktu_penerapan, "nilai_bobot" => $value->skor, "nilai_verif" => $value->skor_verifikasi];

            if (!isset($result[$nama_user])) {
                $result[$nama_user] = [
                    "nama_user" => $nama_user,
                    "inovasi" => [],
                    "arr_bobot" => [],
                    "arr_verif" => [],
                ];
            }
            
            $result[$nama_user]["inovasi"][] = $judul;
            $result[$nama_user]["arr_bobot"][] = $value->skor;
            $result[$nama_user]["arr_verif"][] = $value->skor_verifikasi;
        }
        $result = array_values($result);
    
        $sheet = $spreadsheet->getActiveSheet();

        $styleArrayFirstRow = [
            'font' => [
                'bold' => true
            ],
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => '888888')
            )
        ];

        $styleArraySecondRow = [
            'font' => [
                'bold' => true
            ],
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'dee0e2')
            )
        ];

        $styleWarnaMerah = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'f60002')
            )
        ];

        $styleWarnaKuning = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'f7f701')
            )
        ];

        $styleWarnaHijau = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => '66ff33')
            )
        ];

        $styleWarnaPutih = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'ffffff')
            )
        ];

        $styleWarnaAbu = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'dee0e2')
            )
        ];

        $sheet->setCellValue('A1', 'No');
        $sheet->setCellValue('B1', 'CPD - Judul Inovasi');
        $sheet->setCellValue('C1', 'Nilai Bobot');
        $sheet->setCellValue('D1', 'Nilai Verif');
        $sheet->setCellValue('E1', 'Tahapan Inovasi');
        $sheet->setCellValue('F1', 'Tanggal Penerapan');
        
        //Generate kolom berdasarkan Indikator
        $indikator = $indikator_model->findAll();
        $start_letter = "F";
        foreach($indikator as $val)
        {
            ++$start_letter;
            $sheet->setCellValue($start_letter.'1', $val->nama);
        }
         
        $rows = 2;
        $no = 1;
        foreach ($result as $val){

            $sheet->setCellValue('A' . $rows, $no++);
            $sheet->setCellValue('B' . $rows, $val['nama_user']);
            $sheet->setCellValue('C' . $rows, array_sum($val['arr_bobot']));
            $sheet->setCellValue('D' . $rows, array_sum($val['arr_verif']));
            $sheet->setCellValue('E' . $rows, "");
            $sheet->setCellValue('F' . $rows, "");

            $rows = $rows + 1;
            $nos = 1;
            foreach($val['inovasi'] as $inovasi)
            {
                $sheet->setCellValue('A' . $rows, $nos++);
                $sheet->setCellValue('B' . $rows, $inovasi['judul']);
                $sheet->setCellValue('C' . $rows, $inovasi['nilai_bobot']);
                $sheet->setCellValue('D' . $rows, $inovasi['nilai_verif']);

                $warnaTahapan = $styleWarnaPutih;
                if($inovasi['tahapan'] == "Inisiatif")
                {
                    $warnaTahapan = $styleWarnaMerah;
                }
                else if($inovasi['tahapan'] == "Penerapan")
                {
                    $warnaTahapan = $styleWarnaHijau;
                }
                else if($inovasi['tahapan'] == "Uji Coba")
                {
                    $warnaTahapan = $styleWarnaKuning;
                }

                $tahunIni = date('Y');
                $tahunPenerapan = date('Y', strtotime($inovasi['waktu_penerapan']));
                $warnaPenerapan = $styleWarnaHijau;

                if($tahunPenerapan <= ($tahunIni - 3))
                {
                    $warnaPenerapan = $styleWarnaKuning;
                }
                else if($tahunPenerapan >= $tahunIni)
                {
                    $warnaPenerapan = $styleWarnaMerah;
                }

                $sheet->setCellValue('E' . $rows, $inovasi['tahapan'])->getStyle('E' . $rows)->applyFromArray($warnaTahapan);
                $sheet->setCellValue('F' . $rows, $inovasi['waktu_penerapan'])->getStyle('F' . $rows)->applyFromArray($warnaPenerapan);

                $start_letter_val = "F";
                foreach($indikator as $vals)
                {                
                    ++$start_letter_val;
                    
                    $proposal_indikator = $proposal_indikator_model->where('id_proposal', $inovasi['id'])->where('id_indikator', $vals->id)->first();
                    if($proposal_indikator != null)
                    {
                        $parameter = $parameter_model->where('id', $proposal_indikator->id_parameter)->first();
                        $sheet->setCellValue($start_letter_val.''.$rows, ($parameter == null ? "" : $parameter->nilai))->getStyle($start_letter_val.''.$rows)->applyFromArray($this->getWarnaNilaiParameter(($parameter == null ? "" : $parameter->nilai)));
                    }
                    else{
                        $sheet->setCellValue($start_letter_val.''.$rows, "");
                    }                
                }
                
                $rows++;
            }

            $highestColumn = $sheet->getHighestColumn();
            $sheet->getStyle('A'.$rows.':'.$highestColumn.''.$rows)->applyFromArray($styleArraySecondRow);
            $sheet->getStyle('A2:'.$highestColumn.'2')->applyFromArray($styleArraySecondRow);
        } 

        $highestColumn = $sheet->getHighestColumn();

        $sheet->getStyle('A1:'.$highestColumn.'1')->applyFromArray($styleArrayFirstRow);

        $writer = new Xlsx($spreadsheet);
        header("Content-Type: application/vnd.ms-excel");
        header('Content-Disposition: attachment;filename=monev_inovasi.xlsx');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
        die();
    }

    public function getWarnaNilaiParameter($nilai)
    {
        $styleWarnaMerah = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'f60002')
            )
        ];

        $styleWarnaKuning = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'f7f701')
            )
        ];

        $styleWarnaHijau = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => '66ff33')
            )
        ];

        $styleWarnaPutih = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'ffffff')
            )
        ];

        $styleWarnaAbu = [
            'fill' => array(
                'fillType' => Fill::FILL_SOLID,
                'startColor' => array('argb' => 'dee0e2')
            )
        ];

        if($nilai == 0)
        {
            return $styleWarnaAbu;
        }
        else if($nilai == 1)
        {
            return $styleWarnaMerah;
        }
        else if($nilai == 2)
        {
            return $styleWarnaKuning;
        }
        else if($nilai == 3)
        {
            return $styleWarnaHijau;
        }
        else {
            return $styleWarnaPutih;
        }
    }
}
