<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PetunjukTeknisModel;


class PetunjukTeknis extends BaseController
{
    public function index()
    {
        $model_petunjuk_teknis = new PetunjukTeknisModel;
        $petunjuk_teknis = $model_petunjuk_teknis->findAll();

        $data['petunjuk_teknis'] = $petunjuk_teknis;
        return view('petunjuk_teknis/index', $data);
    }

    public function tambah()
    {
        return view('petunjuk_teknis/tambah');
    }

    public function simpan()
    {
        $fileName_gambar = null;
        $data_file_gambar = $this->request->getFile('file');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = "file_petunjuk_teknis_".$data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/file_petunjuk_teknis/', $fileName_gambar);
            } 
        }

        $users = new PetunjukTeknisModel();
        $users->insert([
            'nama' => $this->request->getVar('nama'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'file' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);
              

        session()->setFlashdata('success', "Data berhasil disimpan");

        return redirect()->to(base_url('admin/petunjuk_teknis'));
    }

    public function edit($id)
    {
        $data = new PetunjukTeknisModel();
        $petunjuk_teknis = $data->where('id', $id)->first();
        $param['petunjuk_teknis'] = $petunjuk_teknis;
        return view('petunjuk_teknis/edit', $param);
    }

    public function update()
    {
        $id = $this->request->getVar('id');
        $fileName_gambar = $this->request->getVar('nama_file_gambar');    

        $data_file_gambar = $this->request->getFile('file');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = $data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/file_petunjuk_teknis/', $fileName_gambar);
            }
        } 

        $users = new PetunjukTeknisModel();
        $users->update($id, [
            'nama' => $this->request->getVar('nama'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'file' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);

        session()->setFlashdata('success', "Data berhasil diupdate");

        return redirect()->to(base_url('admin/petunjuk_teknis'));
    }

    public function hapus($id)
    {
        $user = new PetunjukTeknisModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function index_petunjuk_teknis()
    {
        $model_petunjuk_teknis = new PetunjukTeknisModel;
        $petunjuk_teknis = $model_petunjuk_teknis
                    ->select('petunjuk_teknis.*, u.name as nama_user')
                    ->join('user as u','petunjuk_teknis.created_by = u.id')
                    ->where('petunjuk_teknis.is_aktif', 1);

        $data['petunjuk_teknis'] = $petunjuk_teknis->findAll();
        $data['pager'] = $petunjuk_teknis->pager;
        return view('front/index_petunjuk_teknis', $data);
    }

    public function detail_petunjuk_teknis($id)
    {
        $model_petunjuk_teknis = new PetunjukTeknisModel;
        $petunjuk_teknis = $model_petunjuk_teknis
                    ->select('petunjuk_teknis.*, u.name as nama_user')
                    ->join('user as u','petunjuk_teknis.created_by = u.id')
                    ->where('petunjuk_teknis.id', $id);

        $data['petunjuk_teknis'] = $petunjuk_teknis->first();
        return view('front/detail_petunjuk_teknis', $data);
    }
}
