<?php

namespace App\Controllers;

use Config\Services;
use App\Models\UserModel;
use App\Models\UserTimModel;
use App\Models\ProvinsiModel;
use App\Models\KabupatenModel;
use App\Models\OrganisasiModel;
use App\Models\SatuanOrganisasiModel;

class ProfilePendaftar extends BaseController
{
    public function index()
    {
        $id = session()->get('user_id');

        $data = new UserModel();
        $data_tim = new UserTimModel();
        $provinsi = new ProvinsiModel();
        $org = new OrganisasiModel();
        $kab = new KabupatenModel();
        $sat_org = new SatuanOrganisasiModel();

        $user = $data->find($id);
        $param['user'] = $user;
        $param['inisial'] = $data->inisial($user->name);
        $param['user_tim'] = $data_tim->where('user_id', $id)->findAll();
        $param['provinsi'] = $provinsi->findAll();
        $param['organisasi'] = $org->findAll();
        $param['kab'] = $kab->where('province_id', $user->id_provinsi)->findAll();
        $param['satuan_organisasi'] = $sat_org->where('id_organisasi', $user->id_organisasi)->findAll();

        return view('profile_pendaftar/index_pegawai', $param);
        // if(session()->get('id_hak_akses') != 1) //Pegawai
        // {   
        //     $id = session()->get('user_id');

        //     $data = new UserModel();
        //     $data_tim = new UserTimModel();
        //     $provinsi = new ProvinsiModel();
        //     $org = new OrganisasiModel();
        //     $kab = new KabupatenModel();
        //     $sat_org = new SatuanOrganisasiModel();

        //     $user = $data->find($id);
        //     $param['user'] = $user;
        //     $param['inisial'] = $data->inisial($user->name);
        //     $param['user_tim'] = $data_tim->where('user_id', $id)->findAll();
        //     $param['provinsi'] = $provinsi->findAll();
        //     $param['organisasi'] = $org->findAll();
        //     $param['kab'] = $kab->where('province_id', $user->id_provinsi)->findAll();
        //     $param['satuan_organisasi'] = $sat_org->where('id_organisasi', $user->id_organisasi)->findAll();

        //     return view('profile_pendaftar/index_pegawai', $param);
        // }
        // else
        // {
        //     return view('profile_pendaftar/index_admin');
        // }        
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new UserModel($request, 7);
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $no;
                        // $row[] = $list->nip;
                        $row[] = $list->name;
                        $row[] = $list->email;
                        // $row[] = $list->alamat;
                        $row[] = '<a href="'.base_url('admin/profile_pendaftar/detail/'.$list->id).'" title="Detail" class="btn btn-primary text-white">Detail</a>';
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function detail($id)
    {
        $data = new UserModel();
        $data_tim = new UserTimModel();

        $user = $data->find($id);
        $param['user'] = $user;
        $param['inisial'] = $data->inisial($user->name);
        $param['user_tim'] = $data_tim->where('user_id', $id)->findAll();
        $param['provinsi'] = $data->provinsi($user->id_provinsi);
        $param['kabupaten'] = $data->kabupaten($user->id_kabupaten);
        $param['organisasi'] = $data->organisasi($user->id_organisasi);
        $param['satuan_organisasi'] = $data->satuan_organisasi($user->id_satuan_organisasi);

        return view('profile_pendaftar/detail', $param);
    }

    public function tambah_tim($id_user)
    {
        $provinsi = new ProvinsiModel();
        $org = new OrganisasiModel();

        $data['provinsi'] = $provinsi->findAll();
        $data['organisasi'] = $org->findAll();
        $data['id_user'] = $id_user;

        //validasi cek mak tim
        $model_validasi = new UserTimModel();
        $data_validasi = $model_validasi->where('user_id', $id_user)->findAll();

        if(count($data_validasi) == 2)
        {
            session()->setFlashdata('error', "Maksimal anggota 2 orang");

            if(session()->get('id_hak_akses') == 2)
            {
                return redirect()->to(base_url('admin/profile_pendaftar'));
            }
            else
            {
                return redirect()->to(base_url('admin/profile_pendaftar/detail/'.$id_user));
            }
        }

        return view('profile_pendaftar/tambah_tim', $data);
    }

    public function simpan_tim()
    {
        $id_user = $this->request->getVar('id_user');
        $nip = $this->request->getVar('nip');

        $userModel = new UserTimModel();
        $eksis = $userModel->where('user_id', $id_user)
                    ->where('nip', $nip)
                    ->first();
        
        if ($eksis != null) 
        {
            session()->setFlashdata('error', "Data sudah terdaftar!");
            return redirect()->back()->withInput();
        }

        // $dataSKP = $this->request->getFile('file_pendukung');
        // $fileNameSKP = $dataSKP->getRandomName();
        // $dataSKP->move('uploads/file_skp/', $fileNameSKP);
        
        $dataFoto = $this->request->getFile('file_foto');
        $fileNameFoto = null;

        if($dataFoto->isValid())
        {
            $fileNameFoto = $dataFoto->getRandomName();
            $dataFoto->move('uploads/foto/', $fileNameFoto);
        }        

        $users = new UserTimModel();
        $users->insert([
            'name' => $this->request->getVar('name'),
            'email' => $this->request->getVar('email'),
            'nip' => $this->request->getVar('nip2'),
            'tanggal_lahir' => $this->request->getVar('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getVar('jenis_kelamin'),
            'id_provinsi' => $this->request->getVar('id_provinsi'),
            'id_kabupaten' => $this->request->getVar('id_kabupaten'),
            'alamat' => $this->request->getVar('alamat'),
            'no_telp' => $this->request->getVar('no_telp'),
            'id_organisasi' => $this->request->getVar('id_organisasi'),
            'id_satuan_organisasi' => $this->request->getVar('id_satuan_organisasi'),
            'user_id' => $id_user,
            'file_skp' => $this->request->getVar('dokumenskp'),
            'kd_golongan' => $this->request->getVar('kd_golongan'),
            'nama_golongan' => $this->request->getVar('nama_golongan'),
            'kepangkatan' => $this->request->getVar('kepangkatan'),
            'nama_jabatan' => $this->request->getVar('nama_jabatan'),
            'foto' => $fileNameFoto,
            'kode_organisasi' => $this->request->getVar('kode_organisasi'),
            'nama_organisasi' => $this->request->getVar('nama_organisasi'),
            'kode_satuan_kerja' => $this->request->getVar('kode_satuan_kerja'),
            'nama_satuan_kerja' => $this->request->getVar('nama_satuan_kerja')
        ]);

        session()->setFlashdata('success', "Data berhasil disimpan");

        if(session()->get('id_hak_akses') == 2)
        {
            return redirect()->to(base_url('admin/profile_pendaftar'));
        }
        else
        {
            return redirect()->to(base_url('admin/profile_pendaftar/detail/'.$id_user));
        }
    }

    public function edit_tim($id)
    {
        $provinsi = new ProvinsiModel();
        $org = new OrganisasiModel();
        $user = new UserTimModel();
        $kab = new KabupatenModel();
        $sat_org = new SatuanOrganisasiModel();

        $data_user = $user->where('id', $id)->first();

        $data['provinsi'] = $provinsi->findAll();
        $data['organisasi'] = $org->findAll();
        $data['user'] = $data_user;
        $data['kab'] = $kab->where('province_id', $data_user->id_provinsi)->findAll();
        $data['satuan_organisasi'] = $sat_org->where('id_organisasi', $data_user->id_organisasi)->findAll();

        return view('profile_pendaftar/edit_tim', $data);
    }

    public function update_tim()
    {
        $id = $this->request->getVar('id');
        $id_user = $this->request->getVar('id_user');
        $nip = $this->request->getVar('nip');

        $userModel = new UserTimModel();
        $eksis = $userModel->where('user_id', $id_user)
                    ->where('nip', $nip)
                    ->where('id !=', $id)
                    ->first();
        
        if ($eksis != null) 
        {
            session()->setFlashdata('error', "Data sudah terdaftar!");
            return redirect()->back()->withInput();
        }

        // $fileNameSKP = $this->request->getVar('nama_file_skp');
        // $dataSKP = $this->request->getFile('file_pendukung');

        // if($dataSKP->isValid())
        // {
        //     $fileNameSKP = $dataSKP->getRandomName();
		//     $dataSKP->move('uploads/file_skp/', $fileNameSKP);
        // }
        
        $fileNameFoto = $this->request->getVar('nama_foto');
        $dataFoto = $this->request->getFile('file_foto');

        if($dataFoto->isValid())
        {
            $fileNameFoto = $dataFoto->getRandomName();
		    $dataFoto->move('uploads/foto/', $fileNameFoto);
        }

        $users = new UserTimModel();
        $users->update($id, [
            'name' => $this->request->getVar('name'),
            'email' => $this->request->getVar('email'),
            'nip' => $this->request->getVar('nip2'),
            'tanggal_lahir' => $this->request->getVar('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getVar('jenis_kelamin'),
            'id_provinsi' => $this->request->getVar('id_provinsi'),
            'id_kabupaten' => $this->request->getVar('id_kabupaten'),
            'alamat' => $this->request->getVar('alamat'),
            'no_telp' => $this->request->getVar('no_telp'),
            'id_organisasi' => $this->request->getVar('id_organisasi'),
            'id_satuan_organisasi' => $this->request->getVar('id_satuan_organisasi'),
            'file_skp' => $this->request->getVar('dokumenskp'),
            'kd_golongan' => $this->request->getVar('kd_golongan'),
            'nama_golongan' => $this->request->getVar('nama_golongan'),
            'kepangkatan' => $this->request->getVar('kepangkatan'),
            'nama_jabatan' => $this->request->getVar('nama_jabatan'),
            'foto' => $fileNameFoto,
            'kode_organisasi' => $this->request->getVar('kode_organisasi'),
            'nama_organisasi' => $this->request->getVar('nama_organisasi'),
            'kode_satuan_kerja' => $this->request->getVar('kode_satuan_kerja'),
            'nama_satuan_kerja' => $this->request->getVar('nama_satuan_kerja')
        ]);

        session()->setFlashdata('success', "Data berhasil diupdate");

        if(session()->get('id_hak_akses') == 2)
        {
            return redirect()->to(base_url('admin/profile_pendaftar'));
        }
        else
        {
            return redirect()->to(base_url('admin/profile_pendaftar/detail/'.$id_user));
        }
    }

    public function delete_tim($id)
    {
        $user = new UserTimModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function detail_tim($id)
    {
        $data = new UserTimModel();
        $data_user = $data->find($id);
        $user = $data_user;
        $param['user'] = $user;
        $param['provinsi'] = $data->provinsi($data_user->id_provinsi);
        $param['kabupaten'] = $data->kabupaten($data_user->id_kabupaten);
        $param['organisasi'] = $data->organisasi($data_user->id_organisasi);
        $param['satuan_organisasi'] = $data->satuan_organisasi($data_user->id_satuan_organisasi);

        return view('profile_pendaftar/detail_tim', $param);
    }

    public function update_profile()
    {
        $id = $this->request->getVar('id');

        // $fileNameSKP = $this->request->getVar('nama_file_skp');
        // $dataSKP = $this->request->getFile('file_pendukung');

        // if($dataSKP->isValid())
        // {
        //     $fileNameSKP = $dataSKP->getRandomName();
		//     $dataSKP->move('uploads/file_skp/', $fileNameSKP);
        // }
        
        $fileNameFoto = $this->request->getVar('nama_foto');
        $dataFoto = $this->request->getFile('file_foto');

        if($dataFoto->isValid())
        {
            $fileNameFoto = $dataFoto->getRandomName();
		    $dataFoto->move('uploads/foto/', $fileNameFoto);
        }		

        $users = new UserModel();
        $users->update($id, [
            'name' => $this->request->getVar('name'),
            'email' => $this->request->getVar('email'),
            'nip' => $this->request->getVar('nip'),
            'tanggal_lahir' => $this->request->getVar('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getVar('jenis_kelamin'),
            'id_provinsi' => $this->request->getVar('id_provinsi'),
            'id_kabupaten' => $this->request->getVar('id_kabupaten'),
            'alamat' => $this->request->getVar('alamat'),
            'no_telp' => $this->request->getVar('no_telp'),
            'id_organisasi' => $this->request->getVar('id_organisasi'),
            'id_satuan_organisasi' => $this->request->getVar('id_satuan_organisasi'),
            // 'file_skp' => $fileNameSKP,
            'foto' => $fileNameFoto,
            'kd_golongan' => $this->request->getVar('kd_golongan'),
            'nama_golongan' => $this->request->getVar('nama_golongan'),
            'kepangkatan' => $this->request->getVar('kepangkatan'),
            'nama_jabatan' => $this->request->getVar('nama_jabatan'),
            'nama_organisasi' => $this->request->getVar('nama_organisasi'),
            'nama_satuan_kerja' => $this->request->getVar('nama_satuan_kerja')
        ]);

        session()->set('foto', $fileNameFoto);
        session()->setFlashdata('success', "Data berhasil diupdate");
        return redirect()->back();
    }

    public function update_password()
    {
        $id = $this->request->getVar('id_user_pwd');

        $users = new UserModel();
        $users->update($id, [
            'password' => password_hash($this->request->getVar('password'), PASSWORD_BCRYPT),
        ]);

        session()->setFlashdata('success', "Password berhasil diupdate");
        return redirect()->back();
    }
}
