<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ProposalInovasiModel;
use Config\Services;

class SidikJariApiController extends BaseController
{
    public function proses_inovasi()
    {
        set_time_limit(20000);
        $no = 0;
        $gagal = 0;
        for ($i=1; $i <= 524; $i++) { 
            
            $response = $this->get_inovasi($i);
            $data = $response['data'];
            if(count($data) > 0)
            {
                 
                $id = $data['id'];
                $nomor = $data['nomor'];
                $nama_inovasi = $data['nama_inovasi'];
                $tahapan_inovasi = $data['tahapan_inovasi']; //1 inisiatif, 2 Uji Coba, 3 Penerapan
                $jenis_inovasi = $data['jenis_inovasi']; //1 digital, 2 non digital
                $inisiator_inovasi = $data['inisiator_inovasi']; //1 Kepala daerah, 2 Anggota DPRD, 3 OPD, 4 ASN, 5 Masyarakat
                $bentuk_inovasi = $data['bentuk_inovasi']; // 1 Inovasi Daerah lainnya sesuai dengan Urusan Pemerintahan yang menjadi kewenangan Daerah, 2 Inovasi pelayanan publik, 3. Inovasi tata kelola pemerintahan daerah
                $urusan_inovasi = $data['urusan_inovasi'];
                $waktu_uji_coba = $data['waktu_uji_coba']; 
                $waktu_penerapan = $data['waktu_penerapan']; 
                $rancang_bangun = $data['rancang_bangun']; 
                $tujuan_inovasi	= $data['tujuan_inovasi']; 
                $manfaat = $data['manfaat']; 
                $hasil_inovasi = $data['hasil_inovasi']; 
                $anggaran = $data['anggaran']; 
                $profilbisnis = $data['profilbisnis']; 
                $user_id = $data['user_id']; 
                $ide_inovatif = $data['ide_inovatif']; 
                $signifikansi = $data['signifikansi']; 
                $kontribusi_sdgs = $data['kontribusi_sdgs'];
                $kontribusi_jabar = $data['kontribusi_jabar']; 
                $adaptabilitas = $data['adaptabilitas']; 
                $keberlanjutan = $data['keberlanjutan']; 
                $kolaborasi	= $data['kolaborasi']; 
                $tautan_dokumentasi	= $data['tautan_dokumentasi'];
                //textnya
                $tahapan = $data['tahapan']; // "Penerapan"
                $inisiator = $data['inisiator']; // "ASN"
                $jenis = $data['jenis']; // "Digital"
                $bentuk = $data['bentuk']; // "Inovasi tata kelola pemerintahan daerah"
                $urusan = $data['urusan']; // "Perencanaan"

                $users = new ProposalInovasiModel();
                $users->insert([
                    'id' => $id,
                    'sumber' => "Indeks Inovasi",
                    'judul' => $nama_inovasi,
                    'tahapan' => $tahapan,
                    'inisiator' => $inisiator,
                    'jenis' => $jenis,
                    'bentuk_inovasi_daerah_id' => $bentuk_inovasi,
                    'urusan_utama_id' => $urusan_inovasi,
                    'waktu_uji_coba' => $waktu_uji_coba,
                    'waktu_penerapan' => $waktu_penerapan,
                    'rancang_bangun' => $rancang_bangun,
                    'tujuan' => $tujuan_inovasi,
                    'manfaat' => $manfaat,
                    'hasil_inovasi' => $hasil_inovasi,
                    // 'file_anggaran' => $fileName_anggaran,
                    // 'file_profile_bisnis' => $fileName_profile,
                    'user_id' => $user_id,
                    'status' => 'DRAFT',
                    'tahun' => date('Y'),
                    'nilai_proposal' => 0,
                    'ide_inovatif' => $ide_inovatif,
                    'signifikansi' => $signifikansi,
                    'kontribusi_capaian_sdg' => $kontribusi_sdgs,
                    'kontribusi_capaian_kinerja_daerah' => $kontribusi_jabar,
                    'adaptabilitas' => $adaptabilitas,
                    'keberlanjutan' => $keberlanjutan,
                    'kolaborasi' => $kolaborasi,
                    'dokumentasi_foto_inovasi' => $tautan_dokumentasi
                ]);

                $no++;
            }
            else{
                $gagal++;
            }
        }
        
        return 'jumlah data berhasil ke proses = '. $no. ', jumlah gagal = '. $gagal;
    }

    public function get_inovasi($id_inovasi)
    {
        $client  = Services::curlrequest();
        $options = [
            "user_agent" => "Mozilla/5.0 (X11; Linux x86_64; rv:101.0) Gecko/20100101 Firefox/101.0",
            // "headers"    => [
            //     "referer" => "https://www.jne.co.id",
            // ],
        ];

        $response = $client->request("GET", "https://sidikjari.bekasikota.go.id/sidikjari/editusulaninovasi?id={$id_inovasi}", $options);
        $body = json_decode($response->getBody(), true);
        return $body;
    }
}
