<?php

namespace App\Controllers;

use Config\Services;
use App\Models\UserModel;
use App\Models\HakAksesModel;

class User extends BaseController
{
    public function index()
    {
        $model = new HakAksesModel();
        $user_model = new UserModel();

        $param['hak_akses'] = $model->where('is_aktif', 1)->findAll();
        $param['opd'] = $user_model->where('id_hak_akses', 12)->where('is_aktif', 1 )->findAll();

        return view('user/index', $param);
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new UserModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $list->name;
                        $row[] = $list->email;
                        $row[] = $list->nama_hak_akses;
                        $row[] = $list->is_aktif == 1 ? "Ya" : "Tidak";
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $name = $this->request->getVar('name');
        $email = $this->request->getVar('email');
        $id_hak_akses = $this->request->getVar('id_hak_akses');
        $password = $this->request->getVar('password');
        $id_koordinator = $this->request->getVar('id_koordinator');
        $is_aktif = $this->request->getVar('is_aktif');

        $model = new UserModel();

        if($id != 0)
        {
            if($password != null)
            {
                if($id_hak_akses == 13)
                {
                    //Update
                    $model->update($id, [
                        'name' => $name,
                        'email' => $email,
                        'id_hak_akses' => $id_hak_akses,
                        'id_koordinator' => $id_koordinator,
                        'is_aktif' => $is_aktif,
                        'password' => password_hash($password, PASSWORD_BCRYPT)
                    ]);
                }
                else
                {
                    //Update
                    $model->update($id, [
                        'name' => $name,
                        'email' => $email,
                        'id_hak_akses' => $id_hak_akses,
                        'is_aktif' => $is_aktif,
                        'password' => password_hash($password, PASSWORD_BCRYPT)
                    ]);
                }
                
            }
            else
            {
                if($id_hak_akses == 13)
                {
                    //Update
                    $model->update($id, [
                        'name' => $name,
                        'email' => $email,
                        'id_hak_akses' => $id_hak_akses,
                        'is_aktif' => $is_aktif,
                        'id_koordinator' => $id_koordinator,
                    ]);
                }
                else
                {
                    //Update
                    $model->update($id, [
                        'name' => $name,
                        'email' => $email,
                        'id_hak_akses' => $id_hak_akses,
                        'is_aktif' => $is_aktif,
                    ]);
                }
            }
            
        }
        else
        {
            if($id_hak_akses == 13)
            {
                //Create
                $model->insert([
                    'name' => $name,
                    'email' => $email,
                    'id_hak_akses' => $id_hak_akses,
                    'id_koordinator' => $id_koordinator,
                    'is_aktif' => $is_aktif,
                    'password' => password_hash($password, PASSWORD_BCRYPT)
                ]);
            }
            else
            {
                //Create
                $model->insert([
                    'name' => $name,
                    'email' => $email,
                    'id_hak_akses' => $id_hak_akses,
                    'is_aktif' => $is_aktif,
                    'password' => password_hash($password, PASSWORD_BCRYPT)
                ]);
            }
            
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new UserModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new UserModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
