<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\HTTP\RequestInterface;

class KegiatanModel extends Model
{
    protected $table                = 'kegiatans';
    protected $primaryKey           = 'id';
    protected $useTimestamps        = true;
    protected $returnType           = "object";
    protected $allowedFields        = [
        'jenis_tugas',
        'nama',
        'sifat',
        'arahan_kegiatan',
        'id_koordinator',
        'id_anggota',
        'tanggal_mulai',
        'tanggal_selesai',
        'arahan_kepada_ketua',
        'arahan_kepada_anggota',
        'file_nota_pelayanan',
        'file_rekapitulasi',
        'file_kwitansi',
        'id_user',
        'status',
        'bintang'
    ];

    protected $column_order = ['nama'];
    protected $column_search = ['nama'];
    protected $order = ['nama'];
    protected $request;
    protected $db;
    protected $dt;

    function __construct(RequestInterface $request = null, $status = null, $berbintang = false){
        parent::__construct();
        $this->db = db_connect();
        $this->request = $request;

        if($status != null)
        {
            $this->dt = $this->db->table($this->table)->where('status', $status);
        }
        else
        {
            $this->dt = $this->db->table($this->table);
        }

        if($berbintang)
        {
            $this->dt = $this->db->table($this->table)->where('bintang', 1);
        }

        $data_final = $this->dt;

        if(session()->get('id_hak_akses') == 12) // koordinator
        {
            $this->dt = $data_final->where('id_koordinator', session()->get('user_id'));
        }
        else if(session()->get('id_hak_akses') == 13) // anggota
        {
            $this->dt = $data_final->like('id_anggota', session()->get('user_id'));
        }
        else if(session()->get('id_hak_akses') == 11) // kepala bidang
        {
            $this->dt = $data_final->where('id_user', session()->get('user_id'));
        }  
    }

    private function _get_datatables_query(){
        $i = 0;
        foreach ($this->column_search as $item){
            if($this->request->getPost('search')['value']){ 
                if($i===0){
                    $this->dt->groupStart();
                    $this->dt->like($item, $this->request->getPost('search')['value']);
                }
                else{
                    $this->dt->orLike($item, $this->request->getPost('search')['value']);
                }
                if(count($this->column_search) - 1 == $i)
                    $this->dt->groupEnd();
            }
            $i++;
        }
         
        if($this->request->getPost('order')){
            $this->dt->orderBy($this->column_order[$this->request->getPost('order')['0']['column']], $this->request->getPost('order')['0']['dir']);
        } 
        else if(isset($this->order)){
            $order = $this->order;
            $this->dt->orderBy(key($order), $order[key($order)]);
        }
    }

    function get_datatables(){
        $this->_get_datatables_query();
        if($this->request->getPost('length') != -1)
        $this->dt->limit($this->request->getPost('length'), $this->request->getPost('start'));
        $query = $this->dt->get();
        return $query->getResult();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        return $this->dt->countAllResults();
    }

    public function count_all(){
        $tbl_storage = $this->db->table($this->table);
        return $tbl_storage->countAllResults();
    }
}
