<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\HTTP\RequestInterface;
// use ProvinsiModel;
// use KabupatenModel;
// use SatuanOrganisasiModel;

class UserModel extends Model
{
    protected $table = "user";
    protected $useTimestamps = true;
    protected $returnType = "object";
    protected $allowedFields = [
        'name',
        'email',
        'password',
        'id_hak_akses',
        'is_aktif',
        'nip',
        'tanggal_lahir',
        'jenis_kelamin',
        'id_provinsi',
        'id_kabupaten',
        'id_organisasi',
        'id_satuan_organisasi',
        'alamat',
        'no_telp',
        'file_skp',
        'foto',
        'kd_golongan',
        'nama_golongan',
        'kepangkatan',
        'nama_jabatan',
        'kode_organisasi',
        'nama_organisasi',
        'kode_satuan_kerja',
        'nama_satuan_kerja',
        'remember_token',
        'id_user_opd',
        'id_koordinator'
    ];

    protected $column_order = [
        'name',
        'email',
        'password',
        'id_hak_akses',
        'user.is_aktif',
        'nip',
        'tanggal_lahir',
        'jenis_kelamin',
        'id_provinsi',
        'id_kabupaten',
        'id_organisasi',
        'id_satuan_organisasi',
        'alamat',
        'no_telp',
        'file_skp',
        'foto',
        'kd_golongan',
        'nama_golongan',
        'kepangkatan',
        'nama_jabatan',
        'kode_organisasi',
        'nama_organisasi',
        'kode_satuan_kerja',
        'nama_satuan_kerja',
        'id_user_opd'
    ];
    protected $column_search = [
        'name',
        'email',
        'password',
        'id_hak_akses',
        'user.is_aktif',
        'nip',
        'tanggal_lahir',
        'jenis_kelamin',
        'id_provinsi',
        'id_kabupaten',
        'id_organisasi',
        'id_satuan_organisasi',
        'alamat',
        'no_telp',
        'file_skp',
        'foto',
        'kd_golongan',
        'nama_golongan',
        'kepangkatan',
        'nama_jabatan',
        'kode_organisasi',
        'nama_organisasi',
        'kode_satuan_kerja',
        'nama_satuan_kerja',
        'id_user_opd'
    ];
    protected $order = [
        'name',
        'email',
        'password',
        'id_hak_akses',
        'user.is_aktif',
        'nip',
        'tanggal_lahir',
        'jenis_kelamin',
        'id_provinsi',
        'id_kabupaten',
        'id_organisasi',
        'id_satuan_organisasi',
        'alamat',
        'no_telp',
        'file_skp',
        'foto',
        'kd_golongan',
        'nama_golongan',
        'kepangkatan',
        'nama_jabatan',
        'kode_organisasi',
        'nama_organisasi',
        'kode_satuan_kerja',
        'nama_satuan_kerja',
        'id_user_opd'
    ];
    protected $request;
    protected $db;
    protected $dt;

    function __construct(RequestInterface $request = null, $id_hak_akses = 0){
        parent::__construct();
        $this->db = db_connect();
        $this->request = $request;

        if($id_hak_akses == 0)
        {
            $this->dt = $this->db->table($this->table)
                            ->select('user.*, ha.nama_hak_akses as nama_hak_akses')
                            ->join('hak_akses as ha','user.id_hak_akses = ha.id');
                            // ->leftjoin('hak_akses as ha','user.id_hak_akses = ha.id');
        }
        else{
            $this->dt = $this->db->table($this->table)
                            ->select('user.*, ha.nama_hak_akses as nama_hak_akses')
                            ->join('hak_akses as ha','user.id_hak_akses = ha.id')
                            ->where('user.id_hak_akses >=', $id_hak_akses);
        }            
    }

    private function _get_datatables_query(){
        $i = 0;
        foreach ($this->column_search as $item){
            if($this->request->getPost('search')['value']){ 
                if($i===0){
                    $this->dt->groupStart();
                    $this->dt->like($item, $this->request->getPost('search')['value']);
                }
                else{
                    $this->dt->orLike($item, $this->request->getPost('search')['value']);
                }
                if(count($this->column_search) - 1 == $i)
                    $this->dt->groupEnd();
            }
            $i++;
        }
         
        if($this->request->getPost('order')){
                $this->dt->orderBy($this->column_order[$this->request->getPost('order')['0']['column']], $this->request->getPost('order')['0']['dir']);
            } 
        else if(isset($this->order)){
            $order = $this->order;
            $this->dt->orderBy(key($order), $order[key($order)]);
        }
    }

    function get_datatables(){
        $this->_get_datatables_query();
        if($this->request->getPost('length') != -1)
        $this->dt->limit($this->request->getPost('length'), $this->request->getPost('start'));
        $query = $this->dt->get();
        return $query->getResult();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        return $this->dt->countAllResults();
    }

    public function count_all(){
        $tbl_storage = $this->db->table($this->table);
        return $tbl_storage->countAllResults();
    }

    public function inisial($name)
    {
        $name_array = explode(' ',trim($name));
    
        $firstWord = $name_array[0];

        if(count($name_array) > 1)
            $lastWord = $name_array[1][0];
        else
            $lastWord = "";
    
        return $firstWord[0]."".$lastWord;
    }

    public function provinsi($id)
    {
        $prov = new ProvinsiModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->name;
    }

    public function kabupaten($id)
    {
        $prov = new KabupatenModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->name;
    }

    public function organisasi($id)
    {
        $prov = new OrganisasiModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->nama;
    }

    public function satuan_organisasi($id)
    {
        $prov = new SatuanOrganisasiModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->nama;
    }
}