<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\HTTP\RequestInterface;

class UserTimModel extends Model
{
    protected $table = "user_tim";
    protected $useTimestamps = true;
    protected $returnType = "object";
    protected $allowedFields = [
        'name',
        'email',
        'nip',
        'tanggal_lahir',
        'jenis_kelamin',
        'id_provinsi',
        'id_kabupaten',
        'user_id',
        'id_organisasi',
        'id_satuan_organisasi',
        'alamat',
        'no_telp',
        'file_skp',
        'foto',
        'kd_golongan',
        'nama_golongan',
        'kepangkatan',
        'nama_jabatan',
        'kode_organisasi',
        'nama_organisasi',
        'kode_satuan_kerja',
        'nama_satuan_kerja'
    ];

    public function provinsi($id)
    {
        $prov = new ProvinsiModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->name;
    }

    public function kabupaten($id)
    {
        $prov = new KabupatenModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->name;
    }

    public function organisasi($id)
    {
        $prov = new OrganisasiModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->nama;
    }

    public function satuan_organisasi($id)
    {
        $prov = new SatuanOrganisasiModel();
        $data = $prov->where('id', $id)->first();

        return $data == null ? "N/A" : $data->nama;
    }
}