<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Berita</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Berita</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <div class="card-header-action">
        <a href="<?= base_url('admin/berita/tambah') ?>" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">

        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Judul</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>

                <?php foreach($berita as $val): ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= $val->judul ?></td>
                    <td><?= ($val->is_aktif == 1 ? "Aktif" : "Tidak Aktif") ?></td>
                    <td>
                        <a href="<?= base_url('admin/berita/edit/'.$val->id) ?>" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                        <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus(<?=$val->id ?>)"><i class="fas fa-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach ?>
            </tbody>
        </table>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('modal') ?>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var table_data = $("#tblData").DataTable();      

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            window.location.href = "<?= base_url('admin/berita/hapus') ?>/"+id;
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        var formData = new FormData(this);

        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?= base_url('admin/carousel/simpan') ?>",
            data:formData,
            cache:false,
            contentType: false,
            processData: false,
            success: function(result){
                table_data.ajax.reload();
                
                if(result.status)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });  

    function checkfile(sender) {
        var validExts = new Array(".jpg",".jpeg",".png");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file").val('');
                return false;
        }

        return true;
    }
</script>

<?= $this->endSection() ?>