<?= $this->extend('template/front/template') ?>

<?= $this->section('content') ?>
<?= $this->include('template/front/header') ?>
<header class="page-header page-header-dark bg-gradient-primary-to-secondary">
    <div class="page-header-content">
        <div class="container text-center">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <h1 class="page-header-title mb-3 text-white">Petunjuk Teknis</h1>
                    <!-- <p class="page-header-text mb-0">Browse articles, keep up to date, and learn more on our blog!</p> -->
                </div>
            </div>
        </div>
    </div>
    <div class="svg-border-rounded text-light">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 144.54 17.34" preserveAspectRatio="none" fill="currentColor"><path d="M144.54,17.34H0V0H144.54ZM0,0S32.36,17.34,72.27,17.34,144.54,0,144.54,0"></path></svg>
    </div>
</header>
    
<section class="bg-light py-10">
    <div class="container">
        <div class="row">
            <table class="table table-bordered" id="tbl">
                <thead>
                <tr>
                    <th>Nama</th>
                    <th>Download</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($petunjuk_teknis as $val): ?>
                <tr>
                    <td><?= $val->nama ?></td>
                    <td><a href="<?= base_url('uploads/file_petunjuk_teknis/'.$val->file) ?>" title="Download" target="_blank" class="text-primary"><i class="fas fa-download"></i></a></td>
                </tr>
            <?php endforeach ?>
            </tbody>
            </table>
            
        </div>
    </div>
    <div class="svg-border-rounded text-dark">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 144.54 17.34" preserveAspectRatio="none" fill="currentColor"><path d="M144.54,17.34H0V0H144.54ZM0,0S32.36,17.34,72.27,17.34,144.54,0,144.54,0"></path></svg>
    </div>
</section>
<script src="https://code.jquery.com/jquery-3.4.1.min.js" crossorigin="anonymous"></script>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>
        
<script>
var table_data = $("#tbl").DataTable();
</script>
<?= $this->endSection() ?>