<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/summernote/summernote-bs4.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/pretty-checkbox/pretty-checkbox.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/select2/dist/css/select2.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/checkbox/boxed-check.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Integrasi Layanan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Integrasi Layanan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Tambah Integrasi Layanan</h4>
  </div>
  <div class="card-body">
    <?php if (!empty(session()->getFlashdata('error'))) : ?>
        <div class="alert alert-danger">
        <?php echo session()->getFlashdata('error'); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty(session()->getFlashdata('success'))) : ?>
        <div class="alert alert-success">
        <?php echo session()->getFlashdata('success'); ?>
        </div>
    <?php endif; ?>
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/integrasi_layanan/simpan') ?>">
    <?= csrf_field() ?>

    <div class="form-group row">
        <label for="judul" class="col-sm-3 col-form-label">Judul <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input id="judul" type="text" class="form-control" name="judul" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="rancang_bangun" class="col-sm-3 col-form-label">Isi Informasi
        <!--<small class="form-text text-muted">
        (Minimal 300 kata)
        </small> -->
        </label>
        <div class="col-sm-9">
        <textarea name="konten" id="konten" class="form-control summernote"></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Gambar 
            <!-- <small class="form-text text-muted">
                *) Gambar utama berita
            </small> -->
        </label>
        <div class="col-sm-9">
            <input type="file" name="gambar" id="gambar" class="form-control" onchange="checkfile_gambar(this);">
        </div>
    </div>

    <div class="form-group row">
        <label for="judul" class="col-sm-3 col-form-label">Aktif <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <select class="form-control" name="is_aktif" id="is_aktif" required>
                <option value="">-- Silakan Pilih --</option>
                <option value="1">Ya</option>
                <option value="0">Tidak</option>
            </select>
        </div>
    </div>

    <div class="form-group">
        <button type="submit" class="btn btn-primary btn-lg">
            SIMPAN
        </button>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/summernote/summernote-bs4.js') ?>"></script>
<script src="<?= base_url('assets/bundles/select2/dist/js/select2.full.min.js') ?>"></script>
<script>
    $(".summernote").summernote({ height: 300});

    function checkfile_gambar(sender) {
        var validExts = new Array(".jpg",".jpeg",".png");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#gambar").val('');
                return false;
        }

        return true;
    }
</script>
<?= $this->endSection() ?>