<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>

<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Kegiatan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Kegiatan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail Kegiatan</h4>
  </div>
  <div class="card-body">    
    <div class="padding-20">
        
        <form method="POST" enctype="multipart/form-data" action="#">
            <?= csrf_field() ?>

            <div class="form-group row">
                <label for="judul" class="col-sm-3 col-form-label">Jenis Tugas </label>
                <div class="col-sm-9">
                : <?= $kegiatan->jenis_tugas ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="judul" class="col-sm-3 col-form-label">Nama Kegiatan </label>
                <div class="col-sm-9">
                : <?= $kegiatan->nama ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="tema" class="col-sm-3 col-form-label">Sifat </label>
                <div class="col-sm-4">
                : <?= $kegiatan->sifat ?> 
                </div>
            </div>

            <div class="form-group row">
                <label for="tema" class="col-sm-3 col-form-label">Arahan Kegiatan Dari </label>
                <div class="col-sm-4">
                : <?= $kegiatan->arahan_kegiatan ?>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-3 col-form-label">Ditugaskan Kepada </label>
                <div class="col-sm-9">
                    : <?= $koordinator->name ?? "" ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="kategori" class="col-sm-3 col-form-label">Anggota Pendukung</label>
                <div class="col-sm-4">
                : <?= $anggota ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="aspek_kebaharuan" class="col-sm-3 col-form-label">Waktu Mulai Kegiatan </label>
                <div class="col-sm-9">
                : <?= $kegiatan->tanggal_mulai ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="aspek_efektivitas" class="col-sm-3 col-form-label">Waktu Selesai Kegiatan </label>
                <div class="col-sm-9">
                : <?= $kegiatan->tanggal_selesai ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="aspek_bermanfaat" class="col-sm-3 col-form-label">Arahan/Pesan Kepada Ketua Tim/Koordinator </label>
                <div class="col-sm-9">
                : <?= $kegiatan->arahan_kepada_ketua ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="aspek_transferabilitas" class="col-sm-3 col-form-label">Arahan Kepada Anggota </label>
                <div class="col-sm-9">
                : <?= $kegiatan->arahan_kepada_anggota ?>
                </div>
            </div>

            <div class="form-group row">
                <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Nota Pelayanan Kegiatan </label>
                <div class="col-sm-9">
                :
                <?php if($kegiatan->file_nota_pelayanan != null): ?> 
                    <a href="<?= base_url('uploads/file_nota_pelayanan/'.$kegiatan->file_nota_pelayanan) ?>"><i class="fas fa-download"></i> Download</a>
                <?php endif ?>
                
                </div>
            </div>

            <div class="form-group row">
                <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Rekapitulasi </label>
                <div class="col-sm-9">
                :
                <?php if($kegiatan->file_rekapitulasi != null): ?> 
                    <a href="<?= base_url('uploads/file_rekapitulasi/'.$kegiatan->file_rekapitulasi) ?>"><i class="fas fa-download"></i> Download</a>
                <?php endif ?>
                
                </div>
            </div>

            <div class="form-group row">
                <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Kuitani </label>
                <div class="col-sm-9">
                :
                <?php if($kegiatan->file_kwitansi != null): ?> 
                    <a href="<?= base_url('uploads/file_kwitansi/'.$kegiatan->file_kwitansi) ?>"><i class="fas fa-download"></i> Download</a>
                <?php endif ?>
                
                </div>
            </div>
        </form>

        <div class="form-group" style="padding-top: 25px">

        <?php if(session()->get('id_hak_akses') == 6): ?>

            <a href="<?= base_url('admin/kegiatan/TR2') ?>" class="btn btn-primary btn-lg">
                KEMBALI
            </a>

        <?php else: ?>

            <a href="<?= base_url('admin/kegiatan') ?>" class="btn btn-primary btn-lg">
                KEMBALI
            </a>

        <?php endif ?>
        
        </div>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });
</script>
<?= $this->endSection() ?>