<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Kegiatan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Kegiatan</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-body">

    <div class="table-responsive" style="margin-top: 25px">
        <table class="table table-striped table-hover" id="tblData" style="overflow-x: auto;">
        <thead>
            <tr>
                <th>No</th>
                <th>Aksi</th>
                <!-- <th>Lampiran</th>  -->
                <th>IGA</th>
                <th style="width: 25% !important">Nama Kegiatan</th>
                <th>Jenis Tugas</th>
                <th>Sifat</th>
                <th>Tanggal Mulai</th>
                <th>Tanggal Selesai</th>                   
            </tr>
        </thead>
        <tbody>
        </tbody>
        </table>
    </div>
    
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>

    function generate_table()
    {
        var tableData = $("#tblData").DataTable({
            processing: true,
            destroy: true,
            serverSide: true,
            lengthMenu:[[100,200,300,-1],[100, 200, 300,"All"]],
            "autoWidth": false,
            order: [[0, 'asc']],
            "columnDefs": columnDefs,
            "createdRow": function( row, data, dataIndex ) {
                warna_baris(row, data)
            },
            ajax: {
                "url": "<?php echo base_url('admin/kegiatan/get_data_dashboard_eksekutif')?>",
                "type": "POST"
            }
        });   
    }
    
    generate_table()

    function Hapus(id)
    {
        var url = "<?= base_url('admin/kegiatan/hapus') ?>/" + id;
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = url;
            }
        });
    }  

    function Kirim(id, status_kirim)
    {
        var url = "<?= base_url('admin/kegiatan/kirim') ?>";
        swal({
            title: "Anda yakin ?",
            text: "Akan kirim kegiatan ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_kirim
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        generate_table();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function generate_report(sumber)
    {
        window.location.href = "<?= base_url('admin/kegiatan/export') ?>?sumber="+sumber+"&status=all";
    }
</script>

<?= $this->endSection() ?>