<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/summernote/summernote-bs4.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/pretty-checkbox/pretty-checkbox.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/select2/dist/css/select2.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/checkbox/boxed-check.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Kegiatan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Kegiatan</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Tambah Kegiatan</h4>
  </div>
  <div class="card-body">
    <?php if (!empty(session()->getFlashdata('error'))) : ?>
        <div class="alert alert-danger">
        <?php echo session()->getFlashdata('error'); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty(session()->getFlashdata('success'))) : ?>
        <div class="alert alert-success">
        <?php echo session()->getFlashdata('success'); ?>
        </div>
    <?php endif; ?>
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/kegiatan/simpan') ?>">
    <?= csrf_field() ?>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Jenis Tugas <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <div class="row boxed-check-group boxed-check-default">
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="jenis_tugas" value="Utama" required>
                        <div class="boxed-check-label">Utama</div>
                    </label>
                </div>
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="jenis_tugas" value="Pendukung" required>
                        <div class="boxed-check-label">Pendukung</div>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row">
        <label for="judul" class="col-sm-3 col-form-label">Nama Kegiatan <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input id="judul" type="text" class="form-control" name="nama" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Sifat <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <div class="row boxed-check-group boxed-check-default">
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="sifat" value="Segera" required>
                        <div class="boxed-check-label">Segera</div>
                    </label>
                </div>
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="sifat" value="Biasa" required>
                        <div class="boxed-check-label">Biasa</div>
                    </label>
                </div>
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="sifat" value="Rahasia" required>
                        <div class="boxed-check-label">Rahasia</div>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row">
        <label for="arahan_kegiatan" class="col-sm-3 col-form-label">Arahan Kegiatan Dari <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <select name="arahan_kegiatan" id="arahan_kegiatan" class="form-control">
                <option value="Kepala Daerah">Kepala Daerah</option>
                <option value="Anggota DPRD">Anggota DPRD</option>
                <option value="Sekda/Asisten">Sekda/Asisten</option>
                <option value="Kepala Badan/Sekban">Kepala Badan/Sekban</option>
                <option value="Kepala Bidang">Kepala Bidang</option>
                <option value="Lainnya">Lainnya</option>
            </select>
        </div>
    </div>

    <div class="form-group row">
        <label for="id_koordinator" class="col-sm-3 col-form-label">Ditugaskan Kepada <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <select name="id_koordinator" id="id_koordinator" class="form-control" required onchange="get_anggota()">
                <option value="">-- Silakan Pilih --</option>
                <?php 
                    foreach($koordinator as $val)
                    {
                        echo '<option value='.$val->id.'>'.$val->name.'</option>';
                    }
                ?>
            </select>
        </div>
    </div>

    <div class="form-group row">
        <label for="id_anggota" class="col-sm-3 col-form-label">Anggota Pendukung</label>
        <div class="col-sm-9">
            <select name="id_anggota[]" id="id_anggota" multiple="" class="form-control select2 select2-hidden-accessible">
                <option value="">-- Silakan Pilih --</option>
            </select>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Waktu Mulai Kegiatan <span class="text-danger">*</span></label>
        <div class="col-sm-4">
        <input type="date" name="tanggal_mulai" class="form-control" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Waktu Selesai Kegiatan <span class="text-danger">*</span></label>
        <div class="col-sm-4">
        <input type="date" name="tanggal_selesai" class="form-control" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="arahan_kepada_ketua" class="col-sm-3 col-form-label">Arahan/Pesan Kepada Ketua Tim/Koordinator
        <small class="form-text text-muted">
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="arahan_kepada_ketua" class="form-control summernote"></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="arahan_kepada_anggota" class="col-sm-3 col-form-label"> Arahan Kepada Anggota
        <small class="form-text text-muted">
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="arahan_kepada_anggota" class="form-control summernote"></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Nota Pelayanan Kegiatan
            <small class="form-text text-muted">
                <!-- *) Dokumen PDF, maksimal 2MB -->
            </small>
        </label>
        <div class="col-sm-9">
            <input type="file" name="file_nota_pelayanan" id="file_nota_pelayanan" class="form-control" onchange="checkfile_file_anggaran(this);">
        </div>
    </div>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Rekapitulasi
            <small class="form-text text-muted">
                <!-- *) Dokumen PPT, maksimal 2MB -->
            </small>
        </label>
        <div class="col-sm-9">
            <input type="file" name="file_rekapitulasi" id="file_rekapitulasi" class="form-control" onchange="checkfile_file_profile_bisnis(this);">
        </div>
    </div>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Kuitani
            <small class="form-text text-muted">
                <!-- *) Dokumen PPT, maksimal 2MB -->
            </small>
        </label>
        <div class="col-sm-9">
            <input type="file" name="file_kwitansi" id="file_kwitansi" class="form-control" onchange="checkfile_file_profile_bisnis(this);">
        </div>
    </div>

    <div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">
        SIMPAN
    </button>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/summernote/summernote-bs4.js') ?>"></script>
<script src="<?= base_url('assets/bundles/select2/dist/js/select2.full.min.js') ?>"></script>
<script>
    $(".summernote").summernote({ height: 300});
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });
    $("#id_anggota").select2();

    function checkfile_file_anggaran(sender) {
        var validExts = new Array(".pdf",".jpg",".jpeg",".xls",".xlsx",".doc",".docx",".ppt",".pptx",".png");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file_nota_pelayanan").val('');
                return false;
        }

        return true;
    }

    function checkfile_file_profile_bisnis(sender) {
        var validExts = new Array(".ppt",".pptx",".pdf",".jpg",".jpeg",".xls",".xlsx",".doc",".docx",".png");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file_rekapitulasi").val('');
            $("#file_kwitansi").val('');
                return false;
        }

        return true;
    }

    function get_anggota()
    {
        var url = "<?= base_url('admin/get_anggota_by_koordinator') ?>/" + $("#id_koordinator").val();
        $("#id_anggota").empty();
        $.ajax({
            url : url,
            type: 'get',
            dataType: "json",         
            success : function(data)
            {
                
                var append = "";
                $.each(data, function(i,v){
                    append += '<option value="'+v.id+'">'+v.name+'</option>';
                });
                $("#id_anggota").html(append);
            }  
        });
    }
</script>
<?= $this->endSection() ?>