<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Monev</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Monev</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <div class="card-header-action">
        <a href="/admin/monev_inovasi/export" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Download Excel
        </a>
    </div>
  </div>
  <div class="card-body">

    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblTimAdministrasi" style="width:100%;">
        <thead>
            <tr>
                <th>OPD - Nama Inovasi</th>
                <th>Total Nilai Bobot</th>
                <th>Total Nilai Verif</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($data as $items) : ?>
                <tr class="bg-warning">
                    <td colspan="3" class="text-white"><b><?= $items['nama_user']; ?> (Jumlah Inovasi: <?= count($items['inovasi']) ?> , Total Nilai Bobot: <?= array_sum($items['arr_bobot']) ?> , Total Nilai Verif: <?= array_sum($items['arr_verif']) ?>)</b></td>
                </tr>
                <?php foreach($items['inovasi'] as $val) : ?>
                    <tr>
                        <td><?= $val['judul']; ?></td>
                        <td><?= $val['nilai_bobot']; ?></td>
                        <td><?= $val['nilai_verif']; ?></td>
                    </tr>
                <?php endforeach ?>
            <?php endforeach ?>
        </tbody>
        </table>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var tableTA = $("#tblTimAdministrasi").DataTable();     
</script>

<?= $this->endSection() ?>