<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>
<div class="section-header">
    <h1>Akun</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Akun</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="row mt-sm-4">
    <div class="col-12 col-md-12 col-lg-4">
      <div class="card author-box">
        <div class="card-body">
          <div class="author-box-center">
            <figure class="avatar mr-2 avatar-xl bg-warning text-white" data-initial="<?= $inisial ?>">
              <img src="<?= base_url('uploads/foto/'.$user->foto) ?>" alt="...">
            </figure>
            <div class="clearfix"></div>
            <div class="author-box-name" style="margin-top: 25px">
              <a href="javascript:;"><?= $user->name ?></a>
            </div>
            <div class="author-box-job"><?= $user->email ?></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-12 col-lg-8">
      <div class="card">
        <div class="padding-20">
          <ul class="nav nav-tabs" id="myTab2" role="tablist">
            
            <li class="nav-item">
              <a class="nav-link active" id="profile-tab2" data-toggle="tab" href="#settings" role="tab"
                aria-selected="false">Profile</a>
            </li>
          </ul>
          <div class="tab-content tab-bordered" id="myTab3Content">
            <div class="tab-pane fade show active" id="settings" role="tabpanel" aria-labelledby="profile-tab2">
              <form method="post" action="#" class="needs-validation" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="card-header">
                  <h4>Profile Pendaftar</h4>
                </div>
                <div class="card-body">
                <!-- <div class="row">                    
                    <label class="form-group col-4">NIP</label>
                    <div class="form-group col-8">
                        : <?= $user->nip ?>
                    </div>
                </div> -->
                <div class="row">                    
                    <label class="form-group col-4">Nama Lengkap dan Gelar</label>
                    <div class="form-group col-8">
                        : <?= $user->name ?>
                    </div>
                </div>
                <!-- <div class="row">                    
                    <label class="form-group col-4">Jabatan</label>
                    <div class="form-group col-8">
                        : <?= $user->nama_jabatan ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Nama Golongan</label>
                    <div class="form-group col-8">
                        : <?= $user->nama_golongan ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Kepangkatan</label>
                    <div class="form-group col-8">
                        : <?= $user->kepangkatan ?>
                    </div>
                </div> -->
                <div class="row">                    
                    <label class="form-group col-4">Organisasi</label>
                    <div class="form-group col-8">
                        : <?= $user->nama_organisasi ?>
                    </div>
                </div>
                <!-- <div class="row">                    
                    <label class="form-group col-4">Satuan Organisasi</label>
                    <div class="form-group col-8">
                        : <?= $user->nama_satuan_kerja ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Tanggal Lahir</label>
                    <div class="form-group col-8">
                        : <?= $user->tanggal_lahir ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Jenis Kelamin</label>
                    <div class="form-group col-8">
                        : <?= $user->jenis_kelamin ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Provinsi</label>
                    <div class="form-group col-8">
                        : <?= $provinsi ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Kabupaten</label>
                    <div class="form-group col-8">
                        : <?= $kabupaten ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">Alamat Kantor</label>
                    <div class="form-group col-8">
                        : <?= $user->alamat ?>
                    </div>
                </div> -->
                <div class="row">                    
                    <label class="form-group col-4">Email</label>
                    <div class="form-group col-8">
                        : <?= $user->email ?>
                    </div>
                </div>
                <div class="row">                    
                    <label class="form-group col-4">No Telp</label>
                    <div class="form-group col-8">
                        : <?= $user->no_telp ?>
                    </div>
                </div>                  
                <!-- <div class="row">                    
                    <label class="form-group col-4">file SKP</label>
                    <div class="form-group col-8">
                        : <a href="<?= $user->file_skp ?>"> <i class="fas fa-download"></i></a>
                    </div>
                </div>                   -->
                </div>
                <div class="card-footer text-right">
                  <a href="<?= base_url('admin/profile_pendaftar') ?>" class="btn btn-primary">Kembali</a>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Anggota Tim</h4>

    <div class="card-header-action">
        <a href="<?= base_url('admin/profile_pendaftar/tambah_tim/'.$user->id) ?>" class="btn btn-primary text-white">
          <i class="fa fa-plus"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblDataAnggota" style="width:100%;">
          <thead>
            <tr>
                <th>NIP</th>
                <th>Nama</th>
                <th>Organisasi</th>
                <th>Alamat Kantor</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($user_tim as $val): ?>
              <tr>
                  <td><?= $val->nip ?></td>
                  <td><?= $val->name ?></td>
                  <td><?= $val->nama_organisasi ?></td>
                  <td><?= $val->alamat ?></td>
                  <td>
                    <a href="<?= base_url('admin/profile_pendaftar/edit_tim/'. $val->id) ?>" class="btn btn-primary text-white" alt="Edit"><i class="fas fa-pencil-alt"></i></a>
                    <a href="<?= base_url('admin/profile_pendaftar/detail_tim/'. $val->id) ?>" class="btn btn-info text-white" alt="Detail"><i class="far fa-eye"></i></a>
                    <button onclick="hapus(<?= $val->id ?>)" class="btn btn-danger text-white" alt="Hapus"><i class="fas fa-trash"></i></button>
                  </td>
              </tr>
            <?php endforeach ?>
          </tbody>
        </table>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('modal') ?>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js') ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $(".timepicker").timepicker({
        icons: {
            up: 'fas fa-chevron-up',
            down: 'fas fa-chevron-down'
        },
        showMeridian: false
    });

    $("#tblDataAnggota").DataTable();

    function getKabKota()
    {
        var id_provinsi = $("#id_provinsi").val();
        $("#id_kabupaten").empty();

        var option = "";
        $.get("<?= base_url('get-kab-kota') ?>/" + id_provinsi, function(result){

            $.each(result, function(i,l){

                option += '<option value='+ l.id + '>'+l.name+'</option>';

            });

            $("#id_kabupaten").html(option);

        });
    }

    function hapus(id)
    {
       var url = "<?= base_url('admin/profile_pendaftar/delete_tim') ?>/" + id;
       swal({
          title: "Anda yakin ?",
          text: "Akan menghapus data ini!",
          icon: "warning",
          buttons: true,
          dangerMode: true
      })
      .then((willDelete) => {
          if (willDelete) {
              window.location.href = url;
          }
      });
    }

</script>
<?= $this->endSection() ?>