<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Inovasi Daerah</title>
  <style>
      body{
          font-family: Sans-serif
      }
      .page_break { page-break-before: always; }
  </style>
</head>

<body>
  <div class="container mt-5">

    <h2 align="center">LAPORAN INOVASI DAERAH</h2>

    <h2>1. Jenis Pelaporan</h2>

    <h2>1.1. Sumber Inovasi</h2>
    
    <p><?= ($data->sumber == "Indeks Inovasi" ? "Pelaporan Inovasi" : "Proper") ?></p>

    <h4>1.2. Nama Inovasi</h4>
    <p><?= $data->judul ?></p>

    <h4>1.3. Tahapan Inovasi</h4>
    <p><?= $data->tahapan ?></p>

    <h4>1.4. Inisiator Inovasi Daerah</h4>
    <p><?= $data->inisiator ?></p>

    <h4>1.5. Jenis</h4>
    <p><?= $data->jenis ?></p>

    <h4>1.6. Bentuk Inovasi Daerah</h4>
    <p><?= $data->nama_bentuk_inovasi_daerah ?></p>

    <h4>1.7. Urusan Utama</h4>
    <p><?= $data->nama_urusan_utama ?></p>

    <h4>1.8. Urusan lainnya yang beririsan</h4>
    <p><?= $arr_urusan_utama_detail ?></p>

    <h4>1.9. Waktu Uji Coba Inovasi Daerah</h4>
    <p><?= $data->waktu_uji_coba ?></p>    

    <h4>1.10. Waktu Penerapan Inovasi Daerah </h4>
    <p><?= $data->waktu_penerapan ?></p>

    <h4>1.11. Rancang bangun dan pokok perubahan yang dilakukan </h4>
    <p><?= $data->rancang_bangun ?></p>

    <h4>1.12. Tujuan Inovasi</h4>
    <p><?= $data->tujuan ?></p>

    <h4>1.13. Manfaat yang diperoleh</h4>
    <p><?= $data->manfaat ?></p>

    <h4>1.14. Hasil Inovasi</h4>
    <p><?= $data->hasil_inovasi ?></p>

    <h4>1.15. Ide Inovatif</h4>
    <p><?= $data->ide_inovatif ?></p>

    <h4>1.16. Signifikansi</h4>
    <p><?= $data->signifikansi ?></p>

    <h4>1.17. Kontribusi terhadap capaian SDGs </h4>
    <p><?= $data->kontribusi_capaian_sdg ?></p>

    <h4>1.18. Kontribusi terhadap capaian kinerja daerah </h4>
    <p><?= $data->kontribusi_capaian_kinerja_daerah ?></p>

    <h4>1.19. Adaptabilitas </h4>
    <p><?= $data->adaptabilitas ?></p>

    <h4>1.20. Keberlanjutan </h4>
    <p><?= $data->keberlanjutan ?></p>

    <h4>1.21. Kolaborasi </h4>
    <p><?= $data->kolaborasi ?></p>

    <div class="page_break"></div>  
    <h4>2. INDIKATOR INOVASI</h4>
    
    <table width="100%" border="0.5" cellpadding="5">
      <thead>
        <tr>
          <th align="left">No</th>
          <th align="left">Indikator</th>
          <th align="left">Keterangan</th>
          <th align="left">Bukti Dukung</th>
        </tr>
      </thead>
      <tbody>
          <?php foreach($indikator as $key => $val): ?>
          <tr>
              <td><?= ($key + 1) ?></td>
              <td><?= $val->nama ?></td>
              <td><?= $val->keterangan == null ? "-" : $val->keterangan ?></td>
              <td><?= \App\Helpers\InovakesHelper::CheckDataPendukung($data->id, $val->id) ?></td>
          </tr>
          <?php endforeach ?>
      </tbody>
    </table>
  </div>
</body>

</html>