<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/summernote/summernote-bs4.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/pretty-checkbox/pretty-checkbox.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/select2/dist/css/select2.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/checkbox/boxed-check.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Database Inovasi Daerah</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Database Inovasi Daerah</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Edit Database Inovasi Daerah</h4>
  </div>
  <div class="card-body">
    <?php if (!empty(session()->getFlashdata('error'))) : ?>
        <div class="alert alert-danger">
        <?php echo session()->getFlashdata('error'); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty(session()->getFlashdata('success'))) : ?>
        <div class="alert alert-success">
        <?php echo session()->getFlashdata('success'); ?>
        </div>
    <?php endif; ?>
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/proposal_inovasi/update') ?>">
    <?= csrf_field() ?>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Jenis pelaporan <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <div class="row boxed-check-group boxed-check-default">
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="sumber" <?= $proposal->sumber == "Indeks Inovasi" ? "checked" : "" ?> value="Indeks Inovasi" required>
                        <div class="boxed-check-label">Pelaporan Inovasi</div>
                    </label>
                </div>
                <!-- <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="sumber" <?= $proposal->sumber == "Lomba Inovasi" ? "checked" : "" ?> value="Lomba Inovasi" required>
                        <div class="boxed-check-label">Lomba Inovasi</div>
                    </label>
                </div> -->
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="sumber" <?= $proposal->sumber == "Proper" ? "checked" : "" ?> value="Proper" required>
                        <div class="boxed-check-label">Proper</div>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row">
        <label for="judul" class="col-sm-3 col-form-label">Nama Inovasi<span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="hidden" class="form-control" name="id" value="<?= $proposal->id ?>">
        <input id="nama_file_anggaran" type="hidden" class="form-control" name="nama_file_anggaran" value="<?= $proposal->file_anggaran ?>">
        <input id="nama_file_profile_bisnis" type="hidden" class="form-control" name="nama_file_profile_bisnis" value="<?= $proposal->file_profile_bisnis ?>">
        <input id="judul" type="text" class="form-control" name="judul" value="<?= $proposal->judul ?>" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Tahapan Inovasi<span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <div class="row boxed-check-group boxed-check-default">
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="tahapan" <?= $proposal->tahapan == "Inisiatif" ? "checked" : "" ?> value="Inisiatif" required>
                        <div class="boxed-check-label">Inisiatif</div>
                    </label>
                </div>
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="tahapan" <?= $proposal->tahapan == "Uji Coba" ? "checked" : "" ?> value="Uji Coba" required>
                        <div class="boxed-check-label">Uji Coba</div>
                    </label>
                </div>
                <div class="col-12 col-sm-4">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="tahapan" <?= $proposal->tahapan == "Penerapan" ? "checked" : "" ?> value="Penerapan" required>
                        <div class="boxed-check-label">Penerapan</div>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Inisiator Inovasi Daerah <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <div class="row boxed-check-group boxed-check-default">
                <div class="col-12 col-sm-3">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="inisiator" <?= $proposal->inisiator == "Kepala Daerah" ? "checked" : "" ?> value="Kepala Daerah" required>
                        <div class="boxed-check-label">Kepala Daerah</div>
                    </label>
                </div>
                <div class="col-12 col-sm-3">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="inisiator" <?= $proposal->inisiator == "Anggota DPRD" ? "checked" : "" ?> value="Anggota DPRD" required>
                        <div class="boxed-check-label">Anggota DPRD</div>
                    </label>
                </div>
                <div class="col-12 col-sm-2">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="inisiator" <?= $proposal->inisiator == "OPD" ? "checked" : "" ?> value="OPD" required>
                        <div class="boxed-check-label">OPD</div>
                    </label>
                </div>
                <div class="col-12 col-sm-2">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="inisiator" <?= $proposal->inisiator == "ASN" ? "checked" : "" ?> value="ASN" required>
                        <div class="boxed-check-label">ASN</div>
                    </label>
                </div>
                <div class="col-12 col-sm-2">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="inisiator" <?= $proposal->inisiator == "Masyarakat" ? "checked" : "" ?> value="Masyarakat" required>
                        <div class="boxed-check-label">Masyarakat</div>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row">
        <label class="col-sm-3 col-form-label">Jenis <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <div class="row boxed-check-group boxed-check-default">
                <div class="col-12 col-sm-6">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="jenis" <?= $proposal->jenis == "Digital" ? "checked" : "" ?> value="Digital" required>
                        <div class="boxed-check-label">Digital</div>
                    </label>
                </div>
                <div class="col-12 col-sm-6">
                    <label class="boxed-check">
                        <input class="boxed-check-input" type="radio" name="jenis" <?= $proposal->jenis == "Non Digital" ? "checked" : "" ?> value="Non Digital" required>
                        <div class="boxed-check-label">Non Digital</div>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row">
        <label for="bentuk_inovasi_daerah_id" class="col-sm-3 col-form-label">Bentuk Inovasi Daerah <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <select name="bentuk_inovasi_daerah_id" id="bentuk_inovasi_daerah_id" class="form-control" required>
                <option value="">-- Silakan Pilih --</option>
                <?php 
                    foreach($bentuk_inovasi_daerah as $val)
                    {
                        echo '<option value='.$val->id.' '.($val->id == $proposal->bentuk_inovasi_daerah_id ? 'selected' : '').'>'.$val->nama.'</option>';
                    }
                ?>
            </select>
        </div>
    </div>

    <b>Urusan Pemerintah</b>
    <div class="form-group row">
        <label for="urusan_utama_id" class="col-sm-3 col-form-label">Urusan Utama <span class="text-danger">*</span></label>
        <div class="col-sm-9">
            <select name="urusan_utama_id" id="urusan_utama_id" class="form-control" onchange="get_usuran_utama_detail()" required>
                <option value="">-- Silakan Pilih --</option>
                <?php 
                    foreach($urusan_utama as $val)
                    {
                        echo '<option value='.$val->id.' '.($val->id == $proposal->urusan_utama_id ? 'selected' : '').'>'.$val->nama.'</option>';
                    }
                ?>
            </select>
        </div>
    </div>

    <div class="form-group row">
        <label for="urusan_utama_detail_id" class="col-sm-3 col-form-label">Urusan lain yang beririsan</label>
        <div class="col-sm-9">
            <select name="urusan_utama_detail_id[]" id="urusan_utama_detail_id" multiple="" class="form-control select2 select2-hidden-accessible">
                <?php
                    foreach($urusan_utama as $val)
                    {
                        echo '<option value='.$val->id.' '.(in_array($val->id, $arr_urusan_utama_detail) ? 'selected' : '').'>'.$val->nama.'</option>';
                    }
                ?>
            </select>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Waktu Uji Coba Inovasi Daerah <span class="text-danger">*</span></label>
        <div class="col-sm-4">
        <input type="date" name="waktu_uji_coba" class="form-control" value="<?= $proposal->waktu_uji_coba; ?>" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Waktu Penerapan Inovasi Daerah <span class="text-danger">*</span></label>
        <div class="col-sm-4">
        <input type="date" name="waktu_penerapan" class="form-control" value="<?= $proposal->waktu_penerapan; ?>" required>
        </div>
    </div>

    <div class="form-group row">
        <label for="rancang_bangun" class="col-sm-3 col-form-label">Rancang bangun dan pokok perubahan yang dilakukan
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="rancang_bangun" class="form-control summernote"><?= $proposal->rancang_bangun ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="tujuan" class="col-sm-3 col-form-label">Tujuan Inovasi
        <small class="form-text text-muted">
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="tujuan" class="form-control summernote"><?= $proposal->tujuan ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="manfaat" class="col-sm-3 col-form-label">Manfaat yang diperoleh
        <small class="form-text text-muted">
        
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="manfaat" class="form-control summernote"><?= $proposal->manfaat ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="hasil_inovasi" class="col-sm-3 col-form-label">Hasil Inovasi
        <small class="form-text text-muted">
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="hasil_inovasi" class="form-control summernote"><?= $proposal->hasil_inovasi ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="ide_inovatif" class="col-sm-3 col-form-label">Ide Inovatif 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="ide_inovatif" class="form-control summernote"><?= $proposal->ide_inovatif ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="signifikansi" class="col-sm-3 col-form-label">Signifikansi 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="signifikansi" class="form-control summernote"><?= $proposal->signifikansi ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="kontribusi_capaian_sdg" class="col-sm-3 col-form-label">Kontribusi terhadap capaian SDGs 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="kontribusi_capaian_sdg" class="form-control summernote"><?= $proposal->kontribusi_capaian_sdg ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="kontribusi_capaian_kinerja_daerah" class="col-sm-3 col-form-label">Kontribusi terhadap capaian kinerja daerah 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="kontribusi_capaian_kinerja_daerah" class="form-control summernote"><?= $proposal->kontribusi_capaian_kinerja_daerah ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="adaptabilitas" class="col-sm-3 col-form-label">Adaptabilitas 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="adaptabilitas" class="form-control summernote"><?= $proposal->adaptabilitas ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="keberlanjutan" class="col-sm-3 col-form-label">Keberlanjutan 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="keberlanjutan" class="form-control summernote"><?= $proposal->keberlanjutan ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="kolaborasi" class="col-sm-3 col-form-label">Kolaborasi 
        <small class="form-text text-muted">
        (Minimal 300 kata)
        </small>
        </label>
        <div class="col-sm-9">
        <textarea name="kolaborasi" class="form-control summernote"><?= $proposal->kolaborasi ?></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label for="dokumentasi_foto_inovasi" class="col-sm-3 col-form-label">Dokumentasi foto inovasi</label>
        <div class="col-sm-9">
        <input id="dokumentasi_foto_inovasi" type="text" class="form-control" name="dokumentasi_foto_inovasi" value="<?= $proposal->dokumentasi_foto_inovasi ?>" placeholder="Link Dokumentasi foto maupun video inovasi yang diusulkan.">
        </div>
    </div>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Anggaran (Jika diperlukan)
            <small class="form-text text-muted">
                *) Dokumen PDF, maksimal 2MB
            </small>
        </label>
        <div class="col-sm-9">
            <input type="file" name="file_anggaran" id="file_anggaran" class="form-control" onchange="checkfile_file_anggaran(this);">
            <?php if($proposal->file_anggaran != null): ?> 
                <a href="<?= base_url('uploads/proses_inovasi/'.$proposal->file_anggaran) ?>"><i class="fas fa-download"></i> Download</a>
            <?php endif ?>
        </div>
    </div>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Profile bisnis (Jika diperlukan)
            <small class="form-text text-muted">
                *) Dokumen PPT, maksimal 2MB
            </small>
        </label>
        <div class="col-sm-9">
        <input type="file" name="file_profile_bisnis" id="file_profile_bisnis" class="form-control" onchange="checkfile_file_profile_bisnis(this);">
            <?php if($proposal->file_profile_bisnis != null): ?> 
                <a href="<?= base_url('uploads/proses_inovasi/'.$proposal->file_profile_bisnis) ?>"><i class="fas fa-download"></i> Download</a>
            <?php endif ?>
        </div>
    </div>

    <div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">
        SIMPAN
    </button>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/summernote/summernote-bs4.js') ?>"></script>
<script src="<?= base_url('assets/bundles/select2/dist/js/select2.full.min.js') ?>"></script>
<script>
    $(".summernote").summernote({ height: 300 });
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });
    $("#urusan_utama_detail_id").select2();

    function checkfile_file_anggaran(sender) {
        var validExts = new Array(".pdf");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung, silakan upload dengan format PDF");
            $("#file_anggaran").val('');
                return false;
        }

        return true;
    }

    function checkfile_file_profile_bisnis(sender) {
        var validExts = new Array(".ppt",".pptx");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung, silakan upload dengan format .ppt atau .pptx");
            $("#file_profile_bisnis").val('');
                return false;
        }

        return true;
    }

    var arr_tema_ide = [
        'Pelayanan Publik Bidang Manajemenen dan tata Kelola pemerintahan (Administratif)',
        'Pelayanan Publik Bidang Kesehatan Masyarakat (upaya Preventif dan Promotive)',
        'Pelayanan Publik Bidang pelayanan Kesehatan'
    ];

    var arr_tema_karya = [
        'Pelayanan Publik Bidang Manajemenen dan tata Kelola pemerintahan (Administratif)',
        'Pelayanan Publik Bidang Kesehatan Masyarakat (upaya Preventif dan Promotive)',
        'Pelayanan Publik Bidang pelayanan Kesehatan',
        'Produk Kesehatan',
        'Inovasi Budaya Kerja'
    ];

    function pilih_tema()
    {
        var tahapan = $("#tahapan").val();
        $("#tema").empty();

        if(tahapan == "Inisiatif (ide)")
        {
            var option = "";
            for(i = 0; i < arr_tema_ide.length; i++)
            {
                option += '<option value="'+arr_tema_ide[i]+'">'+arr_tema_ide[i]+'</option>'
            }

            $("#tema").append(option);
        }
        else if(tahapan == "Karya Penerapan"){
            var option = "";
            for(i = 0; i < arr_tema_karya.length; i++)
            {
                option += '<option value="'+arr_tema_karya[i]+'">'+arr_tema_karya[i]+'</option>'
            }

            $("#tema").append(option);
        }
    }
</script>
<?= $this->endSection() ?>