<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/summernote/summernote-bs4.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Database Inovasi Daerah</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Database Inovasi Daerah</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Edit Data Pendukung</h4>
  </div>
  <div class="card-body">
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/proposal_inovasi/data_pendukung/update') ?>">
    <?= csrf_field() ?>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Jenis File </span></label>
        <div class="col-sm-9">
        : <?= $indikator->jenis_file ?>
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Keterangan</label>
        <div class="col-sm-9">
            : <?= $indikator->keterangan_data_pendukung ?? '-' ?>
        <!-- <textarea name="keterangan" class="form-control"></textarea> -->
        </div>
    </div>

    <div class="form-group row">
        <label for="judul" class="col-sm-3 col-form-label">Nama <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input id="id_proposal" type="hidden" class="form-control" value="<?= $data->id_proposal ?>" name="id_proposal" required>
        <input id="id_indikator" type="hidden" class="form-control" value="<?= $data->id_indikator ?>" name="id_indikator" required>
        <input id="id" type="hidden" class="form-control" value="<?= $data->id ?>" name="id" required>
        <input id="nama_file" type="hidden" class="form-control" value="<?= $data->file ?>" name="nama_file" required>
        <input id="nama" type="text" class="form-control" name="nama" value="<?= $data->nama ?>" required>
        <input type="hidden" name="jenis_file" value="<?= $indikator->jenis_file ?>">
        </div>
    </div>

    <?php if($indikator->jenis_file == 'PDF'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" onchange="checkfile(this);">
        <a href="<?= base_url('uploads/data_pendukung/'. $data->file) ?>"><i class="fas fa-download"></i></a>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'Gambar'): ?>
    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" onchange="checkfileGambar(this);">
        <a href="<?= base_url('uploads/data_pendukung/'. $data->file) ?>"><i class="fas fa-download"></i></a>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'Video'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">URL Video <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <textarea name="url_youtube" class="form-control" required id="url_youtube"><?= $data->url_youtube ?></textarea>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'PPT'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" onchange="checkfilePPT(this);">
        <a href="<?= base_url('uploads/data_pendukung/'. $data->file) ?>"><i class="fas fa-download"></i></a>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'All'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control">
        <a href="<?= base_url('uploads/data_pendukung/'. $data->file) ?>"><i class="fas fa-download"></i></a>
        </div>
    </div>

    <?php endif ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Komentar</label>
        <div class="col-sm-9">
        <textarea class="form-control" name="komentar" id="komentar"><?= $data->komentar ?></textarea>
        </div>
    </div>

    <div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">
        SIMPAN
    </button>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/summernote/summernote-bs4.js') ?>"></script>
<script>
    $(".summernote").summernote();
    function checkfile(sender) {
        var validExts = new Array(".jpg",".jpeg",".png",".doc",".docx",".pdf",".PDF",".ppt",".pptx",".mp4",".mov");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file").val('');
                return false;
        }

        return true;
    }
    pilih_tipe();
    function pilih_tipe()
    {
        var tipe = $("#tipe").val();

        if(tipe == "upload")
        {
            $("#divUpload").show();
            $("#divURL").hide();

            $("#file").attr("required", true);
            $("#url_youtube").attr("required", false);
        }
        else if(tipe == "url")
        {
            $("#divUpload").hide();
            $("#divURL").show();

            $("#file").attr("required", false);
            $("#url_youtube").attr("required", true);
        }
        else
        {
            $("#divURL").hide();
            $("#divUpload").hide();

            $("#file").attr("required", false);
            $("#url_youtube").attr("required", false);
        }
    }
</script>
<?= $this->endSection() ?>