<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Database Inovasi Daerah</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Database Inovasi Daerah</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <div class="card-header-action">
        <?php if(session()->get('id_hak_akses') == 2): ?>
        <a href="<?= base_url('admin/proposal_inovasi/tambah') ?>" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah Proposal
        </a>
        <?php endif ?>
    </div>
  </div>
  <div class="card-body">
  
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>No</th>
                <th>Nama Pengusul</th>
                <th>Satuan Kerja</th>
                <th>Judul</th>
                <th>Tema</th>
                <th>Tahapan</th>
                <th>Kategori</th>
                <th>Waktu Pembuatan</th>
                <th>Skor Mandiri</th>
                <th>Skor PP</th>
                <?php if(session()->get('id_hak_akses') == 5 || session()->get('id_hak_akses') == 1): ?>
                    <th>Nilai Juri</th>
                <?php endif ?>
                <th>Indikator</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var tableData = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        lengthMenu:[100,200,300],
        ajax: {
            "url": "<?php echo base_url('admin/proposal_inovasi/get_data_tim/5')?>",
            "type": "POST"
        }
    });      

    function Hapus(id)
    {
        var url = "<?= base_url('admin/proposal_inovasi/hapus') ?>/" + id;
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = url;
            }
        });
    }  

    function Kirim(id)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim') ?>";
        swal({
            title: "Anda yakin ?",
            text: "Akan kirim proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function AksiTA(id, status_ta)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim_ta') ?>";

        if(status_ta == 1)
        {
            pesan = "Terima";
        }
        else
        {
            pesan = "Tolak";
        }
        swal({
            title: "Anda yakin ?",
            text: "Akan "+pesan+" proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_ta
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function AksiTR(id, status_ta)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim_tr') ?>";

        if(status_ta == 1)
        {
            pesan = "Terima";
        }
        else
        {
            pesan = "Tolak";
        }
        swal({
            title: "Anda yakin ?",
            text: "Akan "+pesan+" proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_ta
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function AksiTJ(id, status_ta)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim_tj') ?>";

        if(status_ta == 1)
        {
            pesan = "Terima";
        }
        else
        {
            pesan = "Tolak";
        }
        swal({
            title: "Anda yakin ?",
            text: "Akan "+pesan+" proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_ta
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }
</script>

<?= $this->endSection() ?>