<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/summernote/summernote-bs4.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Database Inovasi Daerah</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Database Inovasi Daerah</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Tambah Data Pendukung</h4>
  </div>
  <div class="card-body">
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/proposal_inovasi/data_pendukung/simpan') ?>">
    <?= csrf_field() ?>
    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Jenis File </span></label>
        <div class="col-sm-9">
        : <?= $indikator->jenis_file ?>
        <input type="hidden" name="jenis_file" value="<?= $indikator->jenis_file ?>">
        </div>
    </div>

    <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Keterangan</label>
        <div class="col-sm-9">
            : <?= $indikator->keterangan_data_pendukung ?? '-' ?>
        <!-- <textarea name="keterangan" class="form-control"></textarea> -->
        </div>
    </div>

    <div class="form-group row">
        <label for="judul" class="col-sm-3 col-form-label">Nama <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input id="id_proposal" type="hidden" class="form-control" value="<?= $id_proposal ?>" name="id_proposal" required>
        <input id="id_indikator" type="hidden" class="form-control" value="<?= $id_indikator ?>" name="id_indikator" required>
        <input id="nama" type="text" class="form-control" name="nama" required>
        </div>
    </div>

    <!-- <div class="form-group row">
        <label for="tema" class="col-sm-3 col-form-label">Tipe <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <select name="tipe" id="tipe" onchange="pilih_tipe()" class="form-control" required>
            <option value="upload">File Upload</option>
            <option value="url">Link</option>
        </select>
        </div>
    </div> -->

    <?php if($indikator->jenis_file == 'PDF'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" onchange="checkfile(this);" required>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'Gambar'): ?>
    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" onchange="checkfileGambar(this);" required>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'Video'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">URL Video <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <textarea name="url_youtube" class="form-control" required id="url_youtube"></textarea>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'PPT'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" onchange="checkfilePPT(this);" required>
        </div>
    </div>

    <?php elseif($indikator->jenis_file == 'All'): ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">File <span class="text-danger">*</span></label>
        <div class="col-sm-9">
        <input type="file" name="file" id="file" class="form-control" required>
        </div>
    </div>

    <?php endif ?>

    <div class="form-group row">
        <label for="keterlibatan_pemangku_kepentingan" class="col-sm-3 col-form-label">Komentar</label>
        <div class="col-sm-9">
        <textarea class="form-control" name="komentar" id="komentar"></textarea>
        </div>
    </div>

    <div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">
        SIMPAN
    </button>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/summernote/summernote-bs4.js') ?>"></script>
<script>
    $(".summernote").summernote();

    function checkfile(sender) {
        var validExts = new Array(".pdf",".PDF");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file").val('');
                return false;
        }

        return true;
    }

    function checkfileGambar(sender) {
        var validExts = new Array(".jpg",".jpeg",".png",".gif",".bmp");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file").val('');
                return false;
        }

        return true;
    }

    function checkfilePPT(sender) {
        var validExts = new Array(".ppt",".pptx");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file").val('');
                return false;
        }

        return true;
    }
    // pilih_tipe();
    // function pilih_tipe()
    // {
    //     var tipe = $("#tipe").val();

    //     if(tipe == "upload")
    //     {
    //         $("#divUpload").show();
    //         $("#divURL").hide();

    //         $("#file").attr("required", true);
    //         $("#url_youtube").attr("required", false);
    //     }
    //     else if(tipe == "url")
    //     {
    //         $("#divUpload").hide();
    //         $("#divURL").show();

    //         $("#file").attr("required", false);
    //         $("#url_youtube").attr("required", true);
    //     }
    //     else
    //     {
    //         $("#divURL").hide();
    //         $("#divUpload").hide();

    //         $("#file").attr("required", false);
    //         $("#url_youtube").attr("required", false);
    //     }
    // }
</script>
<?= $this->endSection() ?>