<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Provinsi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Provinsi</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <div class="card-header-action">
        <button class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </button>
    </div>
  </div>
  <div class="card-body">

        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('modal') ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Provinsi</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Name</label> 
                                <input type="text" class="form-control" name="name" id="name" required> 
                                <input type="hidden" name="id" id="id">
                            </div> 
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        "columnDefs": [ {
            "targets": 1,
            "orderable": false
        }],
        ajax: {
            "url": "<?php echo base_url('admin/provinsi/get_data')?>",
            "type": "POST"
        }
    });      

    function edit_data(id)
    {  
        var url = "<?= base_url('admin/provinsi/edit') ?>/"+id;
        
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#name").val(data.name);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val(0);
        $("#name").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?= base_url('admin/provinsi/hapus') ?>/"+id,
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?= base_url('admin/provinsi/simpan') ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();
                
                if(result.status)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });  
</script>

<?= $this->endSection() ?>