<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Ranking Inovasi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Ranking Inovasi</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header text-right" style="display: block">
    <!-- <h4>Data Profile Pendaftar</h4> -->
    <?php 
        $param = current_url(true)->getQuery() == null ? "tab=Indeks+Inovasi" : current_url(true)->getQuery(); 
        $param = str_replace("tab","", $param);
        $param = str_replace("+"," ", $param);
        $param = str_replace("="," ", $param);
        $param = trim($param);
    ?>

    <div class="card-header-action">
        <div class="row">
            <label class="col-md-9 control-label"><b>Tahun : </b></label>
            <div class="col-md-3">
                
                <select id="tahun" name="tahun" class="form-control" onchange="generate_table()">
                    <option value="All">All</option>
                    <option value="2022">2022</option>
                    <?php foreach($tahun as $val): ?>
                        <option value="<?= $val->tahun ?>" <?= ($val->tahun == date('Y') ? 'selected' : '') ?>><?= $val->tahun ?></option>
                    <?php endforeach ?>
                </select>
            </div>
        </div>
    </div>
  </div>
  <div class="card-body">
    
    <ul class="nav nav-tabs" id="myTab2" role="tablist">
        <li class="nav-item">
            <a class="nav-link <?= ($param == "Indeks Inovasi" ? "active" : "") ?>" id="home-tab2" data-toggle="tab" href="#home2" role="tab" aria-selected="true">Pelaporan Inovasi</a>
        </li>
        <!-- <li class="nav-item">
            <a class="nav-link <?= ($param == "Lomba Inovasi" ? "active" : "") ?>" id="profile-tab2" data-toggle="tab" href="#profile2" role="tab" aria-selected="false">Lomba Inovasi</a>
        </li> -->
        <!-- <li class="nav-item">
            <a class="nav-link <?= ($param == "Proper" ? "active" : "") ?>" id="contact-tab2" data-toggle="tab" href="#contact2" role="tab" aria-selected="false">Proper</a>
        </li> -->
        <li class="nav-item">
            <a class="nav-link" id="home-tab3" data-toggle="tab" href="#opd" role="tab" aria-selected="true">OPD</a>
        </li>
    </ul>

    <div class="tab-content tab-bordered" id="myTab3Content">
        <div class="tab-pane fade <?= ($param == "Indeks Inovasi" ? "active show" : "") ?>" id="home2" role="tabpanel" aria-labelledby="home-tab2">
                    
            <div class="pull-right" style="margin-bottom:25px;"><a href="javascript:;" onclick="generate_report('Indeks Inovasi')" class="btn btn-info text-white">Export Excel</a></div>
            <div class="table-responsive" style="margin-top: 25px">
                <table class="table table-striped table-hover" id="tblData" style="width:1500px;max-width:100%; overflow-x: auto;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Aksi</th>
                        <th>Instansi</th>
                        <th>Nama Inovator</th>
                        <th style="width: 25% !important">Nama Inovasi</th>
                        <th>Skor Proposal</th>
                        <!-- <th>Skor Mandiri</th> -->
                        <th>Skor Verifikasi</th>
                        <!-- <th>Skor Presentasi</th>
                        <th>Skor Validasi Lapangan</th>                 -->
                        <th>Total Skor</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
        <!-- <div class="tab-pane fade <?= ($param == "Lomba Inovasi" ? "active show" : "") ?>" id="profile2" role="tabpanel" aria-labelledby="profile-tab2">
            <div class="pull-right" style="margin-bottom:25px;"><a href="javascript:;" onclick="generate_report('Lomba Inovasi')" class="btn btn-info text-white">Export Excel</a></div>
            <div class="table-responsive" style="margin-top: 25px">
                <table class="table table-striped table-hover" id="tblDataLombaInovasi" style="width:1500px; overflow-x: auto;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Aksi</th>
                        <th>Instansi</th>
                        <th>Nama Inovator</th>
                        <th style="width: 25% !important">Nama Inovasi</th>
                        <th>Skor Proposal</th>
                        <th>Skor Mandiri</th>
                        <th>Skor Verifikasi</th>
                        <th>Skor Presentasi</th>
                        <th>Skor Validasi Lapangan</th>                
                        <th>Total Skor</th>
                        
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade <?= ($param == "Proper" ? "active show" : "") ?>" id="contact2" role="tabpanel" aria-labelledby="contact-tab2">
            <div class="pull-right" style="margin-bottom:25px;"><a href="javascript:;" onclick="generate_report('Proper')" class="btn btn-info text-white">Export Excel</a></div>
            <div class="table-responsive" style="margin-top: 25px">
                <table class="table table-striped table-hover" id="tblDataProper" style="width:1500px; overflow-x: auto;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Aksi</th>
                        <th>Instansi</th>
                        <th>Nama Inovator</th>
                        <th style="width: 25% !important">Nama Inovasi</th>
                        <th>Skor Proposal</th>
                        <th>Skor Mandiri</th>
                        <th>Skor Verifikasi</th>
                        <th>Skor Presentasi</th>
                        <th>Skor Validasi Lapangan</th>                
                        <th>Total Skor</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div> -->
        <div class="tab-pane fade" id="opd" role="tabpanel" aria-labelledby="opd">
                    
            <div class="table-responsive" style="margin-top: 25px">
                <table class="table table-striped table-hover" id="tblLomba" style="width:1500px; overflow-x: auto;">
                <thead>
                    <tr>
                        <th>Nama OPD</th>               
                        <th>Total Skor</th>
                        <th>Nilai Index</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($ranking as $val): ?>
                    <?php 
                        $totalPenambah0koma38 = 0.38 * $val->total_data;
                        $totalSkor = ($val->nilai_proposal + $val->skor_verifikasi); 
                        $rataRataTotalSkor = ($totalSkor / $val->total_data);
                        $rataRataSkor = ($rataRataTotalSkor / 2) + $totalPenambah0koma38;
                        $index = ($rataRataSkor / 113.1) * 100; //113.1 nilai maksimal untuk 20 inovasi

                    ?>
                        <tr>
                            <td><?= $val->OPD ?></td>
                            <td><?= $totalSkor ?></td>
                            <td><?= number_format($index, 2) ?></td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
                </table>
            </div>
        </div>
    </div> 
    
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        $.fn.dataTable.tables({ visible: true, api: true, width:"1500px" }).columns.adjust();
    });
    $("#tblLomba").DataTable();
    function generate_table()
    {
        var tableData = $("#tblData").DataTable({
            processing: true,
            destroy: true,
            serverSide: false,
            lengthMenu:[100,200,300],
            "autoWidth": false,
            ajax: {
                "url": "<?php echo base_url('admin/report/get_data')?>?sumber=Indeks Inovasi&status=SELESAI&tahun="+$("#tahun").val(),
                "type": "POST"
            }
        });   
        
        // var tableDataLombaInovasi = $("#tblDataLombaInovasi").DataTable({
        //     processing: true,
        //     destroy: true,
        //     serverSide: false,
        //     lengthMenu:[100,200,300],
        //     "autoWidth": false,
        //     ajax: {
        //         "url": "<?php echo base_url('admin/report/get_data')?>?sumber=Lomba Inovasi&status=SELESAI&tahun="+$("#tahun").val(),
        //         "type": "POST"
        //     }
        // });

        // var tableDataProper = $("#tblDataProper").DataTable({
        //     processing: true,
        //     destroy: true,
        //     serverSide: false,
        //     lengthMenu:[100,200,300],
        //     "autoWidth": false,
        //     ajax: {
        //         "url": "<?php echo base_url('admin/report/get_data')?>?sumber=Proper&status=SELESAI&tahun="+$("#tahun").val(),
        //         "type": "POST"
        //     }
        // });
    }
    
    generate_table();

    function Hapus(id)
    {
        var url = "<?= base_url('admin/proposal_inovasi/hapus') ?>/" + id;
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = url;
            }
        });
    }  

    function Kirim(id, status_kirim)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim') ?>";
        swal({
            title: "Anda yakin ?",
            text: "Akan kirim proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_kirim
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        tableDataLombaInovasi.ajax.reload();
                        tableDataProper.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function AksiTA(id, status_ta)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim_ta') ?>";

        if(status_ta == 1)
        {
            pesan = "Terima";
        }
        else
        {
            pesan = "Tolak";
        }
        swal({
            title: "Anda yakin ?",
            text: "Akan "+pesan+" proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_ta
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        tableDataLombaInovasi.ajax.reload();
                        tableDataProper.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function AksiTR(id, status_ta)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim_tr') ?>";

        if(status_ta == 1)
        {
            pesan = "Terima";
        }
        else
        {
            pesan = "Tolak";
        }
        swal({
            title: "Anda yakin ?",
            text: "Akan "+pesan+" proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_ta
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        tableDataLombaInovasi.ajax.reload();
                        tableDataProper.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function AksiTJ(id, status_ta)
    {
        var url = "<?= base_url('admin/proposal_inovasi/kirim_tj') ?>";

        if(status_ta == 1)
        {
            pesan = "Terima";
        }
        else
        {
            pesan = "Tolak";
        }
        swal({
            title: "Anda yakin ?",
            text: "Akan "+pesan+" proposal ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {

                var dataJson = { 
                    [csrfName]: csrfHash,
                    id: id,
                    status: status_ta
                };
                $.ajax({
                    url : url,
                    type: 'post',
                    data: dataJson, 
                    dataType: "json",         
                    success : function(data)
                    {   
                        tableData.ajax.reload();
                        tableDataLombaInovasi.ajax.reload();
                        tableDataProper.ajax.reload();
                        if(data.IsSuccess)
                        {
                            swal({
                                title: "Berhasil",
                                text: data.Message,
                                icon: "success"
                            });
                        }
                        else
                        {
                            swal({
                                title: "Gagal",
                                text: data.Message,
                                icon: "error"
                            });
                        }
                    }  
                });
            }
        });
    }

    function generate_report(sumber)
    {
        window.location.href = "<?= base_url('admin/report/export') ?>"+"/"+$("#tahun").val()+"?sumber="+sumber;
    }
</script>

<?= $this->endSection() ?>