<?php

declare(strict_types=1);

/*
 * This file is part of PHP CS Fixer.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *     Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace PhpCsFixer\RuleSet\Sets;

use PhpCsFixer\Fixer\PhpUnit\PhpUnitTargetVersion;
use PhpCsFixer\RuleSet\AbstractRuleSetDescription;

/**
 * @internal
 */
final class PHPUnit43MigrationRiskySet extends AbstractRuleSetDescription
{
    public function getRules(): array
    {
        return [
            '@PHPUnit35Migration:risky' => true,
            'php_unit_no_expectation_annotation' => [
                'target' => PhpUnitTargetVersion::VERSION_4_3,
            ],
        ];
    }

    public function getDescription(): string
    {
        return 'Rules to improve tests code for PHPUnit 4.3 compatibility.';
    }
}
