<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\BeritaModel;

class Berita extends BaseController
{
    public function index()
    {
        $model_berita = new BeritaModel;
        $berita = $model_berita->findAll();

        $data['berita'] = $berita;
        return view('berita/index', $data);
    }

    public function tambah()
    {
        return view('berita/tambah');
    }

    public function simpan()
    {
        $fileName_gambar = null;
        $data_file_gambar = $this->request->getFile('gambar');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = "gambar_berita_".$data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/gambar_berita/', $fileName_gambar);
            } 
        }

        $users = new BeritaModel();
        $users->insert([
            'judul' => $this->request->getVar('judul'),
            'konten' => $this->request->getVar('konten'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'gambar' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);
              

        session()->setFlashdata('success', "Data berhasil disimpan");

        return redirect()->to(base_url('admin/berita'));
    }

    public function edit($id)
    {
        $data = new BeritaModel();
        $berita = $data->where('id', $id)->first();
        $param['berita'] = $berita;
        return view('berita/edit', $param);
    }

    public function update()
    {
        $id = $this->request->getVar('id');
        $fileName_gambar = $this->request->getVar('nama_file_gambar');    

        $data_file_gambar = $this->request->getFile('gambar');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = $data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/gambar_berita/', $fileName_gambar);
            }
        } 

        $users = new BeritaModel();
        $users->update($id, [
            'judul' => $this->request->getVar('judul'),
            'konten' => $this->request->getVar('konten'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'gambar' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);

        session()->setFlashdata('success', "Data berhasil diupdate");

        return redirect()->to(base_url('admin/berita'));
    }

    public function hapus($id)
    {
        $user = new BeritaModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function index_berita()
    {
        $model_berita = new BeritaModel;
        $berita = $model_berita
                    ->select('berita.*, u.name as nama_user')
                    ->join('user as u','berita.created_by = u.id')
                    ->where('berita.is_aktif', 1);

        $data['berita'] = $berita->paginate(30);
        $data['pager'] = $berita->pager;
        return view('front/index_berita', $data);
    }

    public function detail_berita($id)
    {
        $model_berita = new BeritaModel;
        $berita = $model_berita
                    ->select('berita.*, u.name as nama_user')
                    ->join('user as u','berita.created_by = u.id')
                    ->where('berita.id', $id);

        $data['berita'] = $berita->first();
        return view('front/detail_berita', $data);
    }
}
