<?php

namespace App\Controllers;
use App\Models\ProposalInovasiModel;
use App\Models\UrusanUtamaModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $modela = new ProposalInovasiModel();

        $data['total_indeks_inovasi'] = $modela->where('sumber', 'Indeks Inovasi')->countAllResults();
        $data['total_lomba_inovasi'] = $modela->where('sumber', 'Lomba Inovasi')->countAllResults();
        $data['total_proper'] = $modela->where('sumber', 'Proper')->countAllResults();

        $data['total_inisiatif'] = $modela->where('tahapan', 'Inisiatif')->countAllResults();
        $data['total_uji_coba'] = $modela->where('tahapan', 'Uji Coba')->countAllResults();
        $data['total_penerapan'] = $modela->where('tahapan', 'Penerapan')->countAllResults();

        $data['total_kepala_daerah'] = $modela->where('inisiator', 'Kepala Daerah')->countAllResults();
        $data['total_anggota_dprd'] = $modela->where('inisiator', 'Anggota DPRD')->countAllResults();
        $data['total_opd'] = $modela->where('inisiator', 'OPD')->countAllResults();
        $data['total_asn'] = $modela->where('inisiator', 'ASN')->countAllResults();
        $data['total_masyarakat'] = $modela->where('inisiator', 'Masyarakat')->countAllResults();
        
        $data['total_digital'] = $modela->where('jenis', 'Digital')->countAllResults();
        $data['total_non_digital'] = $modela->where('jenis', 'Non Digital')->countAllResults();

        $bid = $modela->select('bid.nama, count(bid.nama) as total')
                    ->join('bentuk_inovasi_daerah as bid','proposal_inovasi.bentuk_inovasi_daerah_id = bid.id')
                    ->groupBy('bid.nama')
                    ->findAll();

        $data['bid'] = $bid;

        $data['total_2021'] = $modela->where('YEAR(waktu_penerapan)', 2021)->countAllResults();
        $data['total_2022'] = $modela->where('YEAR(waktu_penerapan)', 2022)->countAllResults();
        $data['total_2023'] = $modela->where('YEAR(waktu_penerapan)', 2023)->countAllResults();

        return view('dashboard/index', $data);
    }

    public function get_data_urusa_utama()
    {
        $model = new UrusanUtamaModel();

        $data = $model->select('urusan_utama.nama, count(pi2.judul) AS total')
                ->join('proposal_inovasi pi2','pi2.urusan_utama_id = urusan_utama.id', 'left')
                ->groupBy('urusan_utama.nama')
                ->OrderBy('count(pi2.judul)', 'DESC')
                ->findAll();

        echo json_encode($data);
    }
}
