<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\InformasiPublikModel;

class InformasiPublik extends BaseController
{
    public function index()
    {
        $model_informasi_publik = new InformasiPublikModel;
        $informasi_publik = $model_informasi_publik->findAll();

        $data['informasi_publik'] = $informasi_publik;
        return view('informasi_publik/index', $data);
    }

    public function tambah()
    {
        return view('informasi_publik/tambah');
    }

    public function simpan()
    {
        $fileName_gambar = null;
        $data_file_gambar = $this->request->getFile('gambar');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = "gambar_informasi_publik_".$data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/gambar_informasi_publik/', $fileName_gambar);
            } 
        }

        $users = new InformasiPublikModel();
        $users->insert([
            'judul' => $this->request->getVar('judul'),
            'konten' => $this->request->getVar('konten'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'gambar' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);
              

        session()->setFlashdata('success', "Data berhasil disimpan");

        return redirect()->to(base_url('admin/informasi_publik'));
    }

    public function edit($id)
    {
        $data = new InformasiPublikModel();
        $informasi_publik = $data->where('id', $id)->first();
        $param['informasi_publik'] = $informasi_publik;
        return view('informasi_publik/edit', $param);
    }

    public function update()
    {
        $id = $this->request->getVar('id');
        $fileName_gambar = $this->request->getVar('nama_file_gambar');    

        $data_file_gambar = $this->request->getFile('gambar');

        if($data_file_gambar != null)
        {
            if($data_file_gambar->isValid())
            {
                $fileName_gambar = $data_file_gambar->getRandomName();
                $data_file_gambar->move('uploads/gambar_informasi_publik/', $fileName_gambar);
            }
        } 

        $users = new InformasiPublikModel();
        $users->update($id, [
            'judul' => $this->request->getVar('judul'),
            'konten' => $this->request->getVar('konten'),
            'is_aktif' => $this->request->getVar('is_aktif'),
            'gambar' => $fileName_gambar,
            'created_by' => session()->get('user_id')
        ]);

        session()->setFlashdata('success', "Data berhasil diupdate");

        return redirect()->to(base_url('admin/informasi_publik'));
    }

    public function hapus($id)
    {
        $user = new InformasiPublikModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function index_informasi_publik()
    {
        $model_informasi_publik = new InformasiPublikModel;
        $informasi_publik = $model_informasi_publik
                    ->select('informasi_publik.*, u.name as nama_user')
                    ->join('user as u','informasi_publik.created_by = u.id')
                    ->where('informasi_publik.is_aktif', 1);

        $data['informasi_publik'] = $informasi_publik->paginate(30);
        $data['pager'] = $informasi_publik->pager;
        return view('front/index_informasi_publik', $data);
    }

    public function detail_informasi_publik($id)
    {
        $model_informasi_publik = new InformasiPublikModel;
        $informasi_publik = $model_informasi_publik
                    ->select('informasi_publik.*, u.name as nama_user')
                    ->join('user as u','informasi_publik.created_by = u.id')
                    ->where('informasi_publik.id', $id);

        $data['informasi_publik'] = $informasi_publik->first();
        return view('front/detail_informasi_publik', $data);
    }
}
