<?php

namespace App\Controllers;

use App\Models\ProposalInovasiModel;
use Config\Services;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Laporan extends BaseController
{
    public function index()
    {
        return view('laporan/index');
    }

    public function get_data($id_hak_akses)
    {
        $request = Services::request();
        if(session()->get('id_hak_akses') == 2) //Pegawai
        {
            $data = new ProposalInovasiModel($request, session()->get('user_id'));
        }
        else
        {
            $data = new ProposalInovasiModel($request, 0, 0, $id_hak_akses);
        }
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $no;
                        $row[] = $list->nama_pengusul;
                        $row[] = $list->judul;
                        $row[] = $list->nama_satuan_kerja;                        
                        $row[] = $list->tema;
                        $row[] = $list->tahapan;
                        $row[] = $list->kategori;
                        $row[] = $list->skor;
                        $row[] = $list->skor_verifikasi;

                        if($id_hak_akses == 5)
                        {
                            $row[] = $list->penilaian_juri;
                        }
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function export($status)
    {
        $fileName = 'proposal.xlsx';  
        $spreadsheet = new Spreadsheet();

        $model = new ProposalInovasiModel();

        $data = $model->select('proposal_inovasi.*, u.name as nama_pengusul, o.nama as nama_organisasi, so.nama as nama_satuan_organisasi')
                    ->join('user as u','proposal_inovasi.user_id = u.id')
                    ->join('organisasi as o','u.id_organisasi = o.id')
                    ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
                    ->where('proposal_inovasi.status', $status)
                    ->findAll();
    
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'No');
        $sheet->setCellValue('B1', 'Nama Pengusul');
        $sheet->setCellValue('C1', 'Judul');
        $sheet->setCellValue('D1', 'Satuan Kerja');
        $sheet->setCellValue('E1', 'Tema');
        $sheet->setCellValue('F1', 'Tahapan');
        $sheet->setCellValue('G1', 'Kategori');
        $sheet->setCellValue('H1', 'Skor Mandiri');
        $sheet->setCellValue('I1', 'Skor PP');    

        if($status == "TJ")
        {
            $sheet->setCellValue('J1', 'Skor Tim Juri');  
        }          
         
        $rows = 2;
        $no = 1;
        foreach ($data as $val){
            $sheet->setCellValue('A' . $rows, $no);
            $sheet->setCellValue('B' . $rows, $val->nama_pengusul);
            $sheet->setCellValue('C' . $rows, $val->judul);
            $sheet->setCellValue('D' . $rows, $val->nama_satuan_organisasi);
            $sheet->setCellValue('E' . $rows, $val->tema);
            $sheet->setCellValue('F' . $rows, $val->tahapan);
            $sheet->setCellValue('G' . $rows, $val->kategori);
            $sheet->setCellValue('H' . $rows, $val->skor);
            $sheet->setCellValue('I' . $rows, $val->skor_verifikasi);

            if($status == "TJ")
            {
                $sheet->setCellValue('J' . $rows, $val->penilaian_juri);
            }
            
            $rows++;
        } 
        $writer = new Xlsx($spreadsheet);
        header("Content-Type: application/vnd.ms-excel");
        header('Content-Disposition: attachment;filename='.$fileName);
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }
}
