<?php 

namespace App\Controllers;
 
use App\Models\UserModel;
 
class Login extends BaseController
{
    public function index()
    {
        return view('front/login');
    }

    public function proses()
    {
        $users = new UserModel();

        $username = $this->request->getVar('email');
        $password = $this->request->getVar('password');

        $dataUser = $users->where([
            'email' => $username,
            'is_aktif' => 1
        ])->first();

        if ($dataUser) {
            if (password_verify($password, $dataUser->password)) {
                
                // if($dataUser->id_hak_akses == 2)
                // {
                //     session()->setFlashdata('error', 'Kompetisi INOVAKES sudah ditutup!');
                //     return redirect()->back();
                // }

                session()->set([
                    'user_id' => $dataUser->id,
                    'name' => $dataUser->name,
                    'email' => $dataUser->email,
                    'id_hak_akses' => $dataUser->id_hak_akses,
                    'is_aktif' => $dataUser->is_aktif,
                    'nip' => $dataUser->nip,
                    'tanggal_lahir' => $dataUser->tanggal_lahir,
                    'jenis_kelamin' => $dataUser->jenis_kelamin,
                    'id_provinsi' => $dataUser->id_provinsi,
                    'id_kabupaten' => $dataUser->id_kabupaten,
                    'alamat' => $dataUser->alamat,
                    'no_telp' => $dataUser->no_telp,
                    'file_skp' => $dataUser->file_skp,
                    'foto' => $dataUser->foto,
                    'logged_in' => TRUE,
                    'initial' => $this->getInitialsAttribute($dataUser->name)
                ]);

                return redirect()->to(base_url('admin/dashboard'));

            } else {

                session()->setFlashdata('error', 'Username & Password Salah');
                return redirect()->back();
            }
        } else {
            session()->setFlashdata('error', 'Akun anda tidak terdaftar atau tidak aktif');
            return redirect()->back();
        }
    }

    function getInitialsAttribute($name)
    {
        $name_array = explode(' ',trim($name));
    
        $firstWord = $name_array[0];

        if(count($name_array) > 1)
            $lastWord = $name_array[1][0];
        else
            $lastWord = "";
    
        return $firstWord[0]."".$lastWord;
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to(base_url('/'));
    }

    public function forget_password()
    {
        return view('front/forget_password');
    }

    public function reset_password()
    {
        helper('text');
        if (!$this->validate([
            'email' => [
                'rules' => 'required|min_length[4]',
                'errors' => [
                    'required' => '{field} Harus diisi',
                    'min_length' => '{field} Minimal 4 Karakter',
                ]
            ]
        ])) 
        {
            session()->setFlashdata('error', $this->validator->listErrors());
            return redirect()->back()->withInput();
        }

        $email = $this->request->getVar('email');
        $model = new UserModel();

        $user = $model->where('email', $email)->first();

        if($user == null)
        {
            session()->setFlashdata('error', "Email tidak terdaftar");
            return redirect()->back();
        }

        $token = random_string('alnum', 36);
        $model->update($user->id, [
            'remember_token' => $token
        ]);

        $url = base_url('_index_reset_password?remember_token='.$token.'&email='.$user->email);

        $message = "Silahkan klik link dibawah ini untuk melakukan reset password aplikasi <b>INOVAKES</b> <br><br>";
        $message .= "Link : <a href='".$url."'>Reset Password</a>";

        if($this->sendEmail($user->email, "Reset Password", $message))
        {
            session()->setFlashdata('success', "Reset berhasil, Silahkan cek email anda untuk proses selanjutnya");
        }
        else
        {
            session()->setFlashdata('error', "Kirim email gagal, periksa settingan Email");
        }

        
        return redirect()->to(base_url('login'));
    }

    private function sendEmail($to, $title, $message)
    {
        $email = \Config\Services::email();

        $email->setFrom('inovakes.kemenkesd2aqw@gmail.com','INOVAKES');
        $email->setTo($to);
        $email->setSubject($title);
        $email->setMessage($message);

		if(!$email->send()){
			return false;
		}else{
			return true;
		}
	}

    public function index_reset_password()
    {
        $email = $this->request->getVar('email');
        $token = $this->request->getVar('remember_token');

        $param['email'] = $email;
        $param['token'] = $token;

        return view('front/_index_reset_password', $param);
    }

    public function proses_reset_password()
    {
        if (!$this->validate([
            'password' => [
                'rules' => 'required|min_length[4]|max_length[50]',
                'errors' => [
                    'required' => '{field} Harus diisi',
                    'min_length' => '{field} Minimal 4 Karakter',
                    'max_length' => '{field} Maksimal 50 Karakter',
                ]
            ],
            'password_confirmation' => [
                'rules' => 'matches[password]',
                'errors' => [
                    'matches' => 'Konfirmasi Password tidak sesuai dengan password',
                ]
            ],
        ])) 
        {
            session()->setFlashdata('error', $this->validator->listErrors());
            return redirect()->back()->withInput();
        }

        $email = $this->request->getVar('email');
        $token = $this->request->getVar('token');

        $model = new UserModel();

        $user = $model->where('email', $email)->where('remember_token', $token)->first();

        if($user == null)
        {
            session()->setFlashdata('error', "Token expired");
            return redirect()->to(base_url('login'));
        }

        $model->update($user->id, [
            'remember_token' => null,
            'password' => password_hash($this->request->getVar('password'), PASSWORD_BCRYPT)
        ]);

        session()->setFlashdata('success', "Reset berhasil, Silahkan login");
        return redirect()->to(base_url('login'));
    }
}