<?php

namespace App\Controllers;

use App\Models\IndikatorModel;
use App\Models\ParameterModel;
use Config\Services;

class Parameter extends BaseController
{
    public function index()
    {
        $model = new IndikatorModel();

        $param['indikator'] = $model->where('jenis', 'Pilihan')->findAll();
        return view('parameter/index', $param);
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new ParameterModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $list->nama_indikator;
                        $row[] = $list->nama_parameter;
                        $row[] = $list->nilai;
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $id_indikator = $this->request->getVar('id_indikator');
        $nama = $this->request->getVar('nama');
        $nilai = $this->request->getVar('nilai');

        $model = new ParameterModel();

        if($id != 0)
        {
            //Update
            $model->update($id, [
                'nama' => $nama,
                'id_indikator' => $id_indikator,
                'nilai' => $nilai,
            ]);
        }
        else
        {
            //Create
            $model->insert([
                'nama' => $nama,
                'id_indikator' => $id_indikator,
                'nilai' => $nilai,
            ]);
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new ParameterModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new ParameterModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
