<?php

namespace App\Controllers;
use App\Models\ProposalInovasiModel;
use App\Models\IndikatorModel;
use App\Models\ParameterModel;
use App\Models\ProsesSirkulasiModel;
use App\Models\ProposalIndikatorDataPendukungModel;
use App\Models\ProposalIndikatorModel;
use App\Models\AspekPenilaianIndikatorModel;
use App\Models\AspekPenilaianModel;
use App\Models\PenilaianModel;
use App\Models\PenilaianSummaryModel;
use App\Helpers\InovakesHelper;
use Config\Services;
use App\Models\UserModel;
use App\Models\BentukInovasiDaerahModel;
use App\Models\UrusanUtamaModel;
use App\Models\UrusanUtamaDetailModel;
use App\Models\ProposalUrusanUtamaDetailModel;
use App\Models\ProposalUrusanUtamaModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ProposalInovasi extends BaseController
{
    private $db;

    public function __construct()
    {
        $this->db = db_connect();
    }

    public function index()
    {        
        return view('proposal_inovasi/index');      
    }

    public function get_data()
    {
        $request = Services::request();
        if(in_array(session()->get('id_hak_akses'), [7,8,9,10])) //Pegawai
        {
            $data = new ProposalInovasiModel($request, session()->get('user_id'), 0, 0, $_GET['sumber'], $_GET['status']);
        }
        else
        {
            $data = new ProposalInovasiModel($request, 0, 0, 0, $_GET['sumber'], $_GET['status']);
        }
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        
                        $no++;
                        $row = [];

                        if($list->status == "SELESAI")
                        {
                            $row[] = $no.' <i class="fas fa-check-circle text-success"></i>';
                        }
                        else
                        {
                            $row[] = $no;
                        }
                        
                        $row[] = $list->nama_hak_akses;
                        $row[] = $list->nama_pengusul;
                        $row[] = $list->judul;
                        $row[] = $list->tahapan;
                        $row[] = ($list->nilai_proposal ?? '0'); //nilai proposal
                        $row[] = $list->skor;//nilai indikator
                        $row[] = $list->skor_verifikasi;//nilai indikator
                        $row[] = ($list->kelengkapan_indikator ?? '0').'%';//kelengkapan indikator
                        $row[] = ($list->nilai_data_dukung ?? '0').'%';//nilai data dukung
                        if($_GET['status'] == "PRESENTASI" || $_GET['status'] == "VALIDASI LAPANGAN")
                        {
                            $row[] = number_format($list->nilai_presentasi,2);
                            $row[] = number_format($list->nilai_validasi_lapangan,2);
                        }
                        $row[] = InovakesHelper::GetUrlYoutube($list->id);//video
                        $row[] = $list->status;//video
                        // $row[] = $list->skor;
                        // $row[] = $list->skor_verifikasi;

                        // if(session()->get('id_hak_akses') == 5 || session()->get('id_hak_akses') == 1)
                        // {
                        //     $row[] = $list->penilaian_juri;
                        // }

                        

                        $row[] = '<a href="'.base_url('admin/proposal_inovasi/indikator/'.$list->id).'" class="btn btn-primary btn-sm">Indikator</a>';

                        if($list->status == "DRAFT" && (session()->get('id_hak_akses') >= 7 || session()->get('id_hak_akses') == 1) )
                        {                            
                            $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>
                                    <a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.',1)"><i class="fas fa-location-arrow"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                                    // <a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.')"><i class="fas fa-location-arrow"></i></a>
                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "REVIEW" && (in_array(session()->get('id_hak_akses'), [1,3,4,5])))
                        {
                            if(empty($_GET['status']))
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            else
                            {
                                $row[] = '<a href="javascript:;" title="Terima" class="text-success" onclick="Kirim('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                                    <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)"><i class="fas fa-undo"></i></a>
                                    <a href="javascript:;" title="Tolak" class="text-danger" onclick="Kirim('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "HASIL REVIEW" && (in_array(session()->get('id_hak_akses'), [1,3,4,5])))
                        {
                            if(empty($_GET['status']))
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            else
                            {
                                $row[] = '<a href="javascript:;" title="Terima" class="text-success" onclick="Kirim('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                                    <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)"><i class="fas fa-undo"></i></a>
                                    <a href="javascript:;" title="Tolak" class="text-danger" onclick="Kirim('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "INOVASI DITOLAK" && (in_array(session()->get('id_hak_akses'), [1,3,4,5])))
                        {
                            if(empty($_GET['status']))
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            else
                            {
                                $row[] = '<a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)"><i class="fas fa-undo"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "PRESENTASI" && (in_array(session()->get('id_hak_akses'), [1,5])))
                        {
                            if(empty($_GET['status']))
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            else
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/pemberian_nilai/'.$list->id).'" title="Pemberian Nilai" class="text-success"><i class="fas fa-check-double"></i></a>
                                    <a href="javascript:;" title="Terima" class="text-success" onclick="Kirim('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                                    <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)"><i class="fas fa-undo"></i></a>
                                    <a href="javascript:;" title="Tolak" class="text-danger" onclick="Kirim('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "VALIDASI LAPANGAN" && (in_array(session()->get('id_hak_akses'), [1,5])))
                        {
                            if(empty($_GET['status']))
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            else
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/pemberian_nilai/'.$list->id).'" title="Pemberian Nilai" class="text-success"><i class="fas fa-check-double"></i></a>
                                    <a href="javascript:;" title="Terima" class="text-success" onclick="Kirim('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                                    <a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)"><i class="fas fa-undo"></i></a>
                                    <a href="javascript:;" title="Tolak" class="text-danger" onclick="Kirim('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                            }
                            

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "SELESAI")
                        {
                            $row[] = '<a href="javascript:;" title="Kembalikan" class="text-primary" onclick="Kirim('.$list->id.',2)"><i class="fas fa-undo"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        // else if($list->status == "TA" && (session()->get('id_hak_akses') == 3 || session()->get('id_hak_akses') == 1))
                        // {
                        //     $row[] = '<a href="javascript:;" title="Terima" class="text-success" onclick="AksiTA('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                        //             <a href="javascript:;" title="Tolak" class="text-danger" onclick="AksiTA('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                        //             <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                        //             // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        // }
                        // else if($list->status == "TR" && (session()->get('id_hak_akses') == 4 || session()->get('id_hak_akses') == 1))
                        // {
                        //     $row[] = '<a href="javascript:;" title="Terima" class="text-success" onclick="AksiTR('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                        //             <a href="javascript:;" title="Tolak" class="text-danger" onclick="AksiTR('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                        //             <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                        //             // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        // }
                        // else if($list->status == "TJ" && (session()->get('id_hak_akses') == 5 || session()->get('id_hak_akses') == 1))
                        // {
                        //     if(InovakesHelper::CheckProposalSudahDinilaiJuri($list->id))
                        //     {
                        //         $row[] = '<a href="'.base_url('admin/proposal_inovasi/pemberian_nilai/'.$list->id).'" title="Pemberian Nilai" class="text-success"><i class="fas fa-check-double"></i></a> |
                        //             <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                        //             // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        //     }
                        //     else
                        //     {
                        //         $row[] = '<a href="javascript:;" title="Tolak" class="text-danger" onclick="AksiTJ('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                        //             <a href="'.base_url('admin/proposal_inovasi/pemberian_nilai/'.$list->id).'" title="Pemberian Nilai" class="text-success"><i class="fas fa-check-double"></i></a> |
                        //             <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                        //             <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                        //             // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        //     }
                            
                        // }
                        else
                        {
                            $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                        }
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function tambah()
    {
        $bentuk_inovasi = new BentukInovasiDaerahModel();
        $urusan_utama = new UrusanUtamaModel();

        $data['bentuk_inovasi_daerah'] = $bentuk_inovasi->findAll();
        $data['urusan_utama'] = $urusan_utama->findAll();
        return view('proposal_inovasi/tambah', $data);
    }

    public function simpan()
    {
        $fileName_anggaran = null;
        $data_file_anggaran = $this->request->getFile('file_anggaran');

        if($data_file_anggaran != null)
        {
            if($data_file_anggaran->isValid())
            {
                $fileName_anggaran = "file_anggaran_".$data_file_anggaran->getRandomName();
                $data_file_anggaran->move('uploads/proses_inovasi/', $fileName_anggaran);
            } 
        }

        $fileName_profile = null;
        $data_file_profile = $this->request->getFile('file_profile_bisnis');

        if($data_file_profile != null)
        {
            if($data_file_profile->isValid())
            {
                $fileName_profile = "file_profile_".$data_file_profile->getRandomName();
                $data_file_profile->move('uploads/proses_inovasi/', $fileName_profile);
            } 
        }

        $total_kata_rancang_bangun = str_word_count(strip_tags($this->request->getVar('rancang_bangun')));
        $total_kata_tujuan = str_word_count(strip_tags($this->request->getVar('tujuan')));
        $total_kata_manfaat = str_word_count(strip_tags($this->request->getVar('manfaat')));
        $total_kata_hasil = str_word_count(strip_tags($this->request->getVar('hasil_inovasi')));

        $nilai_proposal = 0;

        if($total_kata_rancang_bangun >= 300)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        if($total_kata_tujuan >= 100)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        if($total_kata_manfaat >= 100)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        if($total_kata_hasil >= 100)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        $users = new ProposalInovasiModel();
        $users->insert([
            'sumber' => $this->request->getVar('sumber'),
            'judul' => $this->request->getVar('judul'),
            'tahapan' => $this->request->getVar('tahapan'),
            'inisiator' => $this->request->getVar('inisiator'),
            'jenis' => $this->request->getVar('jenis'),
            'bentuk_inovasi_daerah_id' => $this->request->getVar('bentuk_inovasi_daerah_id'),
            'urusan_utama_id' => $this->request->getVar('urusan_utama_id'),
            'waktu_uji_coba' => $this->request->getVar('waktu_uji_coba'),
            'waktu_penerapan' => $this->request->getVar('waktu_penerapan'),
            'rancang_bangun' => $this->request->getVar('rancang_bangun'),
            'tujuan' => $this->request->getVar('tujuan'),
            'manfaat' => $this->request->getVar('manfaat'),
            'hasil_inovasi' => $this->request->getVar('hasil_inovasi'),
            'file_anggaran' => $fileName_anggaran,
            'file_profile_bisnis' => $fileName_profile,
            'user_id' => session()->get('user_id'),
            'status' => 'DRAFT',
            'tahun' => date('Y'),
            'nilai_proposal' => $nilai_proposal
        ]);

        // insert detail
        $urusan_utama_detail = $this->request->getVar('urusan_utama_detail_id');

        if($urusan_utama_detail != null)
        {
            for($i = 0; $i < count($urusan_utama_detail); $i++)
            {
                $detail = new ProposalUrusanUtamaModel();
                $detail->insert([
                    'proposal_inovasi_id' => $users->getInsertID(),
                    'urusan_utama_id' => $urusan_utama_detail[$i]
                ]);
            }
        }        

        session()->setFlashdata('success', "Data berhasil disimpan");

        return redirect()->to(base_url('admin/proposal_inovasi').'?tab='.$this->request->getVar('sumber'));
    }

    public function edit($id)
    {
        $data = new ProposalInovasiModel();
        $bentuk_inovasi = new BentukInovasiDaerahModel();
        $urusan_utama = new UrusanUtamaModel();
        // $urusan_utama_detail = new UrusanUtamaDetailModel();
        $proposal = $data->where('id', $id)->first();
        $proposal_urusan_utama_detail = new ProposalUrusanUtamaModel();

        $x = $proposal_urusan_utama_detail->where('proposal_inovasi_id', $id)->findAll();
        $arr_urusan_utama_detail = [];
        foreach($x as $val)
        {
            $arr_urusan_utama_detail[] = $val->urusan_utama_id;
        }

        $param['bentuk_inovasi_daerah'] = $bentuk_inovasi->findAll();
        $param['urusan_utama'] = $urusan_utama->findAll();
        $param['proposal'] = $proposal;
        // $param['urusan_utama_detail'] = $urusan_utama_detail->where('urusan_utama_id', $proposal->urusan_utama_id)->findAll();
        $param['arr_urusan_utama_detail'] = $arr_urusan_utama_detail;
        return view('proposal_inovasi/edit', $param);
    }

    public function update()
    {
        $id = $this->request->getVar('id');
        $fileNameAnggaran = $this->request->getVar('nama_file_anggaran');        
        $fileNameProfile = $this->request->getVar('nama_file_profile_bisnis');

        $dataFileAnggaran = $this->request->getFile('file_anggaran');

        if($dataFileAnggaran != null)
        {
            if($dataFileAnggaran->isValid())
            {
                $fileNameAnggaran = $dataFileAnggaran->getRandomName();
                $dataFileAnggaran->move('uploads/proses_inovasi/', $fileNameAnggaran);
            }
        }   
        
        $dataFileProfile = $this->request->getFile('file_profile_bisnis');

        if($dataFileProfile != null)
        {
            if($dataFileProfile->isValid())
            {
                $fileNameProfile = $dataFileProfile->getRandomName();
                $dataFileProfile->move('uploads/proses_inovasi/', $fileNameProfile);
            }
        } 

        $total_kata_rancang_bangun = str_word_count(strip_tags($this->request->getVar('rancang_bangun')));
        $total_kata_tujuan = str_word_count(strip_tags($this->request->getVar('tujuan')));
        $total_kata_manfaat = str_word_count(strip_tags($this->request->getVar('manfaat')));
        $total_kata_hasil = str_word_count(strip_tags($this->request->getVar('hasil_inovasi')));

        $nilai_proposal = 0;

        if($total_kata_rancang_bangun >= 300)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        if($total_kata_tujuan >= 100)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        if($total_kata_manfaat >= 100)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        if($total_kata_hasil >= 100)
        {
            $nilai_proposal = $nilai_proposal + 25;
        }

        $users = new ProposalInovasiModel();
        $users->update($id, [
            'sumber' => $this->request->getVar('sumber'),
            'judul' => $this->request->getVar('judul'),
            'tahapan' => $this->request->getVar('tahapan'),
            'inisiator' => $this->request->getVar('inisiator'),
            'jenis' => $this->request->getVar('jenis'),
            'bentuk_inovasi_daerah_id' => $this->request->getVar('bentuk_inovasi_daerah_id'),
            'urusan_utama_id' => $this->request->getVar('urusan_utama_id'),
            'waktu_uji_coba' => $this->request->getVar('waktu_uji_coba'),
            'waktu_penerapan' => $this->request->getVar('waktu_penerapan'),
            'rancang_bangun' => $this->request->getVar('rancang_bangun'),
            'tujuan' => $this->request->getVar('tujuan'),
            'manfaat' => $this->request->getVar('manfaat'),
            'hasil_inovasi' => $this->request->getVar('hasil_inovasi'),
            'file_anggaran' => $fileNameAnggaran,
            'file_profile_bisnis' => $fileNameProfile,
            'nilai_proposal' => $nilai_proposal
        ]);

        //insert detail
        $hapus_detail = new ProposalUrusanUtamaModel();
        $hapus_detail->where('proposal_inovasi_id', $id)->delete();

        $urusan_utama_detail = $this->request->getVar('urusan_utama_detail_id');

        if($urusan_utama_detail != null)
        {
            for($i = 0; $i < count($urusan_utama_detail); $i++)
            {
                $detail = new ProposalUrusanUtamaModel();
                $detail->insert([
                    'proposal_inovasi_id' => $id,
                    'urusan_utama_id' => $urusan_utama_detail[$i]
                ]);
            }
        }

        session()->setFlashdata('success', "Data berhasil diupdate");

        return redirect()->to(base_url('admin/proposal_inovasi').'?tab='.$this->request->getVar('sumber'));
    }

    public function detail($id)
    {
        $data = new ProposalInovasiModel();
        $proposal = $data->where('id', $id)->first();

        $user_model = new UserModel();
        $user = $user_model->find($proposal->user_id);

        $param['proposal'] = $proposal;
        $param['user'] = $user;
        $param['provinsi'] = $user_model->provinsi($user->id_provinsi);
        $param['kabupaten'] = $user_model->kabupaten($user->id_kabupaten);
        $param['organisasi'] = $user_model->organisasi($user->id_organisasi);
        $param['satuan_organisasi'] = $user_model->satuan_organisasi($user->id_satuan_organisasi);

        return view('proposal_inovasi/detail', $param);
    }

    public function hapus($id)
    {
        $user = new ProposalInovasiModel();
        $user->delete($id);

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function kirim_old()
    {
        $id = $this->request->getVar('id');

        $data = new ProposalInovasiModel();
        $data->update($id, [
            'status' => 'TA'
        ]);

        $sirkulasi = new ProsesSirkulasiModel();
        $sirkulasi->insert([
            'id_proposal' => $id,
            'user_id' => session()->get('user_id'),
            'role' => 'Pegawai',
            'keterangan' => 'Kirim'
        ]);

        $result['IsSuccess'] = TRUE;
        $result['Message'] = "Proposal berhasil dikirim";

        echo json_encode($result);
    }

    public function kirim()
    {
        $id = $this->request->getVar('id');
        $status = $this->request->getVar('status');

        $data = new ProposalInovasiModel();
        $data_status = $data->where('id', $id)->first();

        $next_status = $data_status->status;
        if($status == 1)
        {
            $pesan = "dikirim";
            if($data_status->status == ProposalInovasiModel::DRAFT)
            {
                $next_status = ProposalInovasiModel::REVIEW;
            }
            else if($data_status->status == ProposalInovasiModel::REVIEW)
            {
                $next_status = ProposalInovasiModel::HASILREVIEW;
            }
            else if($data_status->status == ProposalInovasiModel::HASILREVIEW)
            {
                $next_status = ProposalInovasiModel::PRESENTASI;
            }
            else if($data_status->status == ProposalInovasiModel::PRESENTASI)
            {
                $next_status = ProposalInovasiModel::VALIDASILAPANGAN;
            }
            else if($data_status->status == ProposalInovasiModel::VALIDASILAPANGAN)
            {
                $next_status = ProposalInovasiModel::SELESAI;
                $pesan = "disimpan dan sudah selesai";
            }
        }
        else if($status == 2) //Dikembalikan
        {
            $pesan = "dikembalikan";
            $next_status = ProposalInovasiModel::DRAFT;
        }
        else
        {
            $pesan = "ditolak";
            $next_status = ProposalInovasiModel::DITOLAK;
        }      
        
        if($next_status == ProposalInovasiModel::DRAFT)
        {
            $data->update($id, [
                'status' => $next_status,
                'nilai_presentasi' => 0,
                'nilai_validasi_lapangan' => 0
            ]);

            $model_delete = new PenilaianModel();
            $model_delete->where('id_proposal', $id)
                    ->delete();

            $model_penyajian = new PenilaianSummaryModel();
            $model_penyajian->where('id_proposal', $id)
                    ->delete();
        }
        else
        {
            $data->update($id, [
                'status' => $next_status
            ]);
        }

        

        $sirkulasi = new ProsesSirkulasiModel();
        $sirkulasi->insert([
            'id_proposal' => $id,
            'user_id' => session()->get('user_id'),
            'role' => session()->get('id_hak_akses'),
            'keterangan' => 'Kirim'
        ]);

        $result['IsSuccess'] = TRUE;
        $result['Message'] = "Proposal berhasil ".$pesan;

        echo json_encode($result);
    }

    public function kirim_ta()
    {
        $id = $this->request->getVar('id');
        $status = $this->request->getVar('status');

        if($status == 1)
            $stat = 'TR';
        else
            $stat = 'DRAFT';

        $data = new ProposalInovasiModel();
        $data->update($id, [
            'status' => $stat
        ]);

        $sirkulasi = new ProsesSirkulasiModel();
        $sirkulasi->insert([
            'id_proposal' => $id,
            'user_id' => session()->get('user_id'),
            'role' => 'TA',
            'keterangan' => $status == 1 ? "Terima" : "Tolak"
        ]);

        $result['IsSuccess'] = TRUE;
        $result['Message'] = "Proposal berhasil Di". ($status == 1 ? "terima" : "tolak");

        echo json_encode($result);
    }

    public function kirim_tr()
    {
        $id = $this->request->getVar('id');
        $status = $this->request->getVar('status');

        if($status == 1)
            $stat = 'TJ';
        else
            $stat = 'TA';

        $data = new ProposalInovasiModel();
        $data->update($id, [
            'status' => $stat
        ]);

        $sirkulasi = new ProsesSirkulasiModel();
        $sirkulasi->insert([
            'id_proposal' => $id,
            'user_id' => session()->get('user_id'),
            'role' => 'TR',
            'keterangan' => $status == 1 ? "Terima" : "Tolak"
        ]);

        $result['IsSuccess'] = TRUE;
        $result['Message'] = "Proposal berhasil Di". ($status == 1 ? "terima" : "tolak");

        echo json_encode($result);
    }

    public function kirim_tj()
    {
        $id = $this->request->getVar('id');
        $status = $this->request->getVar('status');

        if($status == 1)
            $stat = 'TJ';
        else
            $stat = 'TR';

        $data = new ProposalInovasiModel();
        $data->update($id, [
            'status' => $stat
        ]);

        $sirkulasi = new ProsesSirkulasiModel();
        $sirkulasi->insert([
            'id_proposal' => $id,
            'user_id' => session()->get('user_id'),
            'role' => 'TJ',
            'keterangan' => $status == 1 ? "Terima" : "Tolak"
        ]);

        $result['IsSuccess'] = TRUE;
        $result['Message'] = "Proposal berhasil Di". ($status == 1 ? "terima" : "tolak");

        echo json_encode($result);
    }

    public function indikator($id_proposal)
    {
        $modelIndikator = new IndikatorModel();
        $indikator = $modelIndikator->findAll();

        $param['indikator'] = $indikator;
        $param['id_proposal'] = $id_proposal;
        
        return view('proposal_inovasi/index_indikator', $param);      
    }

    public function parameter_by_indikator($id_indikator)
    {
        $id_proposal = $this->request->getVar('id_proposal');
        $modelPI = new ProposalIndikatorModel();
        $dataPI = $modelPI->where('id_proposal', $id_proposal)
                    ->where('id_indikator', $id_indikator)
                    ->first();

        $model = new ParameterModel();
        $data = $model->where('id_indikator', $id_indikator)->findAll();

        $resp['parameter'] = $data;
        $resp['parameter_indikator'] = $dataPI;

        return $this->response->setJSON($resp);
    }

    public function simpan_parameter()
    {
        $parameter = explode("|", $this->request->getVar('id_parameter'));
        $id_parameter = $parameter[0];
        $nilai_parameter = $parameter[1];

        $id_proposal = $this->request->getVar('id_proposal');
        $id_indikator = $this->request->getVar('id_indikator');

        $model = new ProposalIndikatorModel();
        $data_eksis = $model->where('id_proposal', $id_proposal)
                        ->where('id_indikator', $id_indikator)
                        ->first();

        $cek_data_pendukung = InovakesHelper::CheckDataPendukung($id_proposal, $id_indikator);

        $nilai = InovakesHelper::GenerateNilaiParameterIndikator($id_indikator, $nilai_parameter);
        $keterangan_perubahan = $this->request->getVar('keterangan_perubahan');

        // if($cek_data_pendukung == "Ada")
        // {
        //     $nilai = InovakesHelper::GenerateNilaiParameterIndikator($id_indikator, $nilai_parameter);
        // }

        if($data_eksis == null)
        {            
            if(in_array(session()->get('id_hak_akses'), [1,3,4,5])) // Tim review dkk
            {
                $model->insert([
                    'id_parameter' => $id_parameter,
                    'id_proposal' => $id_proposal,
                    'id_indikator' => $id_indikator,
                    'nilai_verifikasi' => $nilai,
                    'keterangan_perubahan' => $keterangan_perubahan
                ]);
            }
            else
            {
                $model->insert([
                    'id_parameter' => $id_parameter,
                    'id_proposal' => $id_proposal,
                    'id_indikator' => $id_indikator,
                    'nilai' => $nilai,
                    'nilai_verifikasi' => $nilai,
                    'keterangan_perubahan' => $keterangan_perubahan
                ]);
            }            
        }
        else{            

            if(in_array(session()->get('id_hak_akses'),[1,3,4,5])) // Tim Review
            {
                $model->update($data_eksis->id, [
                    'id_parameter' => $id_parameter,
                    'nilai_verifikasi' => $nilai,
                    'keterangan_perubahan' => $keterangan_perubahan
                ]);
            } 
            else
            {
                $model->update($data_eksis->id, [
                    'id_parameter' => $id_parameter,
                    'nilai' => $nilai,
                    'nilai_verifikasi' => $nilai,
                    'keterangan_perubahan' => $keterangan_perubahan
                ]);
            }           
        }

        $model_indikator = new IndikatorModel();
        $total_indikator = $model_indikator->countAllResults();

        $model_proposal_indikator = new ProposalIndikatorModel();
        $total_parameter = $model_proposal_indikator->where('id_proposal', $id_proposal)
                        ->countAllResults();

        $kelengkapan_indikator = ($total_parameter / $total_indikator) * 100;

        $model_pi = new ProposalInovasiModel();        

        if(in_array(session()->get('id_hak_akses'),[1,3,4,5])) // Tim review
        {
            $skor = InovakesHelper::GenerateSkorVerifikasi($id_proposal);
            
            $model_pi->update($id_proposal, [
                'skor_verifikasi' => $skor == 0 ? $skor : $skor[0]->nilai_verifikasi,
                'kelengkapan_indikator' => $kelengkapan_indikator
            ]);
        }
        else
        {
            $skor = InovakesHelper::GenerateSkor($id_proposal);
            
            $model_pi->update($id_proposal, [
                'skor' => $skor == 0 ? $skor : $skor[0]->nilai,
                'skor_verifikasi' => $skor == 0 ? $skor : $skor[0]->nilai,
                'kelengkapan_indikator' => $kelengkapan_indikator
            ]);
        }

        session()->setFlashdata('success', "Data berhasil disimpan");
        return redirect()->back();
    }

    public function data_pendukung()
    {
        $id_proposal = $this->request->getVar('id_proposal');
        $id_indikator = $this->request->getVar('id_indikator');

        $model = new ProposalIndikatorModel();
        $data_eksis = $model->where('id_proposal', $id_proposal)
                        ->where('id_indikator', $id_indikator)
                        ->first();
        
        if($data_eksis == null)
        {
            session()->setFlashdata('error', "Data indikator belum dipilih");
            return redirect()->to(base_url('admin/proposal_inovasi/indikator/'.$id_proposal));
        }

        $model = new ProposalIndikatorDataPendukungModel();

        $data = $model->where('id_proposal', $id_proposal)
                    ->where('id_indikator', $id_indikator)
                    ->findAll();

        $param['data'] = $data;
        $param['id_proposal'] = $id_proposal;
        $param['id_indikator'] = $id_indikator;
        
        return view('proposal_inovasi/data_pendukung', $param);    
    }

    public function tambah_data_pendukung()
    {
        $id_proposal = $this->request->getVar('id_proposal');
        $id_indikator = $this->request->getVar('id_indikator');

        $model = new IndikatorModel();
        $indikator = $model->where('id', $id_indikator)
                        ->first();

        $param['id_proposal'] = $id_proposal;
        $param['id_indikator'] = $id_indikator;
        $param['indikator'] = $indikator;

        return view('proposal_inovasi/tambah_data_pendukung', $param);    
    }

    public function simpan_data_pendukung()
    {
        $id_proposal = $this->request->getVar('id_proposal');
        $id_indikator = $this->request->getVar('id_indikator');
        $nama = $this->request->getVar('nama');
        $keterangan = $this->request->getVar('keterangan');
        $url_youtube = $this->request->getVar('url_youtube');
        $tipe = $this->request->getVar('tipe');
        $jenis_file = $this->request->getVar('jenis_file');

        $model = new ProposalIndikatorDataPendukungModel();
        $fileName = "";

        if($jenis_file != "Video")
        {
            $dataFoto = $this->request->getFile('file');
            $fileName = $dataFoto->getRandomName();
            $dataFoto->move('uploads/data_pendukung/', $fileName);
        }

        $model->insert([
            'id_proposal' => $id_proposal,
            'id_indikator' => $id_indikator,
            'nama' => $nama,
            'keterangan' => $keterangan,
            'file' => $fileName,
            'url_youtube' => $url_youtube,
            'tipe' => $jenis_file
        ]);

        $model_indikator = new IndikatorModel();
        $total_indikator = $model_indikator->countAllResults();

        $model_proposal_indikator = new ProposalIndikatorDataPendukungModel();
        $total_parameter = $model_proposal_indikator->where('id_proposal', $id_proposal)
                        ->groupBy('id_indikator')
                        ->countAllResults();

        $nilai_data_dukung = ($total_parameter / $total_indikator) * 100;

        $model_pi = new ProposalInovasiModel();     

        if(in_array(session()->get('id_hak_akses'),[1,3,4,5])) // Tim review
        {
            $skor = InovakesHelper::GenerateSkorVerifikasi($id_proposal);
            
            $model_pi->update($id_proposal, [
                'skor_verifikasi' => $skor == 0 ? $skor : $skor[0]->nilai_verifikasi,
                'nilai_data_dukung' => $nilai_data_dukung
            ]);
        }
        else
        {
            $skor = InovakesHelper::GenerateSkor($id_proposal);
            
            $model_pi->update($id_proposal, [
                'skor' => $skor == 0 ? $skor : $skor[0]->nilai,
                'skor_verifikasi' => $skor == 0 ? $skor : $skor[0]->nilai,
                'nilai_data_dukung' => $nilai_data_dukung
            ]);
        }

        session()->setFlashdata('success', "Data berhasil disimpan");
        return redirect()->to(base_url('admin/proposal_inovasi/data_pendukung?id_proposal='.$id_proposal.'&id_indikator='. $id_indikator));
    }

    public function edit_data_pendukung()
    {
        $id = $this->request->getVar('id');

        $model = new ProposalIndikatorDataPendukungModel();
        $data = $model->where('id', $id)->first();

        $model = new IndikatorModel();
        $indikator = $model->where('id', $data->id_indikator)
                        ->first();

        $param['data'] = $data;
        $param['indikator'] = $indikator;

        return view('proposal_inovasi/edit_data_pendukung', $param);    
    }

    public function update_data_pendukung()
    {
        $id_proposal = $this->request->getVar('id_proposal');
        $id_indikator = $this->request->getVar('id_indikator');
        $id = $this->request->getVar('id');
        $nama = $this->request->getVar('nama');
        $keterangan = $this->request->getVar('keterangan');
        $nama_file = $this->request->getVar('nama_file');
        $url_youtube = $this->request->getVar('url_youtube');
        $tipe = $this->request->getVar('tipe');
        $jenis_file = $this->request->getVar('jenis_file');

        $model = new ProposalIndikatorDataPendukungModel();

        $fileName = $nama_file;

        if($jenis_file != "Video")
        {
            $dataFoto = $this->request->getFile('file');
            
            if($dataFoto->isValid())
            {
                $fileName = $dataFoto->getRandomName();
                $dataFoto->move('uploads/data_pendukung/', $fileName);
            }            
        }       

        $model->update($id,[
            'nama' => $nama,
            'keterangan' => $keterangan,
            'file' => $fileName,
            'url_youtube' => $url_youtube,
            'tipe' => $jenis_file
        ]);

        session()->setFlashdata('success', "Data berhasil disimpan");
        return redirect()->to(base_url('admin/proposal_inovasi/data_pendukung?id_proposal='.$id_proposal.'&id_indikator='. $id_indikator));
    }

    public function hapus_data_pendukung()
    {
        $id = $this->request->getVar('id');

        $model = new ProposalIndikatorDataPendukungModel();
        $data_model = $model->where('id', $id)->first();

        $id_proposal = $data_model->id_proposal;

        $user = new ProposalIndikatorDataPendukungModel();
        $user->delete($id);

        $model_pi = new ProposalInovasiModel();
        $model_indikator = new IndikatorModel();
        $total_indikator = $model_indikator->countAllResults();

        $model_proposal_indikator = new ProposalIndikatorDataPendukungModel();
        $total_parameter = $model_proposal_indikator->where('id_proposal', $id_proposal)
                        ->groupBy('id_indikator')
                        ->countAllResults();

        $nilai_data_dukung = ($total_parameter / $total_indikator) * 100;

        if(session()->get('id_hak_akses') == 2 || session()->get('id_hak_akses') == 1) // Tim Review
        {
            

            $skor = InovakesHelper::GenerateSkorVerifikasi($id_proposal);
            
            $model_pi->update($id_proposal, [
                'skor_verifikasi' => $skor == 0 ? $skor : $skor[0]->nilai_verifikasi,
                'nilai_data_dukung' => $nilai_data_dukung
            ]);
        }
        else
        {
            $skor = InovakesHelper::GenerateSkor($id_proposal);
            
            $model_pi->update($id_proposal, [
                'skor' => $skor == 0 ? $skor : $skor[0]->nilai,
                'skor_verifikasi' => $skor == 0 ? $skor : $skor[0]->nilai,
            ]);
        }                

        session()->setFlashdata('success', "Data berhasil dihapus");
        return redirect()->back();
    }

    public function download($id_proposal)
    {
        $model = new ProposalInovasiModel();
        $indikator_model = new IndikatorModel();

        $data = $model->where('id', $id_proposal)->first();
        $indikator = $indikator_model->findAll();

        $param['data'] = $data;
        $param['indikator'] = $indikator;

        $dompdf = new \Dompdf\Dompdf(); 
        $dompdf->loadHtml(view('proposal_inovasi/download', $param));
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
        $dompdf->stream("Proposal Inovasi.pdf");
    }

    public function pemberian_nilai($id_proposal)
    {
        $model = new ProposalInovasiModel();
        $modelAPI = new AspekPenilaianIndikatorModel();
        $aspek_penilaian_model = new AspekPenilaianModel();

        $proposal = $model->where('id', $id_proposal)->first();
        $penyajian = $modelAPI->select('aspek_penilaian_indikator.*, b.nama as nama_aspek_penilaian')
                        ->join('aspek_penilaian as b','aspek_penilaian_indikator.id_aspek_penilaian = b.id')
                        ->where('aspek_penilaian_indikator.tipe','Penyajian')
                        ->orderby('b.nama ASC')
                        ->findAll();

        $substansi = $modelAPI->select('aspek_penilaian_indikator.*, b.nama as nama_aspek_penilaian')
                        ->join('aspek_penilaian as b','aspek_penilaian_indikator.id_aspek_penilaian = b.id')
                        ->where('aspek_penilaian_indikator.tipe','Substansi')
                        ->orderby('b.nama ASC')
                        ->findAll();
        
        if($proposal->status == 'PRESENTASI')
            $aspek_penilaian = $aspek_penilaian_model->where('jenis', 'Presentasi')->findAll();
        else
            $aspek_penilaian = $aspek_penilaian_model->where('jenis', 'Validasi Lapangan')->findAll();

        $model_juri = new PenilaianSummaryModel();
        $juri = $model_juri->select('MAX(u.name) as nama_juri, SUM(penilaian_summary.nilai) as total_nilai')
                    ->join('user as u','penilaian_summary.user_id = u.id')
                    ->groupBy('penilaian_summary.user_id')
                    ->where('penilaian_summary.id_proposal', $id_proposal)
                    ->where('penilaian_summary.tipe', $proposal->status)
                    ->findAll();        

        $param['id_proposal'] = $id_proposal;
        $param['proposal'] = $proposal;
        $param['nama_user'] = $model->GetNamaUser($proposal->user_id);
        $param['penyajian'] = $penyajian;
        $param['substansi'] = $substansi;
        $param['juri'] = $juri;
        $param['aspek_penilaian'] = $aspek_penilaian;

        return view('proposal_inovasi/pemberian_nilai', $param);  
    }

    public function simpan_penilaian()
    {
        $id_proposal = $this->request->getVar('id_proposal');

        $model = new PenilaianModel();
        $model_delete = new PenilaianModel();
        $proposal_inovasi_model = new ProposalInovasiModel();

        $proposal = $proposal_inovasi_model->where('id', $id_proposal)->first();

        $model_delete->where('id_proposal', $id_proposal)
                ->where('user_id', session()->get('user_id'))
                ->delete();

        $id_aspek_penilaian = $this->request->getVar('id_aspek_penilaian');
        $nilai_penyajian = $this->request->getVar('nilai_penyajian');

        for($i = 0; $i < count($id_aspek_penilaian); $i++)
        {
            $model->insert([
                'id_proposal' => $id_proposal,
                'tipe' => $proposal->status,
                'id_aspek_penilaian' => $id_aspek_penilaian[$i],
                'nilai' => $nilai_penyajian[$i],
                'user_id' => session()->get('user_id')
            ]);
        }
        //tidak perlu dikali bobot, cukup disummary (30 May 2023)
        $model_penyajian = new PenilaianSummaryModel();
        $model_penyajian_delete = new PenilaianSummaryModel();
        $model_penyajian_delete->where('id_proposal', $id_proposal)
                ->where('user_id', session()->get('user_id'))
                ->delete();
                
        $model_penyajian->insert([
            'id_proposal' => $id_proposal,
            'tipe' => $proposal->status,
            'nilai' => array_sum($nilai_penyajian),
            'user_id' => session()->get('user_id')
        ]);

        if($proposal->status == "PRESENTASI")
        {
            //Update nilai juri
            $nilai_juri = InovakesHelper::GenerateNilaiJuriNew($id_proposal,$proposal->status);

            $model = new ProposalInovasiModel();
            $model->update($id_proposal, [
                'nilai_presentasi' => $nilai_juri
            ]);

            session()->setFlashdata('success', "Data berhasil disimpan");
            return redirect()->to(base_url('admin/proposal_inovasi/presentasi'));
        }
        else
        {
            //Update nilai juri
            $nilai_juri = InovakesHelper::GenerateNilaiJuriNew($id_proposal,$proposal->status);

            $model = new ProposalInovasiModel();
            $model->update($id_proposal, [
                'nilai_validasi_lapangan' => $nilai_juri
            ]);

            session()->setFlashdata('success', "Data berhasil disimpan");
            return redirect()->to(base_url('admin/proposal_inovasi/validasi_lapangan'));
        }        
    }

    public function indexTA()
    {
        return view('proposal_inovasi/indexTA');
    }

    public function indexTR()
    {
        return view('proposal_inovasi/indexTR');
    }

    public function indexTR2()
    {
        return view('proposal_inovasi/indexTR2');
    }

    public function indexTJ()
    {
        return view('proposal_inovasi/indexTJ');
    }

    public function get_data_tim($id_hak_akses)
    {
        $request = Services::request();
        $data = new ProposalInovasiModel($request, 0, $id_hak_akses);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $no;
                        $row[] = $list->nama_pengusul;
                        $row[] = $list->nama_satuan_kerja;
                        $row[] = $list->judul;
                        $row[] = $list->tema;
                        $row[] = $list->tahapan;
                        $row[] = $list->kategori;
                        $row[] = $list->waktu_pembuatan;
                        $row[] = $list->skor;
                        $row[] = $list->skor_verifikasi;

                        if(session()->get('id_hak_akses') == 5 || session()->get('id_hak_akses') == 1)
                        {
                            $row[] = $list->penilaian_juri;
                        }
                        $row[] = '<a href="'.base_url('admin/proposal_inovasi/indikator/'.$list->id).'" class="btn btn-primary btn-sm">Indikator</a>';

                        if($list->status == "DRAFT" && (session()->get('id_hak_akses') == 2 || session()->get('id_hak_akses') == 1) )
                        {
                            $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>
                                    <a href="javascript:;" title="Kirim" class="text-success" onclick="Kirim('.$list->id.')"><i class="fas fa-location-arrow"></i></a>';

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "TA" && (session()->get('id_hak_akses') == 3 || session()->get('id_hak_akses') == 1))
                        {
                            $row[] = '<a href="javascript:;" title="Terima" class="text-success" onclick="AksiTA('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                                    <a href="javascript:;" title="Tolak" class="text-danger" onclick="AksiTA('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "TR" && (session()->get('id_hak_akses') == 4 || session()->get('id_hak_akses') == 1))
                        {
                            $row[] = '<a href="javascript:;" title="Terima" class="text-success" onclick="AksiTR('.$list->id.',1)"><i class="fas fa-check-circle"></i></a>  
                                    <a href="javascript:;" title="Tolak" class="text-danger" onclick="AksiTR('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                        }
                        else if($list->status == "TJ" && (session()->get('id_hak_akses') == 5 || session()->get('id_hak_akses') == 1))
                        {
                            if(InovakesHelper::CheckProposalSudahDinilaiJuri($list->id))
                            {
                                $row[] = '<a href="'.base_url('admin/proposal_inovasi/pemberian_nilai/'.$list->id).'" title="Pemberian Nilai" class="text-success"><i class="fas fa-check-double"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                            }
                            else
                            {
                                $row[] = '<a href="javascript:;" title="Tolak" class="text-danger" onclick="AksiTJ('.$list->id.',0)"><i class="fas fa-times-circle"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/pemberian_nilai/'.$list->id).'" title="Pemberian Nilai" class="text-success"><i class="fas fa-check-double"></i></a> |
                                    <a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/edit/'.$list->id).'" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';

                                    // <a href="javascript:;" title="Hapus" class="text-danger" onclick="Hapus('.$list->id.')"><i class="fas fa-trash"></i></a>
                            }
                            
                        }
                        else
                        {
                            $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>
                                    <a href="'.base_url('admin/proposal_inovasi/download/'.$list->id).'" title="Download Proposal" class="text-warning"><i class="fas fa-download"></i></a>';
                        }
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function get_data_tim2($id_hak_akses)
    {
        $request = Services::request();
        $data = new ProposalInovasiModel($request, 0, $id_hak_akses);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $no;
                        $row[] = $list->nama_pengusul;
                        $row[] = $list->nama_satuan_kerja;
                        $row[] = $list->judul;
                        $row[] = $list->tema;
                        $row[] = $list->tahapan;
                        $row[] = $list->kategori;
                        $row[] = $list->waktu_pembuatan;
                        $row[] = $list->skor;
                        $row[] = $list->skor_verifikasi;

                        if(session()->get('id_hak_akses') == 5 || session()->get('id_hak_akses') == 1)
                        {
                            $row[] = $list->penilaian_juri;
                        }
                        $row[] = '<a href="'.base_url('admin/proposal_inovasi/indikator/'.$list->id).'" class="btn btn-primary btn-sm">Indikator</a>';
                        $row[] = '<a href="'.base_url('admin/proposal_inovasi/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function get_urusan_utama_detail($urusan_utama_id)
    {
        $detail = new UrusanUtamaDetailModel();
        $data = $detail->where('urusan_utama_id', $urusan_utama_id)->findAll();

        return $this->response->setJSON($data);
    }

    public function review_inovasi_daerah()
    {
        return view('proposal_inovasi/review_inovasi_daerah');
    }

    public function hasil_review()
    {
        return view('proposal_inovasi/hasil_review');
    }

    public function inovasi_ditolak()
    {
        return view('proposal_inovasi/inovasi_ditolak');
    }

    public function presentasi()
    {
        return view('proposal_inovasi/presentasi');
    }

    public function validasi_lapangan()
    {
        return view('proposal_inovasi/validasi_lapangan');
    }

    public function export()
    {         
        $status = $_GET['status'];  
        $spreadsheet = new Spreadsheet();

        $model = new ProposalInovasiModel();

        if($status == 'all')
        {
            $fileName = $_GET['sumber'].'.xlsx'; 
            $data = $model->select('proposal_inovasi.*, u.name as nama_pengusul')
                    ->select('ha.nama_hak_akses')
                    ->select('bid.nama as nama_bentuk_inovasi')
                    ->select('uu.nama as nama_urusan_utama')
                    ->join('user as u','proposal_inovasi.user_id = u.id')
                    ->join('hak_akses as ha','u.id_hak_akses = ha.id')
                    ->join('bentuk_inovasi_daerah as bid','proposal_inovasi.bentuk_inovasi_daerah_id = bid.id')
                    ->join('urusan_utama as uu','proposal_inovasi.urusan_utama_id = uu.id')
                    ->where('proposal_inovasi.sumber', $_GET['sumber'])
                    // ->where('proposal_inovasi.status', 'SELESAI')                    
                    // ->where('proposal_inovasi.tahun', $tahun)
                    ->findAll();
        }
        else
        {
            $fileName = $_GET['sumber'].'_'.$_GET['status'].'.xlsx'; 
            $data = $model->select('proposal_inovasi.*, u.name as nama_pengusul')
                    ->select('ha.nama_hak_akses')
                    ->select('bid.nama as nama_bentuk_inovasi')
                    ->select('uu.nama as nama_urusan_utama')
                    ->join('user as u','proposal_inovasi.user_id = u.id')
                    ->join('hak_akses as ha','u.id_hak_akses = ha.id')
                    ->join('bentuk_inovasi_daerah as bid','proposal_inovasi.bentuk_inovasi_daerah_id = bid.id')
                    ->join('urusan_utama as uu','proposal_inovasi.urusan_utama_id = uu.id')
                    ->where('proposal_inovasi.sumber', $_GET['sumber'])
                    ->where('proposal_inovasi.status', $status)                    
                    // ->where('proposal_inovasi.tahun', $tahun)
                    ->findAll();
        }
    
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'No');
        $sheet->setCellValue('B1', 'Role');
        $sheet->setCellValue('C1', 'Nama Inovator');
        $sheet->setCellValue('D1', 'Nama Inovasi');
        $sheet->setCellValue('E1', 'Tahapan');
        $sheet->setCellValue('F1', 'Nilai Proposal');
        $sheet->setCellValue('G1', 'Nilai Mandiri');
        $sheet->setCellValue('H1', 'Nilai Verifikasi');
        $sheet->setCellValue('I1', 'Kelengkapan Parameter');
        $sheet->setCellValue('J1', 'Nilai Data Dukung');        
        $sheet->setCellValue('K1', 'Video');        
        $sheet->setCellValue('L1', 'Status');        
        $sheet->setCellValue('M1', 'Sumber Inovasi');        
        $sheet->setCellValue('N1', 'Inisiator Inovasi Daerah');        
        $sheet->setCellValue('O1', 'Jenis');        
        $sheet->setCellValue('P1', 'Bentuk Inovasi Daerah');        
        $sheet->setCellValue('Q1', 'Urusan Utama');        
        $sheet->setCellValue('R1', 'Urusan lain yang beririsan');        
        $sheet->setCellValue('S1', 'Waktu Uji Coba Inovasi Daerah');        
        $sheet->setCellValue('T1', 'Waktu Penerapan Inovasi Daerah');        
         
        $rows = 2;
        $no = 1;
        foreach ($data as $val){
            $ProposalUrusanUtamaModel = new ProposalUrusanUtamaModel();

            $dataurusanUtama = $ProposalUrusanUtamaModel->select('u.nama')
                    ->join('urusan_utama as u','proposal_urusan_utama.urusan_utama_id = u.id')
                    ->where('proposal_urusan_utama.proposal_inovasi_id', $val->id)   
                    ->findAll();
            $arr_duu = [];
            foreach($dataurusanUtama as $duu)
            {
                $arr_duu[] = $duu->nama;
            }

            $sheet->setCellValue('A' . $rows, $no++);
            $sheet->setCellValue('B' . $rows, $val->nama_hak_akses);
            $sheet->setCellValue('C' . $rows, $val->nama_pengusul);
            $sheet->setCellValue('D' . $rows, $val->judul);
            $sheet->setCellValue('E' . $rows, $val->tahapan);
            $sheet->setCellValue('F' . $rows, ($val->nilai_proposal ?? '0'));
            $sheet->setCellValue('G' . $rows, $val->skor);
            $sheet->setCellValue('H' . $rows, $val->skor_verifikasi);
            $sheet->setCellValue('I' . $rows, number_format($val->kelengkapan_indikator,2));
            $sheet->setCellValue('J' . $rows, number_format($val->nilai_data_dukung,2));
            $sheet->setCellValue('K' . $rows, InovakesHelper::GetOnlyUrlYoutube($val->id));
            $sheet->setCellValue('L' . $rows, $val->status);
            $sheet->setCellValue('M' . $rows, $val->sumber);
            $sheet->setCellValue('N' . $rows, $val->inisiator);
            $sheet->setCellValue('O' . $rows, $val->jenis);
            $sheet->setCellValue('P' . $rows, $val->nama_bentuk_inovasi);
            $sheet->setCellValue('Q' . $rows, $val->nama_urusan_utama);
            $sheet->setCellValue('R' . $rows, implode(",", $arr_duu));
            $sheet->setCellValue('S' . $rows, date('d-M-Y', strtotime($val->waktu_uji_coba)));
            $sheet->setCellValue('T' . $rows, date('d-M-Y', strtotime($val->waktu_penerapan)));
            
            $rows++;
        } 
        $writer = new Xlsx($spreadsheet);
        header("Content-Type: application/vnd.ms-excel");
        header('Content-Disposition: attachment;filename='.$fileName);
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
        die();
    }
}
