<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\ProvinsiModel;
use App\Models\KabupatenModel;
use App\Models\OrganisasiModel;

class Register extends BaseController
{
    public function index()
    {
        $provinsi = new ProvinsiModel();
        $org = new OrganisasiModel();

        $data['provinsi'] = $provinsi->findAll();
        $data['organisasi'] = $org->findAll();
        
        return view('front/register', $data);
    }

    public function proses()
    {
        session()->setFlashdata('error', 'Kompetisi INOVAKES sudah ditutup!');
        return redirect()->back();

        if (!$this->validate([
            'email' => [
                'rules' => 'required|min_length[4]|max_length[50]|is_unique[user.email]',
                'errors' => [
                    'required' => '{field} Harus diisi',
                    'min_length' => '{field} Minimal 4 Karakter',
                    'max_length' => '{field} Maksimal 50 Karakter',
                    'is_unique' => 'Email sudah terdaftar'
                ]
            ],
            'nip' => [
                'rules' => 'required|min_length[4]|max_length[50]|is_unique[user.nip]',
                'errors' => [
                    'required' => '{field} Harus diisi',
                    'min_length' => '{field} Minimal 4 Karakter',
                    'max_length' => '{field} Maksimal 50 Karakter',
                    'is_unique' => 'NIP sudah terdaftar'
                ]
            ],
            'password' => [
                'rules' => 'required|min_length[4]|max_length[50]',
                'errors' => [
                    'required' => '{field} Harus diisi',
                    'min_length' => '{field} Minimal 4 Karakter',
                    'max_length' => '{field} Maksimal 50 Karakter',
                ]
            ],
            'password_confirmation' => [
                'rules' => 'matches[password]',
                'errors' => [
                    'matches' => 'Konfirmasi Password tidak sesuai dengan password',
                ]
            ],
        ])) 
        {
            session()->setFlashdata('error', $this->validator->listErrors());
            return redirect()->back()->withInput();
        }

        // $dataSKP = $this->request->getFile('file_pendukung');
		// $fileNameSKP = $dataSKP->getRandomName();
		// $dataSKP->move('uploads/file_skp/', $fileNameSKP);

        $dataFoto = $this->request->getFile('file_foto');
		$fileNameFoto = $dataFoto->getRandomName();
		$dataFoto->move('uploads/foto/', $fileNameFoto);

        $users = new UserModel();
        $users->insert([
            'name' => $this->request->getVar('name'),
            'email' => $this->request->getVar('email'),
            'password' => password_hash($this->request->getVar('password'), PASSWORD_BCRYPT),
            'id_hak_akses' => 2,
            'is_aktif' => 1,
            'nip' => $this->request->getVar('nip'),
            'tanggal_lahir' => $this->request->getVar('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getVar('jenis_kelamin'),
            'id_provinsi' => $this->request->getVar('id_provinsi'),
            'id_kabupaten' => $this->request->getVar('id_kabupaten'),
            'alamat' => $this->request->getVar('alamat'),
            'no_telp' => $this->request->getVar('no_telp'),
            'id_organisasi' => $this->request->getVar('id_organisasi'),
            'id_satuan_organisasi' => $this->request->getVar('id_satuan_organisasi'),
            'file_skp' => $this->request->getVar('dokumenskp'),
            'kd_golongan' => $this->request->getVar('kd_golongan'),
            'nama_golongan' => $this->request->getVar('nama_golongan'),
            'kepangkatan' => $this->request->getVar('kepangkatan'),
            'nama_jabatan' => $this->request->getVar('nama_jabatan'),
            'foto' => $fileNameFoto,
            'kode_organisasi' => $this->request->getVar('kode_organisasi'),
            'nama_organisasi' => $this->request->getVar('nama_organisasi'),
            'kode_satuan_kerja' => $this->request->getVar('kode_satuan_kerja'),
            'nama_satuan_kerja' => $this->request->getVar('nama_satuan_kerja'),
        ]);

        session()->setFlashdata('success', "Registrasi berhasil, silahkan login");
        return redirect()->to(base_url('login'));
    }

    public function GetToken()
    {
        $client = \Config\Services::curlrequest();
        $resp = $client->request('POST', 'https://api-ropeg.kemkes.go.id/inovakes/login', [
                        'form_params' => [
                                'f_username' => '1n0vak3s2021',
                                'f_password' => 'k0mp3t1siInov4s12o21',
                        ],
                        'verify' => false
                ]);
        
        $result = json_decode($resp->getBody());

        if($result->result == "true")
        {
            return $result->token;
        }
        else
        {
            return "-";
        }
    }

    public function GetDataPegawai()
    {
        $token = $this->GetToken();
        $nip = $this->request->getVar('term');
        // $nip = "198702112010121004";

        $client = \Config\Services::curlrequest();
        $resp = $client->request('POST', 'https://api-ropeg.kemkes.go.id/inovakes/get_pegawai', [
                        'form_params' => [
                                'f_token' => $token,
                                'f_nip' => $nip,
                        ],
                        'verify' => false
                ]);

        $result = json_decode($resp->getBody());

        if($result->result == "true")
        {
            return $this->response->setJSON($result->data);
        }
        else
        {
            return "-";
        }
    }
}
