<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ProposalInovasiModel;
use App\Models\IndikatorModel;
use App\Models\ParameterModel;
use App\Models\ProsesSirkulasiModel;
use App\Models\ProposalIndikatorDataPendukungModel;
use App\Models\ProposalIndikatorModel;
use App\Models\AspekPenilaianIndikatorModel;
use App\Models\AspekPenilaianModel;
use App\Models\PenilaianModel;
use App\Models\PenilaianSummaryModel;
use App\Helpers\InovakesHelper;
use Config\Services;
use App\Models\UserModel;
use App\Models\BentukInovasiDaerahModel;
use App\Models\UrusanUtamaModel;
use App\Models\UrusanUtamaDetailModel;
use App\Models\ProposalUrusanUtamaDetailModel;
use App\Models\ProposalUrusanUtamaModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Report extends BaseController
{
    private $db;

    public function __construct()
    {
        $this->db = db_connect();
    }

    public function index_lomba_inovasi()
    {        
        $inovasi = new ProposalInovasiModel();
        $tahun = $inovasi->select('tahun')->where('tahun !=', null)->groupBy('tahun')->orderBy('tahun', 'ASC')->findAll();

        $data['tahun'] = $tahun;
        return view('report/index_lomba_inovasi', $data);      
    }

    public function index_ranking_inovasi()
    {        
        $inovasi = new ProposalInovasiModel();
        $tahun = $inovasi->select('tahun')->where('tahun !=', null)->groupBy('tahun')->orderBy('tahun', 'ASC')->findAll();

        $data['tahun'] = $tahun;
        return view('report/index_ranking_inovasi', $data);      
    }

    public function get_data()
    {
        $request = Services::request();
        if(in_array(session()->get('id_hak_akses'), [7,8,9,10])) //Pegawai
        {
            $data = new ProposalInovasiModel($request, session()->get('user_id'), 0, 0, $_GET['sumber'], 'report');
        }
        else
        {
            $data = new ProposalInovasiModel($request, 0, 0, 0, $_GET['sumber'], 'report');
        }

        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        
                        $no++;
                        $row = [];

                        // if($list->status == "SELESAI")
                        // {
                        //     $row[] = $no.' <i class="fas fa-check-circle text-success"></i>';
                        // }
                        // else
                        // {
                        //     $row[] = $no;
                        // }
                        $row[] = $no;
                        $row[] = $list->nama_hak_akses;
                        $row[] = $list->nama_pengusul;
                        $row[] = $list->judul;
                        $row[] = ($list->nilai_proposal ?? '0'); //nilai proposal
                        $row[] = $list->skor;
                        $row[] = $list->skor_verifikasi;//nilai indikator
                        $row[] = number_format($list->nilai_presentasi,2);
                        $row[] = number_format($list->nilai_validasi_lapangan,2);                        
                        $row[] = number_format((($list->nilai_proposal ?? 0) + $list->skor_verifikasi + $list->nilai_presentasi + $list->nilai_validasi_lapangan),2);
                        $row[] = '<a href="'.base_url('admin/report/detail/'.$list->id).'" title="Detail" class="text-primary"><i class="fas fa-eye"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => count($datas),
                "recordsFiltered" => count($datas),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function export($tahun)
    {
        $fileName = $_GET['sumber'].'.xlsx';  
        $spreadsheet = new Spreadsheet();

        $model = new ProposalInovasiModel();

        $data = $model->select('proposal_inovasi.*, u.name as nama_pengusul')
                    ->select('ha.nama_hak_akses')
                    ->select('bid.nama as nama_bentuk_inovasi')
                    ->join('user as u','proposal_inovasi.user_id = u.id')
                    ->join('hak_akses as ha','u.id_hak_akses = ha.id')
                    ->join('bentuk_inovasi_daerah as bid','proposal_inovasi.bentuk_inovasi_daerah_id = bid.id')
                    ->where('proposal_inovasi.status !=', 'DRAFT')
                    ->where('proposal_inovasi.sumber', $_GET['sumber'])
                    ->where('proposal_inovasi.tahun', $tahun)
                    ->findAll();
    
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'No');
        $sheet->setCellValue('B1', 'Instansi');
        $sheet->setCellValue('C1', 'Nama Inovator');
        $sheet->setCellValue('D1', 'Nama Inovasi');
        $sheet->setCellValue('E1', 'Bentuk Inovasi Daerah');        
        $sheet->setCellValue('F1', 'Skor Proposal');
        $sheet->setCellValue('G1', 'Skor Mandiri');
        $sheet->setCellValue('H1', 'Skor Verifikasi');
        $sheet->setCellValue('I1', 'Skor Presentasi');
        $sheet->setCellValue('J1', 'Skor Validasi Lapangan');
        $sheet->setCellValue('K1', 'Total Skor');        
         
        $rows = 2;
        $no = 1;
        foreach ($data as $val){
            $sheet->setCellValue('A' . $rows, $no++);
            $sheet->setCellValue('B' . $rows, $val->nama_hak_akses);
            $sheet->setCellValue('C' . $rows, $val->nama_pengusul);
            $sheet->setCellValue('D' . $rows, $val->judul);
            $sheet->setCellValue('E' . $rows, $val->nama_bentuk_inovasi);
            $sheet->setCellValue('F' . $rows, ($val->nilai_proposal ?? '0'));
            $sheet->setCellValue('G' . $rows, $val->skor);
            $sheet->setCellValue('H' . $rows, $val->skor_verifikasi);
            $sheet->setCellValue('I' . $rows, number_format($val->nilai_presentasi,2));
            $sheet->setCellValue('J' . $rows, number_format($val->nilai_validasi_lapangan,2));
            $sheet->setCellValue('K' . $rows, number_format((($val->nilai_proposal ?? 0) + $val->skor_verifikasi + $val->nilai_presentasi + $val->nilai_validasi_lapangan),2));
            
            $rows++;
        } 
        $writer = new Xlsx($spreadsheet);
        header("Content-Type: application/vnd.ms-excel");
        header('Content-Disposition: attachment;filename='.$fileName);
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
        die();
    }

    public function detail($id)
    {
        $data = new ProposalInovasiModel();
        $proposal = $data->where('id', $id)->first();

        $user_model = new UserModel();
        $user = $user_model->find($proposal->user_id);

        $model = new PenilaianModel();

        $model_juri = new PenilaianSummaryModel();
        $presentasi = $model_juri->select('MAX(u.name) as nama_juri, SUM(penilaian_summary.nilai) as total_nilai')
                    ->join('user as u','penilaian_summary.user_id = u.id')
                    ->groupBy('penilaian_summary.user_id')
                    ->where('penilaian_summary.id_proposal', $id)
                    ->where('penilaian_summary.tipe', 'PRESENTASI')
                    ->findAll();

        $validasi_lapangan = $model_juri->select('MAX(u.name) as nama_juri, SUM(penilaian_summary.nilai) as total_nilai')
        ->join('user as u','penilaian_summary.user_id = u.id')
        ->groupBy('penilaian_summary.user_id')
        ->where('penilaian_summary.id_proposal', $id)
        ->where('penilaian_summary.tipe', 'VALIDASI LAPANGAN')
        ->findAll();


        $param['proposal'] = $proposal;
        $param['user'] = $user;
        $param['presentasi'] = $presentasi;
        $param['validasi_lapangan'] = $validasi_lapangan;
        $param['provinsi'] = $user_model->provinsi($user->id_provinsi);
        $param['kabupaten'] = $user_model->kabupaten($user->id_kabupaten);
        $param['organisasi'] = $user_model->organisasi($user->id_organisasi);
        $param['satuan_organisasi'] = $user_model->satuan_organisasi($user->id_satuan_organisasi);

        return view('report/detail', $param);
    }
}
