<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UrusanUtamaModel;
use App\Models\UrusanUtamaDetailModel;
use Config\Services;

class UrusanUtamaDetail extends BaseController
{
    public function index()
    {
        $urusan_utama = new UrusanUtamaModel();
        $data['urusan_utama'] = $urusan_utama->findAll();
        return view('urusan_utama_detail/index', $data);
    }

    public function get_data()
    {
        $request = Services::request();
        $data = new UrusanUtamaDetailModel($request);
        
        if($request->getMethod(true)=='POST'){
            $lists = $data->get_datatables();
                $datas = [];
                $no = $request->getPost("start");
                foreach ($lists as $list) {
                        $no++;
                        $row = [];
                        $row[] = $list->urusan_utama;
                        $row[] = $list->nama;
                        $row[] = '<a href="javascript:;" onclick="edit_data('.$list->id.')" data-toggle="modal" data-target="#modal-tambah" title="Edit" class="text-info"><i class="fas fa-pencil-alt"></i></a>
                                    <a href="javascript:;" title="Hapus" class="text-danger" onclick="hapus('.$list->id.')"><i class="fas fa-trash"></i></a>';
                        
                        $datas[] = $row;
            }

            $output = [
                "draw" => $request->getPost('draw'),
                "recordsTotal" => $data->count_all(),
                "recordsFiltered" => $data->count_filtered(),
                "data" => $datas
            ];

            echo json_encode($output);
        }
    }

    public function simpan()
    {
        $id = $this->request->getVar('id');
        $name = $this->request->getVar('nama');
        $urusan_utama_id = $this->request->getVar('urusan_utama_id');

        $model = new UrusanUtamaDetailModel();

        if($id != 0)
        {
            //Update
            $model->update($id, [
                'urusan_utama_id' => $urusan_utama_id,
                'nama' => $name,
            ]);
        }
        else
        {
            //Create
            $model->insert([
                'urusan_utama_id' => $urusan_utama_id,
                'nama' => $name,
            ]);
        }

        $resp['status'] = true;
        $resp['message'] = "Data berhasil disimpan";

        return $this->response->setJSON($resp);
    }

    public function edit($id)
    {
        $model = new UrusanUtamaDetailModel();
        $data = $model->find($id);

        return $this->response->setJSON($data);
    }

    public function hapus($id)
    {
        $model = new UrusanUtamaDetailModel();
        $data = $model->delete($id);

        $resp['status'] = true;
        $resp['message'] = "Data berhasil dihapus";

        return $this->response->setJSON($resp);
    }
}
