<?php

namespace App\Helpers;
use App\Models\ProposalIndikatorModel;
use App\Models\ParameterModel;
use App\Models\ProposalIndikatorDataPendukungModel;
use App\Models\PenilaianModel;
use App\Models\IndikatorModel;
use App\Models\ProposalInovasiModel;
use App\Models\CarouselModel;

class InovakesHelper
{
    public static function GetParameterProposalIndikator($id_proposal, $id_indikator)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('proposal_indikator as pi');
        $builder->select('p.id as id_parameter, p.nama as nama_parameter');
        $builder->join('parameter as p','pi.id_parameter = p.id');
        $builder->where('pi.id_indikator', $id_indikator);
        $builder->where('pi.id_proposal', $id_proposal);
        
        $data = $builder->get()->getResult();
        return (count($data) == 0 ? null : $data[0]->nama_parameter);
    }

    public static function GetNilaiProposalIndikator($id_proposal, $id_indikator)
    {
        if(self::CheckDataPendukung($id_proposal, $id_indikator) == "Ada")
        {
            $db      = \Config\Database::connect();
            $builder = $db->table('proposal_indikator as pi');
            $builder->where('pi.id_indikator', $id_indikator);
            $builder->where('pi.id_proposal', $id_proposal);
            
            $data = $builder->get()->getResult();
            return (count($data) == 0 ? 0 : $data[0]->nilai);
        }
        else
        {
            return 0;
        }        
    }

    public static function GetNilaiVerifikasiProposalIndikator($id_proposal, $id_indikator)
    {
        if(self::CheckDataPendukung($id_proposal, $id_indikator) == "Ada")
        {
            $db      = \Config\Database::connect();
            $builder = $db->table('proposal_indikator as pi');
            $builder->where('pi.id_indikator', $id_indikator);
            $builder->where('pi.id_proposal', $id_proposal);
            
            $data = $builder->get()->getResult();
            return (count($data) == 0 ? 0 : $data[0]->nilai_verifikasi);
        }
        else
        {
            return 0;
        }        
    }

    public static function CheckDataPendukung($id_proposal, $id_indikator)
    {
        $model = new ProposalIndikatorDataPendukungModel();

        $data = $model->where('id_proposal', $id_proposal)
                        ->where('id_indikator', $id_indikator)
                        ->first();

        return ($data == null ? "Tidak Ada" : "Ada");
    }

    public static function GetNilai($id_proposal, $id_aspek_penilaian_indikator, $user_id)
    {
        $model = new PenilaianModel();
        $data = $model->where('id_proposal', $id_proposal)
                    ->where('id_aspek_penilaian_indikator', $id_aspek_penilaian_indikator)
                    ->where('user_id', $user_id)
                    ->first();

        return ($data == null ? 0 : $data->nilai);
    }

    public static function GenerateNilaiParameterIndikator($id_indikator, $nilai)
    {
        $model = new IndikatorModel();
        $data = $model->where('id', $id_indikator)->first();

        if($data != null)
        {
            return ($data->bobot * $nilai);
        }
        else
        {
            return 0;
        }
    }

    public static function GetIndikatorSudahUpload($id_proposal)
    {
        $db      = \Config\Database::connect();
        $builder = $db->table('proposal_indikator_data_pendukung');
        $builder->select('id_indikator');
        $builder->get();

        return $builder->get();
    }

    public static function GetArrIndikatorDataPendukung($id_proposal)
    {
        $db_a      = \Config\Database::connect();
        $buildera = $db_a->table('proposal_indikator_data_pendukung as a');
        $buildera->select('a.id_indikator as id_indikator');
        $buildera->where('a.id_proposal', $id_proposal);

        $resulta = $buildera->get()->getResult();

        $arr_indikator = [];

        foreach($resulta as $val)
        {
            $arr_indikator[] = $val->id_indikator;
        }

        return $arr_indikator;
    }

    public static function GenerateSkor($id_proposal)
    {
        $arr_indikator = self::GetArrIndikatorDataPendukung($id_proposal);

        if(count($arr_indikator) == 0)
        {
            return 0;
        }
        else 
        {
            $db      = \Config\Database::connect();
            $builder = $db->table('proposal_indikator');
            $builder->where('id_proposal', $id_proposal);
            $builder->whereIn('id_indikator', $arr_indikator);
            $builder->selectSum('nilai');

            return $builder->get()->getResult();
        }

        
    }

    public static function GenerateSkorVerifikasi($id_proposal)
    {
        $arr_indikator = self::GetArrIndikatorDataPendukung($id_proposal);

        if(count($arr_indikator) == 0)
        {
            return 0;
        }
        else
        {
            $db      = \Config\Database::connect(); 
            $builder = $db->table('proposal_indikator');
            $builder->where('id_proposal', $id_proposal);
            $builder->whereIn('id_indikator', $arr_indikator);
            $builder->selectSum('nilai_verifikasi');

            return $builder->get()->getResult();
        }        
    }

    public static function IsAksesUpdateParameterDataPendukung($id_proposal, $datapendukung = null)
    {
        $id_hak_akses = session()->get('id_hak_akses');
        $model = new ProposalInovasiModel();
        $data = $model->where("id", $id_proposal)->first();

        //yg bisa update itu pegawai dan tim review
        if(in_array($id_hak_akses, [1,3,4,5,7,8,9,10]))
        {
            if($data->status == "DRAFT")
            {
                return true;
            }
            else if(in_array($id_hak_akses, [1,3,4,5]) && $data->status != "DRAFT")
            {
                if($datapendukung != null)
                {
                    return false;
                }
                else
                {
                    return true;
                }                
            }
            else{
                return false;
            }
        }
        {
            return false;
        }
    }

    public static function CheckProposalSudahDinilaiJuri($id_proposal)
    {
        $model = new PenilaianModel();
        
        $data = $model->where('id_proposal', $id_proposal)->first();

        if($data != null)
        {
            return true; //sudah ada juri yang submit
        }
        else
        {
            return false;
        }
    }

    public static function CheckJuriSudahSubmitPenilaian($id_proposal, $user_id, $tipe = null)
    {
        $model = new PenilaianModel();
        
        $data = $model->where('id_proposal', $id_proposal)
                        ->where('user_id', $user_id)
                        ->where('tipe', $tipe)
                        ->first();

        if($data != null)
        {
            return true; //juri ybs sudah menilai
        }
        else
        {
            return false;
        }
    }

    public static function GenerateNilaiJuri($id_proposal)
    {
        $db      = \Config\Database::connect(); 
        $builder = $db->table('penilaian_summary');
        $builder->where('id_proposal', $id_proposal);
        $builder->selectCount('id_proposal');
        $result = $builder->get()->getResult();

        $pembagi = $result[0]->id_proposal / 2;

        $dbs      = \Config\Database::connect();
        $builders = $dbs->table('penilaian_summary');
        $builders->where('id_proposal', $id_proposal);
        $builders->selectSum("nilai");
        $query = $builders->get()->getResult();

        $total_nilai = $query[0]->nilai;

        return $total_nilai / $pembagi;
    }

    public static function GenerateNilaiJuriNew($id_proposal, $status)
    {
        // $db      = \Config\Database::connect(); 
        // $builder = $db->table('penilaian');
        // $builder->where('id_proposal', $id_proposal);
        // $builder->selectCount('id_proposal');
        // $result = $builder->get()->getResult();

        // $pembagi = $result[0]->id_proposal;

        // $dbs      = \Config\Database::connect();
        // $builders = $dbs->table('penilaian_summary');
        // $builders->where('id_proposal', $id_proposal);
        // $builders->where('tipe', $status);
        // $builders->selectSum("nilai");
        // $query = $builders->get()->getResult();

        // $total_nilai = $query[0]->nilai / $pembagi;

        $dbs      = \Config\Database::connect();
        $builders = $dbs->table('penilaian_summary');
        $builders->where('id_proposal', $id_proposal);
        $builders->where('tipe', $status);
        $builders->selectAvg("nilai");
        $query = $builders->get()->getResult();

        $total_nilai = $query[0]->nilai;

        return $total_nilai;
    }

    public static function GetCarousel()
    {
        $model = new CarouselModel();

        return $model->findAll();
    }

    public static function GetUrlYoutube($id_proposal)
    {
        $ProposalIndikatorDataPendukungModel = new ProposalIndikatorDataPendukungModel();
        $data_pendukung = $ProposalIndikatorDataPendukungModel->where('id_proposal', $id_proposal)->where('tipe', 'Video')->first();

        return $data_pendukung == null ? "N/A" : '<a href="'.$data_pendukung->url_youtube.'" target="_blank">Klik disini</a>';
    }

    public static function GetOnlyUrlYoutube($id_proposal)
    {
        $ProposalIndikatorDataPendukungModel = new ProposalIndikatorDataPendukungModel();
        $data_pendukung = $ProposalIndikatorDataPendukungModel->where('id_proposal', $id_proposal)->where('tipe', 'Video')->first();

        return $data_pendukung == null ? "-" : $data_pendukung->url_youtube;
    }

    public static function GetNilaiJuri($id_proposal, $id_aspek_penilaian)
    {
        $penilaianModel = new PenilaianModel();
        $penilaian = $penilaianModel->where('id_proposal', $id_proposal)
                        ->where('user_id', session()->get('user_id'))
                        ->where('id_aspek_penilaian', $id_aspek_penilaian)
                        ->first();

        return $penilaian == null ? "" : $penilaian->nilai ;
    } 
}