<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\HTTP\RequestInterface;

class ProposalInovasiModel extends Model
{
    protected $table = "proposal_inovasi";
    protected $useTimestamps = true;
    protected $returnType = "object";
    protected $allowedFields = ['judul', 'tema', 'tahapan', 'waktu_pembuatan', 'jenis', 'kategori', 'deskripsi', 'tujuan', 'aspek_kebaharuan', 'aspek_efektivitas', 'aspek_bermanfaat', 'aspek_transferabilitas', 'aspek_kompatibilatas', 'sumber_daya', 'keterlibatan_pemangku_kepentingan', 'proses_inovasi', 'user_id', 'status', 'covid19','skor','skor_verifikasi','penilaian_juri','sumber','inisiator','bentuk_inovasi_daerah_id','urusan_utama_id','waktu_uji_coba','waktu_penerapan','rancang_bangun','manfaat','hasil_inovasi','file_anggaran','file_profile_bisnis','nilai_proposal','kelengkapan_indikator','nilai_data_dukung','nilai_presentasi','nilai_validasi_lapangan','tahun'];

    protected $column_order = ['proposal_inovasi.sumber','proposal_inovasi.judul', 'proposal_inovasi.tahapan', 'proposal_inovasi.jenis', 'proposal_inovasi.tujuan', 'proposal_inovasi.proses_inovasi', 'proposal_inovasi.user_id', 'proposal_inovasi.status','proposal_inovasi.skor','proposal_inovasi.skor_verifikasi','proposal_inovasi.penilaian_juri','u.name','u.nama_organisasi','u.nama_satuan_kerja','proposal_inovasi.inisiator','proposal_inovasi.waktu_uji_coba','proposal_inovasi.waktu_penerapan','proposal_inovasi.rancang_bangun','proposal_inovasi.manfaat','proposal_inovasi.hasil_inovasi','ha.nama_hak_akses','proposal_inovasi.nilai_proposal','proposal_inovasi.kelengkapan_indikator','proposal_inovasi.nilai_data_dukung','proposal_inovasi.nilai_presentasi','proposal_inovasi.nilai_validasi_lapangan','proposal_inovasi.tahun'];
    protected $column_search = ['proposal_inovasi.sumber','proposal_inovasi.judul', 'proposal_inovasi.tahapan', 'proposal_inovasi.jenis', 'proposal_inovasi.tujuan', 'proposal_inovasi.proses_inovasi', 'proposal_inovasi.user_id', 'proposal_inovasi.status', 'proposal_inovasi.skor','proposal_inovasi.skor_verifikasi','proposal_inovasi.penilaian_juri','u.name','u.nama_organisasi','u.nama_satuan_kerja','proposal_inovasi.inisiator','proposal_inovasi.waktu_uji_coba','proposal_inovasi.waktu_penerapan','proposal_inovasi.rancang_bangun','proposal_inovasi.manfaat','proposal_inovasi.hasil_inovasi','ha.nama_hak_akses','proposal_inovasi.nilai_proposal','proposal_inovasi.kelengkapan_indikator','proposal_inovasi.nilai_data_dukung','proposal_inovasi.nilai_presentasi','proposal_inovasi.nilai_validasi_lapangan','proposal_inovasi.tahun'];
    protected $order = array('id' => 'desc','judul' => 'desc', 'tema' => 'desc', 'tahapan' => 'desc', 'waktu_pembuatan' => 'desc', 'jenis' => 'desc', 'kategori' => 'desc', 'deskripsi' => 'desc', 'tujuan' => 'desc', 'aspek_kebaharuan' => 'desc', 'aspek_efektivitas' => 'desc', 'aspek_bermanfaat' => 'desc', 'aspek_transferabilitas' => 'desc', 'aspek_kompatibilatas' => 'desc', 'sumber_daya' => 'desc', 'keterlibatan_pemangku_kepentingan' => 'desc', 'proses_inovasi' => 'desc', 'user_id' => 'desc', 'status' => 'desc', 'covid19' => 'desc','skor' => 'desc','skor_verifikasi' => 'desc','penilaian_juri' => 'desc','sumber' => 'desc','inisiator' => 'desc','bentuk_inovasi_daerah_id' => 'desc','urusan_utama_id' => 'desc','waktu_uji_coba' => 'desc','waktu_penerapan' => 'desc','rancang_bangun' => 'desc','manfaat' => 'desc','hasil_inovasi' => 'desc','file_anggaran' => 'desc','file_profile_bisnis' => 'desc','nilai_proposal' => 'desc','kelengkapan_indikator' => 'desc','nilai_data_dukung' => 'desc','nilai_presentasi' => 'desc','nilai_validasi_lapangan' => 'desc','tahun' => 'desc');
    protected $request;
    protected $db;
    protected $dt;
    protected $builder;

    //status
    const DRAFT = "DRAFT";
    const REVIEW = "REVIEW";
    const HASILREVIEW = "HASIL REVIEW";
    const PRESENTASI = "PRESENTASI";
    const VALIDASILAPANGAN = "VALIDASI LAPANGAN";
    const SELESAI = "SELESAI";
    const DITOLAK = "INOVASI DITOLAK";

    function __construct(RequestInterface $request = null, $id_user = 0, $id_hak_akses = 0, $laporan = 0, $sumber = null, $status = null){
        parent::__construct();
        $this->db = db_connect();
        $this->request = $request;

        if($id_user == 0)
        {
            $this->dt = $this->db->table($this->table)
                            ->select('u.name as nama_pengusul')
                            ->select('u.nama_organisasi')
                            ->select('u.nama_satuan_kerja as nama_satuan_kerja')
                            ->select('proposal_inovasi.*')                            
                            ->select('ha.nama_hak_akses')                            
                            ->join('user as u','proposal_inovasi.user_id = u.id')
                            ->join('hak_akses as ha','u.id_hak_akses = ha.id');
        }            
        else
        {
            $this->dt = $this->db->table($this->table)
                            ->select('proposal_inovasi.*')
                            ->select('u.name as nama_pengusul')
                            ->select('u.nama_organisasi')
                            ->select('u.nama_satuan_kerja as nama_satuan_kerja')
                            ->select('ha.nama_hak_akses')
                            ->join('user as u','proposal_inovasi.user_id = u.id')
                            ->join('hak_akses as ha','u.id_hak_akses = ha.id')
                            // ->join('organisasi as o','u.id_organisasi = o.id')
                            // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
                            ->where('proposal_inovasi.user_id', $id_user);
        } 
        
        if($status != null)
        {
            if($status == 'report')
            {
                $this->dt = $this->db->table($this->table)
                            ->select('proposal_inovasi.*')
                            ->select('u.name as nama_pengusul')
                            ->select('u.nama_organisasi')
                            ->select('u.nama_satuan_kerja as nama_satuan_kerja')
                            ->select('ha.nama_hak_akses')
                            ->join('user as u','proposal_inovasi.user_id = u.id')
                            ->join('hak_akses as ha','u.id_hak_akses = ha.id')
                            // ->join('organisasi as o','u.id_organisasi = o.id')
                            // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
                            ->where('proposal_inovasi.status !=', 'DRAFT');
            }
            else
            {
                $this->dt = $this->db->table($this->table)
                            ->select('proposal_inovasi.*')
                            ->select('u.name as nama_pengusul')
                            ->select('u.nama_organisasi')
                            ->select('u.nama_satuan_kerja as nama_satuan_kerja')
                            ->select('ha.nama_hak_akses')
                            ->join('user as u','proposal_inovasi.user_id = u.id')
                            ->join('hak_akses as ha','u.id_hak_akses = ha.id')
                            // ->join('organisasi as o','u.id_organisasi = o.id')
                            // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
                            ->where('proposal_inovasi.status', $status);
            }
            
        }

        // if($id_hak_akses == 3) //TA
        // {
        //     $this->dt = $this->db->table($this->table)
        //                     ->select('proposal_inovasi.*')
        //                     ->select('u.name as nama_pengusul')
        //                     ->select('u.nama_organisasi')
        //                     ->select('u.nama_satuan_kerja as nama_satuan_kerja')
        //                     ->select('ha.nama_hak_akses')
        //                     ->join('user as u','proposal_inovasi.user_id = u.id')
        //                     ->join('hak_akses as ha','u.id_hak_akses = ha.id')
        //                     // ->join('organisasi as o','u.id_organisasi = o.id')
        //                     // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
        //                     ->whereIn('proposal_inovasi.status', ['TA','TR','TJ']);
        // }
        // else if($id_hak_akses == 4) //TR
        // {
        //     $this->dt = $this->db->table($this->table)
        //                     ->select('proposal_inovasi.*')
        //                     ->select('u.name as nama_pengusul')
        //                     ->select('u.nama_organisasi')
        //                     ->select('ha.nama_hak_akses')
        //                     ->select('u.nama_satuan_kerja as nama_satuan_kerja')
        //                     ->join('user as u','proposal_inovasi.user_id = u.id')
        //                     ->join('hak_akses as ha','u.id_hak_akses = ha.id')
        //                     // ->join('organisasi as o','u.id_organisasi = o.id')
        //                     // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
        //                     ->where('proposal_inovasi.status', 'TR');
        // }
        // else if($id_hak_akses == 5) //TJ
        // {
        //     $this->dt = $this->db->table($this->table)
        //                     ->select('proposal_inovasi.*')
        //                     ->select('u.name as nama_pengusul')
        //                     ->select('u.nama_organisasi')
        //                     ->select('u.nama_satuan_kerja as nama_satuan_kerja')
        //                     ->select('ha.nama_hak_akses')
        //                     ->join('user as u','proposal_inovasi.user_id = u.id')
        //                     ->join('hak_akses as ha','u.id_hak_akses = ha.id')
        //                     // ->join('organisasi as o','u.id_organisasi = o.id')
        //                     // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
        //                     ->where('proposal_inovasi.status', 'TJ');
        // }

        // if($laporan == 3) //TA
        // {
        //     $this->dt = $this->db->table($this->table)
        //                     ->select('proposal_inovasi.*')
        //                     ->select('u.name as nama_pengusul')
        //                     ->select('u.nama_organisasi')
        //                     ->select('u.nama_satuan_kerja as nama_satuan_kerja')
        //                     ->select('ha.nama_hak_akses')
        //                     ->join('user as u','proposal_inovasi.user_id = u.id')
        //                     ->join('hak_akses as ha','u.id_hak_akses = ha.id')
        //                     // ->join('organisasi as o','u.id_organisasi = o.id')
        //                     // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
        //                     ->whereIn('proposal_inovasi.status', ['TA']);
        // }
        // else if($laporan == 4) //TR
        // {
        //     $this->dt = $this->db->table($this->table)
        //                     ->select('proposal_inovasi.*')
        //                     ->select('u.name as nama_pengusul')
        //                     ->select('u.nama_organisasi')
        //                     ->select('u.nama_satuan_kerja as nama_satuan_kerja')
        //                     ->select('ha.nama_hak_akses')
        //                     ->join('user as u','proposal_inovasi.user_id = u.id')
        //                     ->join('hak_akses as ha','u.id_hak_akses = ha.id')
        //                     // ->join('organisasi as o','u.id_organisasi = o.id')
        //                     // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
        //                     ->where('proposal_inovasi.status', 'TR');
        // }
        // else if($laporan == 5) //TJ
        // {
        //     $this->dt = $this->db->table($this->table)
        //                     ->select('proposal_inovasi.*')
        //                     ->select('u.name as nama_pengusul')
        //                     ->select('u.nama_organisasi')
        //                     ->select('u.nama_satuan_kerja as nama_satuan_kerja')
        //                     ->select('ha.nama_hak_akses')
        //                     ->join('user as u','proposal_inovasi.user_id = u.id')
        //                     ->join('hak_akses as ha','u.id_hak_akses = ha.id')
        //                     // ->join('organisasi as o','u.id_organisasi = o.id')
        //                     // ->join('satuan_organisasi as so','u.id_satuan_organisasi = so.id')
        //                     ->where('proposal_inovasi.status', 'TJ');
        // }

        $data_final = $this->dt;

        if($sumber !== null)
        {
            $this->dt = $data_final->where('proposal_inovasi.sumber', $sumber);
        }

        if($this->request != null)
        {
            if($this->request->getGet('tahun') != null)
            {
                if($this->request->getGet('tahun') != 'All')
                {
                    $this->dt = $data_final->where('proposal_inovasi.tahun', $this->request->getGet('tahun'));
                }            
            }
        }        

        if($this->request != null)
        {
            $i = 0;
            foreach ($this->column_search as $item){
                if($this->request->getPost('search') != null)
                {
                    if($this->request->getPost('search')['value']){ 
                        if($i===0){
                            $this->dt->groupStart();
                            $this->dt->like($item, $this->request->getPost('search')['value']);
                        }
                        else{
                            $this->dt->orLike($item, $this->request->getPost('search')['value']);
                        }
                        if(count($this->column_search) - 1 == $i)
                            $this->dt->groupEnd();
                    }
                    $i++; 
                }                          
            }
            
            if($this->request->getPost('order')){
                $this->dt->orderBy($this->column_order[$this->request->getPost('order')['0']['column']], $this->request->getPost('order')['0']['dir']);
            } 
            else if(isset($this->order)){
                $order = $this->order;
                $this->dt->orderBy(key($order), $order[key($order)]);
            }
        } 
        
        // $this->dt->orderBy('skor', 'DESC');
    }

    private function _get_datatables_query(){
        $i = 0;
        foreach ($this->column_search as $item){
            if($this->request->getPost('search')['value']){ 
                if($i===0){
                    $this->dt->groupStart();
                    $this->dt->like($item, $this->request->getPost('search')['value']);
                }
                else{
                    $this->dt->orLike($item, $this->request->getPost('search')['value']);
                }
                if(count($this->column_search) - 1 == $i)
                    $this->dt->groupEnd();
            }
            $i++;
        }
         
        if($this->request->getPost('order')){
            $this->dt->orderBy($this->column_order[$this->request->getPost('order')['0']['column']], $this->request->getPost('order')['0']['dir']);
        } 
        else if(isset($this->order)){
            $order = $this->order;
            $this->dt->orderBy(key($order), $order[key($order)]);
        }
    }

    function get_datatables(){
        // $this->_get_datatables_query();
        if($this->request->getPost('length') != -1)
         $this->dt->limit($this->request->getPost('length'), $this->request->getPost('start'));
        $query = $this->dt->get();
        return $query->getResult();
    }

    function count_filtered(){
        // $this->_get_datatables_query();
        return $this->dt->countAllResults();
    }

    public function count_all(){
        $tbl_storage = $this->db->table($this->table);
        return $tbl_storage->countAllResults();
    }

    public function GetNamaUser($user_id)
    {
        $model = new UserModel();
        $data = $model->where('id', $user_id)->first();

        return ($data == null ? "N/A" : $data->name);
    }
}