<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Indikator</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Indikator</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <div class="card-header-action">
        <button class="btn btn-primary" data-toggle="modal" data-target="#modal-tambah" onclick="bersih();">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah
        </butt>
    </div>
  </div>
  <div class="card-body">

        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>Bobot</th>
                    <th>Jenis</th>
                    <th>Jenis File</th>
                    <th>Keterangan</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('modal') ?>
<div class="modal fade" id="modal-tambah" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Indikator</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" id="frm_data">
                <?= csrf_field() ?>
                <div class="modal-body">
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Nama</label> 
                                <input type="text" class="form-control" name="nama" id="nama" required> 
                                <input type="hidden" name="id" id="id">
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Bobot</label> 
                                <input type="number" class="form-control" name="bobot" id="bobot" required> 
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Jenis</label> 
                                <select class="form-control" name="jenis" id="jenis">
                                    <option value="Pilihan">Pilihan</option>
                                    <option value="Textarea">Textarea</option>
                                    <option value="Progress">Progress</option>
                                    <option value="Number">Number</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Keterangan Indikator</label> 
                                <textarea class="form-control" name="keterangan" id="keterangan"></textarea>
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Jenis File</label> 
                                <select class="form-control" name="jenis_file" id="jenis_file">
                                    <option value="PDF">Dokumen PDF</option>
                                    <option value="Gambar">Gambar</option>
                                    <option value="Video">Video (Link)</option>
                                    <option value="PPT">PPT</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Keterangan Data Pendukung</label> 
                                <textarea class="form-control" name="keterangan_data_pendukung" id="keterangan_data_pendukung"></textarea>
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Indeks Inovasi</label> 
                                <select class="form-control" name="indeks_inovasi_required" id="indeks_inovasi_required" required>
                                    <option value="1">Wajib Isi</option>
                                    <option value="0">Tidak Wajib Isi</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Lomba Inovasi</label> 
                                <select class="form-control" name="lomba_inovasi_required" id="lomba_inovasi_required" required>
                                    <option value="1">Wajib Isi</option>
                                    <option value="0">Tidak Wajib Isi</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                    <div class="row"> 
                        <div class="col-md-12"> 
                            <div class="form-group"> 
                                <label class="control-label">Proper</label> 
                                <select class="form-control" name="proper_required" id="proper_required" required>
                                    <option value="1">Wajib Isi</option>
                                    <option value="0">Tidak Wajib Isi</option>
                                </select> 
                            </div> 
                        </div>
                    </div>
                    
                </div>
                <div class="modal-footer bg-whitesmoke br">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var table_data = $("#tblData").DataTable({
        processing: true,
        serverSide: true,
        "ordering": false,
        ajax: {
            "url": "<?php echo base_url('admin/indikator/get_data')?>",
            "type": "POST"
        }
    });      

    function edit_data(id)
    {  
        var url = "<?= base_url('admin/indikator/edit') ?>/"+id;
        
        $.ajax({
            url: url,
            type: "GET",
            success: function(data){
                $("#id").val(data.id);
                $("#nama").val(data.nama);
                $("#bobot").val(data.bobot);
                $("#keterangan").val(data.keterangan);
                $("#jenis").val(data.jenis);
                $("#jenis_file").val(data.jenis_file);
                $("#keterangan_data_pendukung").val(data.keterangan_data_pendukung);
                $("#indeks_inovasi_required").val(data.indeks_inovasi_required);
                $("#lomba_inovasi_required").val(data.lomba_inovasi_required);
                $("#proper_required").val(data.proper_required);
            },
            error: function(data){
                alert('Hubungi Admin !');
            }
        });
    }

    function bersih()
    {
        $("#id").val(0);
        $("#nama").val("");
        $("#bobot").val("");
        $("#keterangan").val("");
        $("#jenis").val("");
        $("#jenis_file").val("");
        $("#keterangan_data_pendukung").val("");
        $("#indeks_inovasi_required").val("");
        $("#lomba_inovasi_required").val("");
        $("#proper_required").val("");
    }

    function hapus(id)
    {
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: "GET",
                    url: "<?= base_url('admin/indikator/hapus') ?>/"+id,
                    success: function(data){
                        table_data.ajax.reload();
                        swal("Terhapus!", data.message, "success");
                    },
                    error: function(data){
                        table_data.ajax.reload();
                        swal("GAGAL!", data.responseJSON.message, "error");
                    }
                })
            }
        });
    }

    $("#frm_data").on("submit", function(e){
        e.preventDefault();
        $("#modal-tambah").modal('hide');
        $.ajax({
            type:"POST",
            url: "<?= base_url('admin/indikator/simpan') ?>",
            data: $(this).serialize(),
            success: function(result){
                table_data.ajax.reload();
                
                if(result.status)
                    swal("Sukses", result.message, "success");
                else
                    swal("Gagal", result.message, "error");
            }
        })
    });  
</script>

<?= $this->endSection() ?>