<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Laporan</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Laporan</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <!-- <div class="card-header-action">
        <?php if(session()->get('id_hak_akses') == 2): ?>
        <a href="/admin/proposal_inovasi/tambah" class="btn btn-primary">
          <i class="fa fa-plus" aria-hidden="true"></i> Tambah Proposal
        </a>
        <?php endif ?>
    </div> -->
  </div>
  <div class="card-body">

    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item">
        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Tim Administrasi</a>
        </li>
        <li class="nav-item">
        <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Tim Review</a>
        </li>
        <li class="nav-item">
        <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Tim Juri</a>
        </li>
    </ul>

    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
            <div class="text-right" style="padding-bottom: 25px">
                <a href="<?= base_url('admin/laporan/export/TA') ?>" class="btn btn-info text-white">Export Excel</a>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="tblTimAdministrasi" style="width:100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Pengusul</th>
                        <th>Judul</th>
                        <th>Satuan Kerja</th>
                        <th>Tema</th>
                        <th>Tahapan</th>
                        <th>Kategori</th>
                        <th>Skor Mandiri</th>
                        <th>Skor PP</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
            <div class="text-right" style="padding-bottom: 25px">
                <a href="<?= base_url('admin/laporan/export/TR') ?>" class="btn btn-info text-white">Export Excel</a>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="tblTimReview" style="width:100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Pengusul</th>
                        <th>Judul</th>
                        <th>Satuan Kerja</th>
                        <th>Tema</th>
                        <th>Tahapan</th>
                        <th>Kategori</th>
                        <th>Skor Mandiri</th>
                        <th>Skor PP</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
            <div class="text-right" style="padding-bottom: 25px">
                <a href="<?= base_url('admin/laporan/export/TJ') ?>" class="btn btn-info text-white">Export Excel</a>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="tblTimJuri" style="width:100%;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Pengusul</th>
                        <th>Judul</th>
                        <th>Satuan Kerja</th>
                        <th>Tema</th>
                        <th>Tahapan</th>
                        <th>Kategori</th>
                        <th>Skor Mandiri</th>
                        <th>Skor PP</th>
                        <th>Skor Tim Juri</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
                </table>
            </div>
        </div>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var tableTA = $("#tblTimAdministrasi").DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            "url": "<?php echo base_url('admin/laporan/3')?>",
            "type": "POST"
        }
    });  
    var tableTR = $("#tblTimReview").DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            "url": "<?php echo base_url('admin/laporan/4')?>",
            "type": "POST"
        }
    });  
    var tableTJ = $("#tblTimJuri").DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            "url": "<?php echo base_url('admin/laporan/5')?>",
            "type": "POST"
        }
    });  

    
</script>

<?= $this->endSection() ?>