<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Profile Pendaftar</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Profile Pendaftar</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Detail Tim</h4>
  </div>
  <div class="card-body">
    
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/profile_pendaftar/update_tim') ?>">
    <?= csrf_field() ?>
    <div class="row">                    
        <label class="form-group col-3">Foto</label>
        <div class="form-group col-9">
            <img src="<?= base_url('uploads/foto/'.$user->foto) ?>" width="100" height="120" alt="Foto">
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">NIP</label>
        <div class="form-group col-9">
            : <?= $user->nip ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Nama Lengkap dan Gelar</label>
        <div class="form-group col-6">
            : <?= $user->name ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Jabatan</label>
        <div class="form-group col-6">
            : <?= $user->nama_jabatan ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Nama Golongan</label>
        <div class="form-group col-6">
            : <?= $user->nama_golongan ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Kepangkatan</label>
        <div class="form-group col-6">
            : <?= $user->kepangkatan ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Organisasi</label>
        <div class="form-group col-6">
            : <?= $user->nama_organisasi ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Satuan Kerja</label>
        <div class="form-group col-6">
            : <?= $user->nama_satuan_kerja ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Tanggal Lahir</label>
        <div class="form-group col-6">
            : <?= $user->tanggal_lahir ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Jenis Kelamin</label>
        <div class="form-group col-6">
            : <?= $user->jenis_kelamin ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Provinsi</label>
        <div class="form-group col-6">
            : <?= $provinsi ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Kabupaten</label>
        <div class="form-group col-6">
            : <?= $kabupaten ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Alamat Kantor</label>
        <div class="form-group col-6">
            : <?= $user->alamat ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">Email</label>
        <div class="form-group col-6">
            : <?= $user->email ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">No Telp</label>
        <div class="form-group col-6">
            : <?= $user->no_telp ?>
        </div>
    </div>
    <div class="row">                    
        <label class="form-group col-3">File SKP </label>
        <div class="form-group col-6">
            : <a href="<?= base_url('uploads/file_skp/'.$user->file_skp) ?>">SKP <i class="fas fa-download"></i></a>
        </div>
    </div>
    
    <div class="form-group">
        <a href="<?= base_url('admin/profile_pendaftar/detail/'.$user->user_id) ?>" class="btn btn-primary btn-lg text-white">
            Kembali
        </a>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<?= $this->endSection() ?>