<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/bootstrap-timepicker/css/bootstrap-timepicker.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>
<div class="section-header">
    <h1>Profile Pendaftar</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Profile Pendaftar</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="row mt-sm-4">
    <div class="col-12 col-md-12 col-lg-4">
      <div class="card author-box">
        <div class="card-body">
          <div class="author-box-center">
            <figure class="avatar mr-2 avatar-xl bg-warning text-white" data-initial="<?= $inisial ?>">
              <img src="<?= base_url('uploads/foto/'.$user->foto) ?>" alt="">
            </figure>
            <div class="clearfix"></div>
            <div class="author-box-name" style="margin-top: 25px">
              <a href="javascript:;"><?= $user->name ?></a>
            </div>
            <div class="author-box-job"><?= $user->email ?></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-12 col-lg-8">
      <div class="card">
        <div class="padding-20">
          <ul class="nav nav-tabs" id="myTab2" role="tablist">
            
            <li class="nav-item">
              <a class="nav-link active" id="profile-tab2" data-toggle="tab" href="#settings" role="tab"
                aria-selected="false">Profile</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" id="profile-tab2" data-toggle="tab" href="#updatePassword" role="tab"
                aria-selected="false">Update Password</a>
            </li>
          </ul>
          <div class="tab-content tab-bordered" id="myTab3Content">
            <div class="tab-pane fade show active" id="settings" role="tabpanel" aria-labelledby="profile-tab2">
              <form method="post" action="<?= base_url('admin/profile_pendaftar/update_profile') ?>" class="needs-validation" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="card-header">
                  <h4>Profile Pendaftar <span style="color: #5864bd">(Apabila inisiator berasal dari masyarakat maka isi biodata seperlunya)<span></h4>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="form-group col-12">
                        <label for="nik">NIP</label>
                        <input id="id" type="hidden" class="form-control" name="id" value="<?= $user->id ?>" required>
                        <input type="hidden" class="form-control" name="nama_file_skp" value="<?= $user->file_skp ?>" required>
                        <input type="hidden" class="form-control" name="nama_foto" value="<?= $user->foto ?>" required>
                        <input id="nip" type="number" class="form-control" name="nip" value="<?= $user->nip ?>">
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="name">Nama Lengkap Inovator / Nama OPD</label>
                        <input id="name" type="text" class="form-control" name="name" value="<?= $user->name ?>" autofocus required>
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="nama_jabatan">Jabatan</label>
                        <input id="nama_jabatan" type="text" class="form-control" name="nama_jabatan" value="<?= $user->nama_jabatan ?>">
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="nama_golongan">Nama Golongan</label>
                        <input id="nama_golongan" type="text" class="form-control" name="nama_golongan" value="<?= $user->nama_golongan ?>">
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="kepangkatan">Kepangkatan</label>
                        <input id="kepangkatan" type="text" class="form-control" name="kepangkatan" value="<?= $user->kepangkatan ?>">
                    </div>
                  </div>

                    <div class="row">                    
                        <div class="form-group col-6">
                            <label for="id_organisasi">Organisasi</label>
                            <input type="text" name="nama_organisasi" id="nama_organisasi" class="form-control" value="<?= $user->nama_organisasi ?>">
                        </div>
                        <div class="form-group col-6">
                            <label for="id_satuan_organisasi">Satuan Kerja</label>
                            <input type="text" name="nama_satuan_kerja" id="nama_satuan_kerja" class="form-control" value="<?= $user->nama_satuan_kerja ?>">
                        </div>
                    </div>

                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="tanggal_lahir">Tanggal Lahir</label>
                        <input id="tanggal_lahir" type="date" class="form-control" value="<?= $user->tanggal_lahir ?>" name="tanggal_lahir">
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="jenis_kelamin">Jenis Kelamin</label>
                        <select name="jenis_kelamin" id="jenis_kelamin" class="form-control">
                            <option value="">-- Pilih Jenis Kelamin --</option>
                            <option value="Laki-Laki" <?= $user->jenis_kelamin == "Laki-Laki" ? "selected" : "" ?>>Laki-Laki</option>
                            <option value="Perempuan" <?= $user->jenis_kelamin == "Perempuan" ? "selected" : "" ?>>Perempuan</option>
                        </select>
                    </div>
                  </div>

                  <div class="row">
                    <div class="form-group col-md-12 col-12">
                        <label for="Alamat">Alamat</label>
                        <textarea name="alamat" id="alamat" class="form-control"><?= $user->alamat ?></textarea>
                    </div>
                  </div>

                  <!-- <div class="row">                    
                    <div class="form-group col-6">
                        <label for="id_provinsi">Provinsi</label>
                        <select name="id_provinsi" id="id_provinsi" class="form-control" onchange="getKabKota()">
                        <option value="">-- Pilih Provinsi--</option>
                        <?php foreach ($provinsi as $item): ?>

                        <option value="<?= $item->id ?>" <?= $user->id_provinsi == $item->id ? "selected" : "" ?>><?= $item->name ?></option>

                        <?php endforeach;?>
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="id_kabupaten">Kabupaten/Kota</label>
                        <select name="id_kabupaten" id="id_kabupaten" class="form-control">
                            <option value="">-- Pilih Kabupaten/Kota --</option>
                            <?php foreach ($kab as $item): ?>
                                <option value="<?= $item->id ?>" <?= $user->id_kabupaten == $item->id ? "selected" : "" ?> ><?= $item->name ?></option>
                            <?php endforeach;?>
                        </select>
                    </div>
                </div> -->

                  <div class="row">
                    <div class="form-group col-md-6 col-12">
                        <label for="Alamat">Email</label>
                        <input id="email" type="text" class="form-control" name="email" required value="<?= $user->email ?>">
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="no_telp">No Telp</label>
                        <input id="no_telp" type="text" class="form-control" name="no_telp" value="<?= $user->no_telp ?>">
                    </div>
                  </div>

                  

                  <div class="row">                    
                    <div class="form-group col-md-6 col-12">
                        <label for="file_pendukung">Dokumen SKP</label>
                        <br>
                        <!-- <input type="file" name="file_pendukung" id="file_pendukung" class="form-control"> -->
                        <a href="<?= $user->file_skp ?>">Dokumen SKP <i class="fas fa-download"></i></a>
                    </div>
                    <div class="form-group col-md-6 col-12">
                        <label for="file_foto">Foto</label>
                        <input type="file" name="file_foto" id="file_foto" class="form-control" onchange="checkfile(this);">
                    </div>
                  </div>

                  
                </div>
                <div class="card-footer text-right">
                  <button class="btn btn-primary">Save Changes</button>
                </div>
              </form>
            </div>

            <div class="tab-pane fade show" id="updatePassword" role="tabpanel" aria-labelledby="profile-tab2">
                <form method="post" action="<?= base_url('admin/profile_pendaftar/update_password') ?>" class="needs-validation">
                    <?= csrf_field() ?>
                    <input type="hidden" class="form-control" name="id_user_pwd" value="<?= $user->id ?>">
                    <div class="row">                    
                        <div class="form-group col-md-12 col-12">
                            <label for="password">Password Baru</label>
                            <input type="password" name="password" id="password" class="form-control" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-12 col-12">
                            <button class="btn btn-primary" type="submit">Update Password</button>
                        </div>
                    </div>
                    
                </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Data Anggota Tim</h4>

    <div class="card-header-action">
        <a href="<?= base_url('admin/profile_pendaftar/tambah_tim/'.$user->id) ?>" class="btn btn-primary text-white">
          <i class="fa fa-plus"></i> Tambah
        </a>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblDataAnggota" style="width:100%;">
          <thead>
            <tr>
                <th>NIP</th>
                <th>Nama</th>
                <th>Organisasi</th>
                <th>Alamat Kantor</th>
                <th>aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($user_tim as $val): ?>
              <tr>
                  <td><?= $val->nip ?></td>
                  <td><?= $val->name ?></td>
                  <td><?= $val->nama_organisasi ?></td>
                  <td><?= $val->alamat ?></td>
                  <td>
                    <a href="<?= base_url('admin/profile_pendaftar/edit_tim/'.$val->id) ?>" class="btn btn-primary text-white" alt="Edit"><i class="fas fa-pencil-alt"></i></a>
                    <a href="<?= base_url('admin/profile_pendaftar/detail_tim/'.$val->id) ?>" class="btn btn-info text-white" alt="Detail"><i class="far fa-eye"></i></a>
                    <button onclick="hapus(<?= $val->id ?>)" class="btn btn-danger text-white" alt="Hapus"><i class="fas fa-trash"></i></button>
                  </td>
              </tr>
            <?php endforeach ?>
          </tbody>
        </table>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('modal') ?>
<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script src="<?= base_url('assets/bundles/bootstrap-timepicker/js/bootstrap-timepicker.min.js') ?>"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    $(".timepicker").timepicker({
        icons: {
            up: 'fas fa-chevron-up',
            down: 'fas fa-chevron-down'
        },
        showMeridian: false
    });

    $("#tblDataAnggota").DataTable();

    function getKabKota()
    {
        var id_provinsi = $("#id_provinsi").val();
        $("#id_kabupaten").empty();

        var option = "";
        $.get("<?= base_url('get-kab-kota') ?>/" + id_provinsi, function(result){

            $.each(result, function(i,l){

                option += '<option value='+ l.id + '>'+l.name+'</option>';

            });

            $("#id_kabupaten").html(option);

        });
    }

    function getSatuanOrganisasi()
    {
        var id_organisasi = $("#id_organisasi").val();
        $("#id_satuan_organisasi").empty();

        var option = "";
        $.get("<?= base_url('get-satuan-organisasi') ?>/" + id_organisasi, function(result){

            $.each(result, function(i,l){

                option += '<option value='+ l.id + '>'+l.kode+' - '+l.nama+'</option>';

            });

            $("#id_satuan_organisasi").html(option);

        });
    }

    function hapus(id)
    {
       var url = "<?= base_url('admin/profile_pendaftar/delete_tim') ?>" + id;
       swal({
          title: "Anda yakin ?",
          text: "Akan menghapus data ini!",
          icon: "warning",
          buttons: true,
          dangerMode: true
      })
      .then((willDelete) => {
          if (willDelete) {
              window.location.href = url;
          }
      });
    }

    function checkfile(sender) {
        var validExts = new Array(".jpg",".jpeg",".png");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file_foto").val('');
                return false;
        }

        return true;
    }

</script>
<?= $this->endSection() ?>