<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/select2/dist/css/select2.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Profile Pendaftar</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Profile Pendaftar</a></div>
    </div>
</div>

<div class="card card-primary">
  <div class="card-header">
    <h4>Tambah Tim</h4>
  </div>
  <div class="card-body">
    <?php if (!empty(session()->getFlashdata('error'))) : ?>
        <div class="alert alert-danger">
        <?php echo session()->getFlashdata('error'); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty(session()->getFlashdata('success'))) : ?>
        <div class="alert alert-success">
        <?php echo session()->getFlashdata('success'); ?>
        </div>
    <?php endif; ?>
  <form method="POST" enctype="multipart/form-data" action="<?= base_url('admin/profile_pendaftar/simpan_tim') ?>">
    <?= csrf_field() ?>
    <div class="row">                    
        <div class="form-group col-12">
            <label for="nik">NIP</label>
            <input id="id_user" type="hidden" class="form-control" name="id_user" value="<?= $id_user ?>">
            <input id="nip" type="hidden" class="form-control" name="nip" required>
            <input id="dokumenskp" type="hidden" class="form-control" name="dokumenskp" required>
            <input id="kd_golongan" type="hidden" class="form-control" name="kd_golongan">
            <input id="kode_organisasi" type="hidden" class="form-control" name="kode_organisasi">
            <input id="kode_satuan_kerja" type="hidden" class="form-control" name="kode_satuan_kerja">
            <!-- <select name="nip2" id="nip2" class="form-control" required></select> -->
            <input id="nip2" type="number" class="form-control" name="nip2">
        </div>
    </div>

    <div class="row">     
        <div class="form-group col-6">
            <label for="name">Nama Lengkap Inovator / Nama OPD</label>
            <input id="name" type="text" class="form-control" name="name" required>
        </div>
        <div class="form-group col-6">
            <label for="nama_jabatan">Jabatan</label>
            <input id="nama_jabatan" type="text" class="form-control" name="nama_jabatan">
        </div>
    </div>

    <div class="row">     
        <div class="form-group col-6">
            <label for="nama_golongan">Nama Golongan</label>
            <input id="nama_golongan" type="text" class="form-control" name="nama_golongan">
        </div>
        <div class="form-group col-6">
            <label for="kepangkatan">Kepangkatan</label>
            <input id="kepangkatan" type="text" class="form-control" name="kepangkatan">
        </div>
    </div>

    <div class="row">                    
        <div class="form-group col-6">
            <label for="id_organisasi">Organisasi</label>
            <input type="text" name="nama_organisasi" id="nama_organisasi" class="form-control">
        </div>
        <div class="form-group col-6">
            <label for="id_satuan_organisasi">Satuan Kerja</label>
            <input type="text" name="nama_satuan_kerja" id="nama_satuan_kerja" class="form-control">
        </div>
    </div>

    <div class="row">                    
        <div class="form-group col-6">
            <label for="tanggal_lahir">Tanggal Lahir</label>
            <input id="tanggal_lahir" type="date" class="form-control" name="tanggal_lahir" required>
        </div>
        <div class="form-group col-6">
            <label for="jenis_kelamin">Jenis Kelamin</label>
            <select name="jenis_kelamin" id="jenis_kelamin" class="form-control" required>
                <option value="">-- Pilih Jenis Kelamin --</option>
                <option value="Laki-Laki">Laki-Laki</option>
                <option value="Perempuan">Perempuan</option>
            </select>
        </div>
    </div>

    <div class="form-group">                    
        <label for="Alamat">Alamat</label>
        <textarea name="alamat" id="alamat" class="form-control" required></textarea>
    </div>

    <!-- <div class="row">                    
        <div class="form-group col-6">
            <label for="id_provinsi">Provinsi</label>
            <select name="id_provinsi" id="id_provinsi" class="form-control" onchange="getKabKota()" required>
            <option value="">-- Pilih Provinsi--</option>
            <?php foreach ($provinsi as $item): ?>

            <option value="<?= $item->id ?>"><?= $item->name ?></option>

            <?php endforeach;?>
            </select>
        </div>
        <div class="form-group col-6">
            <label for="id_kabupaten">Kabupaten/Kota</label>
            <select name="id_kabupaten" id="id_kabupaten" class="form-control" required>
                <option value="">-- Pilih Kabupaten/Kota --</option>
            </select>
        </div>
    </div> -->

    <div class="row">
        <div class="form-group col-6">
            <label for="email">Email</label>
            <input id="email" type="email" class="form-control" name="email" required>
            <div class="invalid-feedback">
            </div>
        </div>
        <div class="form-group col-6">
            <label for="no_telp">No Telp</label>
            <input id="no_telp" type="text" class="form-control" name="no_telp" required>
        </div>    
    </div>

    <div class="row">
        <!-- <div class="form-group col-6">
            <label for="file_pendukung">Upload SKP tahun Terakhir</label>
            <input type="file" name="file_pendukung" id="file_pendukung" class="form-control" required>
        </div> -->
        <div class="form-group col-12">
            <label for="file_foto">Upload Foto</label>
            <input type="file" name="file_foto" id="file_foto" class="form-control" onchange="checkfile(this);">
        </div>
    </div>

    <!-- <div class="form-group">
    <div class="custom-control custom-checkbox">
        <input type="checkbox" name="agree" class="custom-control-input" id="agree">
        <label class="custom-control-label" for="agree">I agree with the terms and conditions</label>
    </div>
    </div> -->
    <div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg btn-block">
        SIMPAN
    </button>
    </div>
</form>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/select2/dist/js/select2.full.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/bootstrap-daterangepicker/daterangepicker.js') ?>"></script>
<script>

    // $(document).ready(function(){          
    //     $("#nip2").select2({
    //           placeholder: 'Cari NIP',
    //           minimumInputLength: 18,
    //           ajax: {
    //               url: "<?= base_url('GetDataPegawai') ?>",
    //               dataType: "json",
    //               type: "POST",
    //               data: function (params) {

    //                   var queryParameters = {
    //                       term: params.term
    //                   }
    //                   return queryParameters;
    //               },
    //               processResults: function (data) {
    //                   return {
    //                       results: $.map(data, function (item) {
    //                           return {
    //                               text: item.nip_baru,
    //                               id: JSON.stringify(item)
    //                           }
                              
    //                       })
    //                   };
    //               }
    //           }
    //     });
    // });

    // $(document.body).on("change","#nip2",function(){
    //     var result = JSON.parse(this.value);

    //     if(result.dokumenskp == null)
    //     {
    //       alert("Dokumen SKP anda belum ada dalam database Ropeg Kemenkes. Silahkan Upload File SKP di SILK Arsip Kemenkes");
    //     }
        
    //     $("#nip").val(result.nip_baru);
    //     if(result.gelar_depan == "")
    //     {
    //       $("#name").val(result.nama+", "+ result.gelar_belakang);
    //     }
    //     else
    //     {
    //       $("#name").val(result.gelar_depan+", "+result.nama+", "+ result.gelar_belakang);
    //     }
        
    //     $("#kode_organisasi").val(result.kd_organisasi);
    //     $("#nama_organisasi").val(result.nama_organisasi);
    //     $("#kode_satuan_kerja").val(result.kd_satuan_organisasi);
    //     $("#nama_satuan_kerja").val(result.nama_satuan_organisasi);

    //     if(result.jenis_kelamin == "L")
    //     {
    //       $("#jenis_kelamin").val("Laki-Laki");
    //     }
    //     else
    //     {
    //       $("#jenis_kelamin").val("Perempuan");
    //     }

    //     $("#kd_golongan").val(result.kd_golongan);
    //     $("#nama_golongan").val(result.nama_golongan);
    //     $("#kepangkatan").val(result.kepangkatan);
    //     $("#nama_jabatan").val(result.nama_jabatan);
    //     $("#dokumenskp").val(result.dokumenskp);
    //     $("#tanggal_lahir").val(result.tgl_lahir);
    //     $("#no_telp").val(result.telp);
        
    // });

    $('.datepicker').daterangepicker({
        locale: { format: 'YYYY-MM-DD' },
        singleDatePicker: true,
    });

    function getKabKota()
    {
        var id_provinsi = $("#id_provinsi").val();
        $("#id_kabupaten").empty();

        var option = "";
        $.get("<?= base_url('get-kab-kota') ?>/" + id_provinsi, function(result){

            $.each(result, function(i,l){

                option += '<option value='+ l.id + '>'+l.name+'</option>';

            });

            $("#id_kabupaten").html(option);

        });
    }

    function getSatuanOrganisasi()
    {
        var id_organisasi = $("#id_organisasi").val();
        $("#id_satuan_organisasi").empty();

        var option = "";
        $.get("<?= base_url('get-satuan-organisasi') ?>/" + id_organisasi, function(result){

            $.each(result, function(i,l){

                option += '<option value='+ l.id + '>'+l.kode+' - '+l.nama+'</option>';

            });

            $("#id_satuan_organisasi").html(option);

        });
    }

    function checkfile(sender) {
        var validExts = new Array(".jpg",".jpeg",".png");
        var fileExt = sender.value;
        fileExt = fileExt.substring(fileExt.lastIndexOf('.'));
        if (validExts.indexOf(fileExt) < 0) {
            alert("Format tidak didukung");
            $("#file_foto").val('');
                return false;
        }

        return true;
    }
</script>
<?= $this->endSection() ?>