<?= $this->extend('template/back/template') ?>

<?= $this->section('css') ?>
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/datatables.min.css') ?>">
<link rel="stylesheet" href="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/css/dataTables.bootstrap4.min.css') ?>">
<?= $this->endSection() ?>

<?= $this->section('isi') ?>

<div class="section-header">
    <h1>Proposal Inovasi</h1>
    <div class="section-header-breadcrumb" style="padding: 10px !important">
      <div class="breadcrumb-item"><a href="<?= base_url('admin/dashboard') ?>">Dashboard</a></div>
      <div class="breadcrumb-item active"><a href="#">Proposal Inovasi</a></div>
    </div>
</div>
<?php if (!empty(session()->getFlashdata('error'))) : ?>
    <div class="alert alert-danger">
    <?php echo session()->getFlashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if (!empty(session()->getFlashdata('success'))) : ?>
    <div class="alert alert-success">
    <?php echo session()->getFlashdata('success'); ?>
    </div>
<?php endif; ?>
<div class="card card-primary">
  <div class="card-header">
    <!-- <h4>Data Profile Pendaftar</h4> -->

    <div class="card-header-action">
        <?php if(\App\Helpers\InovakesHelper::IsAksesUpdateParameterDataPendukung($id_proposal, "Y")): ?>
          <a href="<?= base_url('admin/proposal_inovasi/data_pendukung/tambah?id_proposal='.$id_proposal.'&id_indikator='.$id_indikator) ?>" class="btn btn-primary">
            <i class="fa fa-plus" aria-hidden="true"></i> Tambah Data Pendukung
          </a>
        <?php endif ?>
        
        <a href="<?= base_url('admin/proposal_inovasi/indikator/'.$id_proposal) ?>" class="btn btn-warning text-white">
          Kembali
        </a>
    </div>
  </div>
  <div class="card-body">
  
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="tblData" style="width:100%;">
          <thead>
            <tr>
                <th>Nama</th>
                <!-- <th>Keterangan</th> -->
                <th>Data Pendukung</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
                <?php foreach($data as $val): ?>
                    <tr>
                        <td><?= $val->nama ?></td>
                        <!-- <td><?= $val->keterangan ?></td> -->
                        <td>
                          <?php if($val->tipe != "Video"): ?>
                            <a href="<?= base_url('uploads/data_pendukung/'. $val->file) ?>" target="_blank"><i class="fas fa-download"></i></a>
                          <?php else: ?>
                            <a href="<?= $val->url_youtube ?>" target="_blank">Buka Link</a>
                          <?php endif ?>
                        </td>
                        <td>
                        <?php if(\App\Helpers\InovakesHelper::IsAksesUpdateParameterDataPendukung($id_proposal, "Y")): ?>
                            <a href="<?= base_url('admin/proposal_inovasi/data_pendukung/edit?id='.$val->id) ?>"><i class="fas fa-pencil-alt"></i></a>
                            <a href="javascript:;" class="text-danger" onclick="Hapus(<?= $val->id ?>)"><i class="fas fa-trash"></i></a>
                        <?php endif ?>
                        </td>
                    </tr>
                <?php endforeach ?>
          </tbody>
        </table>
    </div>
  </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('js') ?>
<script src="<?= base_url('assets/bundles/datatables/datatables.min.js') ?>"></script>
<script src="<?= base_url('assets/bundles/datatables/DataTables-1.10.16/js/dataTables.bootstrap4.min.js') ?>"></script>

<script>
    var tableData = $("#tblData").DataTable();      

    function Hapus(id)
    {
        var url = "<?= base_url('admin/proposal_inovasi/data_pendukung/hapus') ?>?id=" + id;
        swal({
            title: "Anda yakin ?",
            text: "Akan menghapus data ini!",
            icon: "warning",
            buttons: true,
            dangerMode: true
        })
        .then((willDelete) => {
            if (willDelete) {
                window.location.href = url;
            }
        });
    } 
</script>

<?= $this->endSection() ?>